<?php

namespace Ups_address\UPSaddressStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ErrorDetailType UPSaddressStruct
 * @package Ups_address
 * @subpackage Structs
 */
class Ups_addressErrorDetailType extends AbstractStructBase
{
    /**
     * The Severity
     * @var string
     */
    public $Severity;
    /**
     * The PrimaryErrorCode
     * @var \Ups_address\UPSaddressStruct\Ups_addressCodeType
     */
    public $PrimaryErrorCode;
    /**
     * The MinimumRetrySeconds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $MinimumRetrySeconds;
    /**
     * The Location
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_address\UPSaddressStruct\Ups_addressLocationType
     */
    public $Location;
    /**
     * The SubErrorCode
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Ups_address\UPSaddressStruct\Ups_addressCodeType[]
     */
    public $SubErrorCode;
    /**
     * Constructor method for ErrorDetailType
     * @uses Ups_addressErrorDetailType::setSeverity()
     * @uses Ups_addressErrorDetailType::setPrimaryErrorCode()
     * @uses Ups_addressErrorDetailType::setMinimumRetrySeconds()
     * @uses Ups_addressErrorDetailType::setLocation()
     * @uses Ups_addressErrorDetailType::setSubErrorCode()
     * @param string $severity
     * @param \Ups_address\UPSaddressStruct\Ups_addressCodeType $primaryErrorCode
     * @param string $minimumRetrySeconds
     * @param \Ups_address\UPSaddressStruct\Ups_addressLocationType $location
     * @param \Ups_address\UPSaddressStruct\Ups_addressCodeType[] $subErrorCode
     */
    public function __construct($severity = null, \Ups_address\UPSaddressStruct\Ups_addressCodeType $primaryErrorCode = null, $minimumRetrySeconds = null, \Ups_address\UPSaddressStruct\Ups_addressLocationType $location = null, array $subErrorCode = array())
    {
        $this
            ->setSeverity($severity)
            ->setPrimaryErrorCode($primaryErrorCode)
            ->setMinimumRetrySeconds($minimumRetrySeconds)
            ->setLocation($location)
            ->setSubErrorCode($subErrorCode);
    }
    /**
     * Get Severity value
     * @return string|null
     */
    public function getSeverity()
    {
        return $this->Severity;
    }
    /**
     * Set Severity value
     * @param string $severity
     * @return \Ups_address\UPSaddressStruct\Ups_addressErrorDetailType
     */
    public function setSeverity($severity = null)
    {
        // validation for constraint: string
        if (!is_null($severity) && !is_string($severity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($severity, true), gettype($severity)), __LINE__);
        }
        $this->Severity = $severity;
        return $this;
    }
    /**
     * Get PrimaryErrorCode value
     * @return \Ups_address\UPSaddressStruct\Ups_addressCodeType|null
     */
    public function getPrimaryErrorCode()
    {
        return $this->PrimaryErrorCode;
    }
    /**
     * Set PrimaryErrorCode value
     * @param \Ups_address\UPSaddressStruct\Ups_addressCodeType $primaryErrorCode
     * @return \Ups_address\UPSaddressStruct\Ups_addressErrorDetailType
     */
    public function setPrimaryErrorCode(\Ups_address\UPSaddressStruct\Ups_addressCodeType $primaryErrorCode = null)
    {
        $this->PrimaryErrorCode = $primaryErrorCode;
        return $this;
    }
    /**
     * Get MinimumRetrySeconds value
     * @return string|null
     */
    public function getMinimumRetrySeconds()
    {
        return $this->MinimumRetrySeconds;
    }
    /**
     * Set MinimumRetrySeconds value
     * @param string $minimumRetrySeconds
     * @return \Ups_address\UPSaddressStruct\Ups_addressErrorDetailType
     */
    public function setMinimumRetrySeconds($minimumRetrySeconds = null)
    {
        // validation for constraint: string
        if (!is_null($minimumRetrySeconds) && !is_string($minimumRetrySeconds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($minimumRetrySeconds, true), gettype($minimumRetrySeconds)), __LINE__);
        }
        $this->MinimumRetrySeconds = $minimumRetrySeconds;
        return $this;
    }
    /**
     * Get Location value
     * @return \Ups_address\UPSaddressStruct\Ups_addressLocationType|null
     */
    public function getLocation()
    {
        return $this->Location;
    }
    /**
     * Set Location value
     * @param \Ups_address\UPSaddressStruct\Ups_addressLocationType $location
     * @return \Ups_address\UPSaddressStruct\Ups_addressErrorDetailType
     */
    public function setLocation(\Ups_address\UPSaddressStruct\Ups_addressLocationType $location = null)
    {
        $this->Location = $location;
        return $this;
    }
    /**
     * Get SubErrorCode value
     * @return \Ups_address\UPSaddressStruct\Ups_addressCodeType[]|null
     */
    public function getSubErrorCode()
    {
        return $this->SubErrorCode;
    }
    /**
     * This method is responsible for validating the values passed to the setSubErrorCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSubErrorCode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSubErrorCodeForArrayConstraintsFromSetSubErrorCode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $errorDetailTypeSubErrorCodeItem) {
            // validation for constraint: itemType
            if (!$errorDetailTypeSubErrorCodeItem instanceof \Ups_address\UPSaddressStruct\Ups_addressCodeType) {
                $invalidValues[] = is_object($errorDetailTypeSubErrorCodeItem) ? get_class($errorDetailTypeSubErrorCodeItem) : sprintf('%s(%s)', gettype($errorDetailTypeSubErrorCodeItem), var_export($errorDetailTypeSubErrorCodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SubErrorCode property can only contain items of type \Ups_address\UPSaddressStruct\Ups_addressCodeType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SubErrorCode value
     * @throws \InvalidArgumentException
     * @param \Ups_address\UPSaddressStruct\Ups_addressCodeType[] $subErrorCode
     * @return \Ups_address\UPSaddressStruct\Ups_addressErrorDetailType
     */
    public function setSubErrorCode(array $subErrorCode = array())
    {
        // validation for constraint: array
        if ('' !== ($subErrorCodeArrayErrorMessage = self::validateSubErrorCodeForArrayConstraintsFromSetSubErrorCode($subErrorCode))) {
            throw new \InvalidArgumentException($subErrorCodeArrayErrorMessage, __LINE__);
        }
        $this->SubErrorCode = $subErrorCode;
        return $this;
    }
    /**
     * Add item to SubErrorCode value
     * @throws \InvalidArgumentException
     * @param \Ups_address\UPSaddressStruct\Ups_addressCodeType $item
     * @return \Ups_address\UPSaddressStruct\Ups_addressErrorDetailType
     */
    public function addToSubErrorCode(\Ups_address\UPSaddressStruct\Ups_addressCodeType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ups_address\UPSaddressStruct\Ups_addressCodeType) {
            throw new \InvalidArgumentException(sprintf('The SubErrorCode property can only contain items of type \Ups_address\UPSaddressStruct\Ups_addressCodeType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SubErrorCode[] = $item;
        return $this;
    }
}
