<?php

namespace Service\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CancellaIscrizioneCorsoRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CancellaIscrizioneCorsoRequest
 * @subpackage Structs
 */
class CancellaIscrizioneCorsoRequest extends AbstractStructBase
{
    /**
     * The Corso
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Service\StructType\Corso
     */
    public $Corso;
    /**
     * The Utente
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Service\StructType\Anagrafica_Model
     */
    public $Utente;
    /**
     * Constructor method for CancellaIscrizioneCorsoRequest
     * @uses CancellaIscrizioneCorsoRequest::setCorso()
     * @uses CancellaIscrizioneCorsoRequest::setUtente()
     * @param \Service\StructType\Corso $corso
     * @param \Service\StructType\Anagrafica_Model $utente
     */
    public function __construct(\Service\StructType\Corso $corso = null, \Service\StructType\Anagrafica_Model $utente = null)
    {
        $this
            ->setCorso($corso)
            ->setUtente($utente);
    }
    /**
     * Get Corso value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Service\StructType\Corso|null
     */
    public function getCorso()
    {
        return isset($this->Corso) ? $this->Corso : null;
    }
    /**
     * Set Corso value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Service\StructType\Corso $corso
     * @return \Service\StructType\CancellaIscrizioneCorsoRequest
     */
    public function setCorso(\Service\StructType\Corso $corso = null)
    {
        if (is_null($corso) || (is_array($corso) && empty($corso))) {
            unset($this->Corso);
        } else {
            $this->Corso = $corso;
        }
        return $this;
    }
    /**
     * Get Utente value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Service\StructType\Anagrafica_Model|null
     */
    public function getUtente()
    {
        return isset($this->Utente) ? $this->Utente : null;
    }
    /**
     * Set Utente value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Service\StructType\Anagrafica_Model $utente
     * @return \Service\StructType\CancellaIscrizioneCorsoRequest
     */
    public function setUtente(\Service\StructType\Anagrafica_Model $utente = null)
    {
        if (is_null($utente) || (is_array($utente) && empty($utente))) {
            unset($this->Utente);
        } else {
            $this->Utente = $utente;
        }
        return $this;
    }
}
