<?php

namespace Service\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for all operations
 * @subpackage Services
 */
class Service extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetVersion
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Service\StructType\GetVersion $parameters
     * @return \Service\StructType\GetVersionResponse|bool
     */
    public function GetVersion(\Service\StructType\GetVersion $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetVersion($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Login
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Service\StructType\Login $parameters
     * @return \Service\StructType\LoginResponse|bool
     */
    public function Login(\Service\StructType\Login $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Login($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RegistraFCMToken
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Service\StructType\RegistraFCMToken $parameters
     * @return \Service\StructType\RegistraFCMTokenResponse|bool
     */
    public function RegistraFCMToken(\Service\StructType\RegistraFCMToken $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RegistraFCMToken($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UnRegisterFCMToken
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Service\StructType\UnRegisterFCMToken $parameters
     * @return \Service\StructType\UnRegisterFCMTokenResponse|bool
     */
    public function UnRegisterFCMToken(\Service\StructType\UnRegisterFCMToken $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UnRegisterFCMToken($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Login_Tessera
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Service\StructType\Login_Tessera $parameters
     * @return \Service\StructType\Login_TesseraResponse|bool
     */
    public function Login_Tessera(\Service\StructType\Login_Tessera $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Login_Tessera($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Login_EasyGAV_Web
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Service\StructType\Login_EasyGAV_Web $parameters
     * @return \Service\StructType\Login_EasyGAV_WebResponse|bool
     */
    public function Login_EasyGAV_Web(\Service\StructType\Login_EasyGAV_Web $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Login_EasyGAV_Web($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Login_SGEServer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Service\StructType\Login_SGEServer $parameters
     * @return \Service\StructType\Login_SGEServerResponse|bool
     */
    public function Login_SGEServer(\Service\StructType\Login_SGEServer $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Login_SGEServer($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetInternalProtocolVersion
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Service\StructType\GetInternalProtocolVersion $parameters
     * @return \Service\StructType\GetInternalProtocolVersionResponse|bool
     */
    public function GetInternalProtocolVersion(\Service\StructType\GetInternalProtocolVersion $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetInternalProtocolVersion($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetProfilo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Service\StructType\GetProfilo $parameters
     * @return \Service\StructType\GetProfiloResponse|bool
     */
    public function GetProfilo(\Service\StructType\GetProfilo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetProfilo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateUser
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Service\StructType\UpdateUser $parameters
     * @return \Service\StructType\UpdateUserResponse|bool
     */
    public function UpdateUser(\Service\StructType\UpdateUser $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateUser($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateUserProfilePhoto
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Service\StructType\UpdateUserProfilePhoto $parameters
     * @return \Service\StructType\UpdateUserProfilePhotoResponse|bool
     */
    public function UpdateUserProfilePhoto(\Service\StructType\UpdateUserProfilePhoto $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateUserProfilePhoto($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetConfigurazione
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Service\StructType\GetConfigurazione $parameters
     * @return \Service\StructType\GetConfigurazioneResponse|bool
     */
    public function GetConfigurazione(\Service\StructType\GetConfigurazione $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetConfigurazione($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InviaPresenza
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Service\StructType\InviaPresenza $parameters
     * @return \Service\StructType\InviaPresenzaResponse|bool
     */
    public function InviaPresenza(\Service\StructType\InviaPresenza $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->InviaPresenza($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InviaPresenza2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Service\StructType\InviaPresenza2 $parameters
     * @return \Service\StructType\InviaPresenza2Response|bool
     */
    public function InviaPresenza2(\Service\StructType\InviaPresenza2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->InviaPresenza2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InviaPresenza3
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Service\StructType\InviaPresenza3 $parameters
     * @return \Service\StructType\InviaPresenza3Response|bool
     */
    public function InviaPresenza3(\Service\StructType\InviaPresenza3 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->InviaPresenza3($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCheckList_Richieste
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Service\StructType\GetCheckList_Richieste $parameters
     * @return \Service\StructType\GetCheckList_RichiesteResponse|bool
     */
    public function GetCheckList_Richieste(\Service\StructType\GetCheckList_Richieste $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCheckList_Richieste($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetRegioni
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Service\StructType\GetRegioni $parameters
     * @return \Service\StructType\GetRegioniResponse|bool
     */
    public function GetRegioni(\Service\StructType\GetRegioni $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetRegioni($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetProvince
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Service\StructType\GetProvince $parameters
     * @return \Service\StructType\GetProvinceResponse|bool
     */
    public function GetProvince(\Service\StructType\GetProvince $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetProvince($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetComuni
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Service\StructType\GetComuni $parameters
     * @return \Service\StructType\GetComuniResponse|bool
     */
    public function GetComuni(\Service\StructType\GetComuni $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetComuni($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetRecapiti
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Service\StructType\GetRecapiti $parameters
     * @return \Service\StructType\GetRecapitiResponse|bool
     */
    public function GetRecapiti(\Service\StructType\GetRecapiti $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetRecapiti($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetRecapito
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Service\StructType\GetRecapito $parameters
     * @return \Service\StructType\GetRecapitoResponse|bool
     */
    public function GetRecapito(\Service\StructType\GetRecapito $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetRecapito($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SalvaRecapito
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Service\StructType\SalvaRecapito $parameters
     * @return \Service\StructType\SalvaRecapitoResponse|bool
     */
    public function SalvaRecapito(\Service\StructType\SalvaRecapito $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SalvaRecapito($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteRecapito
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Service\StructType\DeleteRecapito $parameters
     * @return \Service\StructType\DeleteRecapitoResponse|bool
     */
    public function DeleteRecapito(\Service\StructType\DeleteRecapito $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DeleteRecapito($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetQualifiche
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Service\StructType\GetQualifiche $parameters
     * @return \Service\StructType\GetQualificheResponse|bool
     */
    public function GetQualifiche(\Service\StructType\GetQualifiche $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetQualifiche($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendRecapiti
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Service\StructType\SendRecapiti $parameters
     * @return \Service\StructType\SendRecapitiResponse|bool
     */
    public function SendRecapiti(\Service\StructType\SendRecapiti $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SendRecapiti($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCorsi
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Service\StructType\GetCorsi $parameters
     * @return \Service\StructType\GetCorsiResponse|bool
     */
    public function GetCorsi(\Service\StructType\GetCorsi $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCorsi($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCorsiUtente
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Service\StructType\GetCorsiUtente $parameters
     * @return \Service\StructType\GetCorsiUtenteResponse|bool
     */
    public function GetCorsiUtente(\Service\StructType\GetCorsiUtente $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCorsiUtente($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CancellaIscrizioneACorso
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Service\StructType\CancellaIscrizioneACorso $parameters
     * @return \Service\StructType\CancellaIscrizioneACorsoResponse|bool
     */
    public function CancellaIscrizioneACorso(\Service\StructType\CancellaIscrizioneACorso $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CancellaIscrizioneACorso($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendCorsoRegistrazione
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Service\StructType\SendCorsoRegistrazione $parameters
     * @return \Service\StructType\SendCorsoRegistrazioneResponse|bool
     */
    public function SendCorsoRegistrazione(\Service\StructType\SendCorsoRegistrazione $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SendCorsoRegistrazione($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendCorsoCancellaRegistrazione
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Service\StructType\SendCorsoCancellaRegistrazione $parameters
     * @return \Service\StructType\SendCorsoCancellaRegistrazioneResponse|bool
     */
    public function SendCorsoCancellaRegistrazione(\Service\StructType\SendCorsoCancellaRegistrazione $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SendCorsoCancellaRegistrazione($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTurni
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Service\StructType\GetTurni $parameters
     * @return \Service\StructType\GetTurniResponse|bool
     */
    public function GetTurni(\Service\StructType\GetTurni $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetTurni($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTurniOperatore
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Service\StructType\GetTurniOperatore $parameters
     * @return \Service\StructType\GetTurniOperatoreResponse|bool
     */
    public function GetTurniOperatore(\Service\StructType\GetTurniOperatore $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetTurniOperatore($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetEventiOperatore
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Service\StructType\GetEventiOperatore $parameters
     * @return \Service\StructType\GetEventiOperatoreResponse|bool
     */
    public function GetEventiOperatore(\Service\StructType\GetEventiOperatore $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetEventiOperatore($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCalendarioTurni
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Service\StructType\GetCalendarioTurni $parameters
     * @return \Service\StructType\GetCalendarioTurniResponse|bool
     */
    public function GetCalendarioTurni(\Service\StructType\GetCalendarioTurni $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCalendarioTurni($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCalendarioTurniLite
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Service\StructType\GetCalendarioTurniLite $parameters
     * @return \Service\StructType\GetCalendarioTurniLiteResponse|bool
     */
    public function GetCalendarioTurniLite(\Service\StructType\GetCalendarioTurniLite $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCalendarioTurniLite($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetEventi
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Service\StructType\GetEventi $parameters
     * @return \Service\StructType\GetEventiResponse|bool
     */
    public function GetEventi(\Service\StructType\GetEventi $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetEventi($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCalendarioEventi
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Service\StructType\GetCalendarioEventi $parameters
     * @return \Service\StructType\GetCalendarioEventiResponse|bool
     */
    public function GetCalendarioEventi(\Service\StructType\GetCalendarioEventi $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCalendarioEventi($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTurnoSpecifico
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Service\StructType\GetTurnoSpecifico $parameters
     * @return \Service\StructType\GetTurnoSpecificoResponse|bool
     */
    public function GetTurnoSpecifico(\Service\StructType\GetTurnoSpecifico $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetTurnoSpecifico($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTurnoSpecifico2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Service\StructType\GetTurnoSpecifico2 $parameters
     * @return \Service\StructType\GetTurnoSpecifico2Response|bool
     */
    public function GetTurnoSpecifico2(\Service\StructType\GetTurnoSpecifico2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetTurnoSpecifico2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetGiornoEvento
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Service\StructType\GetGiornoEvento $parameters
     * @return \Service\StructType\GetGiornoEventoResponse|bool
     */
    public function GetGiornoEvento(\Service\StructType\GetGiornoEvento $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetGiornoEvento($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named IscrizioneTurno
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Service\StructType\IscrizioneTurno $parameters
     * @return \Service\StructType\IscrizioneTurnoResponse|bool
     */
    public function IscrizioneTurno(\Service\StructType\IscrizioneTurno $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->IscrizioneTurno($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named IscrizioneTurno2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Service\StructType\IscrizioneTurno2 $parameters
     * @return \Service\StructType\IscrizioneTurno2Response|bool
     */
    public function IscrizioneTurno2(\Service\StructType\IscrizioneTurno2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->IscrizioneTurno2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ModificaIscrizioneTurno
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Service\StructType\ModificaIscrizioneTurno $parameters
     * @return \Service\StructType\ModificaIscrizioneTurnoResponse|bool
     */
    public function ModificaIscrizioneTurno(\Service\StructType\ModificaIscrizioneTurno $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ModificaIscrizioneTurno($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ModificaIscrizioneTurno2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Service\StructType\ModificaIscrizioneTurno2 $parameters
     * @return \Service\StructType\ModificaIscrizioneTurno2Response|bool
     */
    public function ModificaIscrizioneTurno2(\Service\StructType\ModificaIscrizioneTurno2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ModificaIscrizioneTurno2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named IscrizioneEvento
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Service\StructType\IscrizioneEvento $parameters
     * @return \Service\StructType\IscrizioneEventoResponse|bool
     */
    public function IscrizioneEvento(\Service\StructType\IscrizioneEvento $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->IscrizioneEvento($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CancellazioneIscrizioneTurno
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Service\StructType\CancellazioneIscrizioneTurno $parameters
     * @return \Service\StructType\CancellazioneIscrizioneTurnoResponse|bool
     */
    public function CancellazioneIscrizioneTurno(\Service\StructType\CancellazioneIscrizioneTurno $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CancellazioneIscrizioneTurno($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CancellazioneIscrizioneTurno2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Service\StructType\CancellazioneIscrizioneTurno2 $parameters
     * @return \Service\StructType\CancellazioneIscrizioneTurno2Response|bool
     */
    public function CancellazioneIscrizioneTurno2(\Service\StructType\CancellazioneIscrizioneTurno2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CancellazioneIscrizioneTurno2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CancellazioneIscrizioneEvento
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Service\StructType\CancellazioneIscrizioneEvento $parameters
     * @return \Service\StructType\CancellazioneIscrizioneEventoResponse|bool
     */
    public function CancellazioneIscrizioneEvento(\Service\StructType\CancellazioneIscrizioneEvento $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CancellazioneIscrizioneEvento($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAttivitaUtente
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Service\StructType\GetAttivitaUtente $parameters
     * @return \Service\StructType\GetAttivitaUtenteResponse|bool
     */
    public function GetAttivitaUtente(\Service\StructType\GetAttivitaUtente $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAttivitaUtente($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetMessaggi
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Service\StructType\GetMessaggi $parameters
     * @return \Service\StructType\GetMessaggiResponse|bool
     */
    public function GetMessaggi(\Service\StructType\GetMessaggi $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetMessaggi($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetLastPresenza
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Service\StructType\GetLastPresenza $parameters
     * @return \Service\StructType\GetLastPresenzaResponse|bool
     */
    public function GetLastPresenza(\Service\StructType\GetLastPresenza $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetLastPresenza($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetLastPresenza2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Service\StructType\GetLastPresenza2 $parameters
     * @return \Service\StructType\GetLastPresenza2Response|bool
     */
    public function GetLastPresenza2(\Service\StructType\GetLastPresenza2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetLastPresenza2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetNotifiche
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Service\StructType\GetNotifiche $parameters
     * @return \Service\StructType\GetNotificheResponse|bool
     */
    public function GetNotifiche(\Service\StructType\GetNotifiche $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetNotifiche($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTestoNotifica
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Service\StructType\GetTestoNotifica $parameters
     * @return \Service\StructType\GetTestoNotificaResponse|bool
     */
    public function GetTestoNotifica(\Service\StructType\GetTestoNotifica $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetTestoNotifica($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTotaleNotificheDaNotificare
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Service\StructType\GetTotaleNotificheDaNotificare $parameters
     * @return \Service\StructType\GetTotaleNotificheDaNotificareResponse|bool
     */
    public function GetTotaleNotificheDaNotificare(\Service\StructType\GetTotaleNotificheDaNotificare $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetTotaleNotificheDaNotificare($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetNotificaLetta
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Service\StructType\SetNotificaLetta $parameters
     * @return \Service\StructType\SetNotificaLettaResponse|bool
     */
    public function SetNotificaLetta(\Service\StructType\SetNotificaLetta $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SetNotificaLetta($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetNotificheNotificate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Service\StructType\SetNotificheNotificate $parameters
     * @return \Service\StructType\SetNotificheNotificateResponse|bool
     */
    public function SetNotificheNotificate(\Service\StructType\SetNotificheNotificate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SetNotificheNotificate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RicercaAnagrafe
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Service\StructType\RicercaAnagrafe $parameters
     * @return \Service\StructType\RicercaAnagrafeResponse|bool
     */
    public function RicercaAnagrafe(\Service\StructType\RicercaAnagrafe $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RicercaAnagrafe($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAnagrafe
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Service\StructType\GetAnagrafe $parameters
     * @return \Service\StructType\GetAnagrafeResponse|bool
     */
    public function GetAnagrafe(\Service\StructType\GetAnagrafe $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAnagrafe($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SalvaAnagrafe
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Service\StructType\SalvaAnagrafe $parameters
     * @return \Service\StructType\SalvaAnagrafeResponse|bool
     */
    public function SalvaAnagrafe(\Service\StructType\SalvaAnagrafe $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SalvaAnagrafe($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named IncassaQuotaAssociativa
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Service\StructType\IncassaQuotaAssociativa $parameters
     * @return \Service\StructType\IncassaQuotaAssociativaResponse|bool
     */
    public function IncassaQuotaAssociativa(\Service\StructType\IncassaQuotaAssociativa $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->IncassaQuotaAssociativa($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AnnullaIncassoQuotaAssociativa
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Service\StructType\AnnullaIncassoQuotaAssociativa $parameters
     * @return \Service\StructType\AnnullaIncassoQuotaAssociativaResponse|bool
     */
    public function AnnullaIncassoQuotaAssociativa(\Service\StructType\AnnullaIncassoQuotaAssociativa $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AnnullaIncassoQuotaAssociativa($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named StampaModuloPrivacy
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Service\StructType\StampaModuloPrivacy $parameters
     * @return \Service\StructType\StampaModuloPrivacyResponse|bool
     */
    public function StampaModuloPrivacy(\Service\StructType\StampaModuloPrivacy $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->StampaModuloPrivacy($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RinnovaPrivacy
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Service\StructType\RinnovaPrivacy $parameters
     * @return \Service\StructType\RinnovaPrivacyResponse|bool
     */
    public function RinnovaPrivacy(\Service\StructType\RinnovaPrivacy $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RinnovaPrivacy($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RevocaPrivacy
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Service\StructType\RevocaPrivacy $parameters
     * @return \Service\StructType\RevocaPrivacyResponse|bool
     */
    public function RevocaPrivacy(\Service\StructType\RevocaPrivacy $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RevocaPrivacy($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCsvSociConRecapito
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Service\StructType\GetCsvSociConRecapito $parameters
     * @return \Service\StructType\GetCsvSociConRecapitoResponse|bool
     */
    public function GetCsvSociConRecapito(\Service\StructType\GetCsvSociConRecapito $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCsvSociConRecapito($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCsvSituazionePrivacy
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Service\StructType\GetCsvSituazionePrivacy $parameters
     * @return \Service\StructType\GetCsvSituazionePrivacyResponse|bool
     */
    public function GetCsvSituazionePrivacy(\Service\StructType\GetCsvSituazionePrivacy $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCsvSituazionePrivacy($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCsvCampagnaSoci
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Service\StructType\GetCsvCampagnaSoci $parameters
     * @return \Service\StructType\GetCsvCampagnaSociResponse|bool
     */
    public function GetCsvCampagnaSoci(\Service\StructType\GetCsvCampagnaSoci $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCsvCampagnaSoci($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetListaSegnalazioniGuasto
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Service\StructType\GetListaSegnalazioniGuasto $parameters
     * @return \Service\StructType\GetListaSegnalazioniGuastoResponse|bool
     */
    public function GetListaSegnalazioniGuasto(\Service\StructType\GetListaSegnalazioniGuasto $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetListaSegnalazioniGuasto($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetListaArticoliSegnalazioneGuasto
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Service\StructType\GetListaArticoliSegnalazioneGuasto $parameters
     * @return \Service\StructType\GetListaArticoliSegnalazioneGuastoResponse|bool
     */
    public function GetListaArticoliSegnalazioneGuasto(\Service\StructType\GetListaArticoliSegnalazioneGuasto $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetListaArticoliSegnalazioneGuasto($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendSegnalazioneGuasto
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Service\StructType\SendSegnalazioneGuasto $parameters
     * @return \Service\StructType\SendSegnalazioneGuastoResponse|bool
     */
    public function SendSegnalazioneGuasto(\Service\StructType\SendSegnalazioneGuasto $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SendSegnalazioneGuasto($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RiassegnaMezzoMissioni
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Service\StructType\RiassegnaMezzoMissioni $parameters
     * @return \Service\StructType\RiassegnaMezzoMissioniResponse|bool
     */
    public function RiassegnaMezzoMissioni(\Service\StructType\RiassegnaMezzoMissioni $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RiassegnaMezzoMissioni($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InsertRichiestaCartellino
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Service\StructType\InsertRichiestaCartellino $parameters
     * @return \Service\StructType\InsertRichiestaCartellinoResponse|bool
     */
    public function InsertRichiestaCartellino(\Service\StructType\InsertRichiestaCartellino $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->InsertRichiestaCartellino($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateRichiestaCartellino
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Service\StructType\UpdateRichiestaCartellino $parameters
     * @return \Service\StructType\UpdateRichiestaCartellinoResponse|bool
     */
    public function UpdateRichiestaCartellino(\Service\StructType\UpdateRichiestaCartellino $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateRichiestaCartellino($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetRichiesteCartellino
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Service\StructType\GetRichiesteCartellino $parameters
     * @return \Service\StructType\GetRichiesteCartellinoResponse|bool
     */
    public function GetRichiesteCartellino(\Service\StructType\GetRichiesteCartellino $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetRichiesteCartellino($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetRichiestaCartellino
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Service\StructType\GetRichiestaCartellino $parameters
     * @return \Service\StructType\GetRichiestaCartellinoResponse|bool
     */
    public function GetRichiestaCartellino(\Service\StructType\GetRichiestaCartellino $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetRichiestaCartellino($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteRichiestaCartellino
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Service\StructType\DeleteRichiestaCartellino $parameters
     * @return \Service\StructType\DeleteRichiestaCartellinoResponse|bool
     */
    public function DeleteRichiestaCartellino(\Service\StructType\DeleteRichiestaCartellino $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DeleteRichiestaCartellino($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InsertEventolRichiestaCartellino
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Service\StructType\InsertEventolRichiestaCartellino $parameters
     * @return \Service\StructType\InsertEventolRichiestaCartellinoResponse|bool
     */
    public function InsertEventolRichiestaCartellino(\Service\StructType\InsertEventolRichiestaCartellino $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->InsertEventolRichiestaCartellino($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetListaRuoliOperatori
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Service\StructType\GetListaRuoliOperatori $parameters
     * @return \Service\StructType\GetListaRuoliOperatoriResponse|bool
     */
    public function GetListaRuoliOperatori(\Service\StructType\GetListaRuoliOperatori $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetListaRuoliOperatori($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetListaStradari
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Service\StructType\GetListaStradari $parameters
     * @return \Service\StructType\GetListaStradariResponse|bool
     */
    public function GetListaStradari(\Service\StructType\GetListaStradari $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetListaStradari($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CheckGreenPass
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Service\StructType\CheckGreenPass $parameters
     * @return \Service\StructType\CheckGreenPassResponse|bool
     */
    public function CheckGreenPass(\Service\StructType\CheckGreenPass $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CheckGreenPass($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Service\StructType\AnnullaIncassoQuotaAssociativaResponse|\Service\StructType\CancellaIscrizioneACorsoResponse|\Service\StructType\CancellazioneIscrizioneEventoResponse|\Service\StructType\CancellazioneIscrizioneTurno2Response|\Service\StructType\CancellazioneIscrizioneTurnoResponse|\Service\StructType\CheckGreenPassResponse|\Service\StructType\DeleteRecapitoResponse|\Service\StructType\DeleteRichiestaCartellinoResponse|\Service\StructType\GetAnagrafeResponse|\Service\StructType\GetAttivitaUtenteResponse|\Service\StructType\GetCalendarioEventiResponse|\Service\StructType\GetCalendarioTurniLiteResponse|\Service\StructType\GetCalendarioTurniResponse|\Service\StructType\GetCheckList_RichiesteResponse|\Service\StructType\GetComuniResponse|\Service\StructType\GetConfigurazioneResponse|\Service\StructType\GetCorsiResponse|\Service\StructType\GetCorsiUtenteResponse|\Service\StructType\GetCsvCampagnaSociResponse|\Service\StructType\GetCsvSituazionePrivacyResponse|\Service\StructType\GetCsvSociConRecapitoResponse|\Service\StructType\GetEventiOperatoreResponse|\Service\StructType\GetEventiResponse|\Service\StructType\GetGiornoEventoResponse|\Service\StructType\GetInternalProtocolVersionResponse|\Service\StructType\GetLastPresenza2Response|\Service\StructType\GetLastPresenzaResponse|\Service\StructType\GetListaArticoliSegnalazioneGuastoResponse|\Service\StructType\GetListaRuoliOperatoriResponse|\Service\StructType\GetListaSegnalazioniGuastoResponse|\Service\StructType\GetListaStradariResponse|\Service\StructType\GetMessaggiResponse|\Service\StructType\GetNotificheResponse|\Service\StructType\GetProfiloResponse|\Service\StructType\GetProvinceResponse|\Service\StructType\GetQualificheResponse|\Service\StructType\GetRecapitiResponse|\Service\StructType\GetRecapitoResponse|\Service\StructType\GetRegioniResponse|\Service\StructType\GetRichiestaCartellinoResponse|\Service\StructType\GetRichiesteCartellinoResponse|\Service\StructType\GetTestoNotificaResponse|\Service\StructType\GetTotaleNotificheDaNotificareResponse|\Service\StructType\GetTurniOperatoreResponse|\Service\StructType\GetTurniResponse|\Service\StructType\GetTurnoSpecifico2Response|\Service\StructType\GetTurnoSpecificoResponse|\Service\StructType\GetVersionResponse|\Service\StructType\IncassaQuotaAssociativaResponse|\Service\StructType\InsertEventolRichiestaCartellinoResponse|\Service\StructType\InsertRichiestaCartellinoResponse|\Service\StructType\InviaPresenza2Response|\Service\StructType\InviaPresenza3Response|\Service\StructType\InviaPresenzaResponse|\Service\StructType\IscrizioneEventoResponse|\Service\StructType\IscrizioneTurno2Response|\Service\StructType\IscrizioneTurnoResponse|\Service\StructType\LoginResponse|\Service\StructType\Login_EasyGAV_WebResponse|\Service\StructType\Login_SGEServerResponse|\Service\StructType\Login_TesseraResponse|\Service\StructType\ModificaIscrizioneTurno2Response|\Service\StructType\ModificaIscrizioneTurnoResponse|\Service\StructType\RegistraFCMTokenResponse|\Service\StructType\RevocaPrivacyResponse|\Service\StructType\RiassegnaMezzoMissioniResponse|\Service\StructType\RicercaAnagrafeResponse|\Service\StructType\RinnovaPrivacyResponse|\Service\StructType\SalvaAnagrafeResponse|\Service\StructType\SalvaRecapitoResponse|\Service\StructType\SendCorsoCancellaRegistrazioneResponse|\Service\StructType\SendCorsoRegistrazioneResponse|\Service\StructType\SendRecapitiResponse|\Service\StructType\SendSegnalazioneGuastoResponse|\Service\StructType\SetNotificaLettaResponse|\Service\StructType\SetNotificheNotificateResponse|\Service\StructType\StampaModuloPrivacyResponse|\Service\StructType\UnRegisterFCMTokenResponse|\Service\StructType\UpdateRichiestaCartellinoResponse|\Service\StructType\UpdateUserProfilePhotoResponse|\Service\StructType\UpdateUserResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
