<?php

namespace Service\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UtentePCGav StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:UtentePCGav
 * @subpackage Structs
 */
class UtentePCGav extends AbstractStructBase
{
    /**
     * The Attivita
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Service\ArrayType\ArrayOfAttivitaUtente
     */
    public $Attivita;
    /**
     * The CheckRichieste
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Service\ArrayType\ArrayOfPresenza_CheckListRichiestaModel
     */
    public $CheckRichieste;
    /**
     * The CodiceFiscale
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CodiceFiscale;
    /**
     * The Cognome
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Cognome;
    /**
     * The ComuneNascita
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ComuneNascita;
    /**
     * The DataNascita
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DataNascita;
    /**
     * The DomicilioCAP
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DomicilioCAP;
    /**
     * The DomicilioComune
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DomicilioComune;
    /**
     * The DomicilioIndirizzo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DomicilioIndirizzo;
    /**
     * The DomicilioNumCivico
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DomicilioNumCivico;
    /**
     * The DomicilioProvincia
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DomicilioProvincia;
    /**
     * The DomicilioProvincia_Descr
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DomicilioProvincia_Descr;
    /**
     * The FotoProfilo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FotoProfilo;
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ID;
    /**
     * The IDDBDitta
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IDDBDitta;
    /**
     * The IDSezionePredefinita
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IDSezionePredefinita;
    /**
     * The IDStruttura
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IDStruttura;
    /**
     * The Nome
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Nome;
    /**
     * The NomeStruttura
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NomeStruttura;
    /**
     * The PRESENZE_GreenPassEsente
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $PRESENZE_GreenPassEsente;
    /**
     * The ProvinciaNascita
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProvinciaNascita;
    /**
     * The Qualifiche
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Service\ArrayType\ArrayOfQualifica
     */
    public $Qualifiche;
    /**
     * The Recapiti
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Service\ArrayType\ArrayOfRecapito
     */
    public $Recapiti;
    /**
     * The ResidenzaCAP
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ResidenzaCAP;
    /**
     * The ResidenzaComune
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ResidenzaComune;
    /**
     * The ResidenzaIndirizzo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ResidenzaIndirizzo;
    /**
     * The ResidenzaNumCivico
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ResidenzaNumCivico;
    /**
     * The ResidenzaProvincia
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ResidenzaProvincia;
    /**
     * The ResidenzaProvincia_Descr
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ResidenzaProvincia_Descr;
    /**
     * The Sesso
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Sesso;
    /**
     * The TipoStruttura
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TipoStruttura;
    /**
     * The UtenteWeb
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UtenteWeb;
    /**
     * Constructor method for UtentePCGav
     * @uses UtentePCGav::setAttivita()
     * @uses UtentePCGav::setCheckRichieste()
     * @uses UtentePCGav::setCodiceFiscale()
     * @uses UtentePCGav::setCognome()
     * @uses UtentePCGav::setComuneNascita()
     * @uses UtentePCGav::setDataNascita()
     * @uses UtentePCGav::setDomicilioCAP()
     * @uses UtentePCGav::setDomicilioComune()
     * @uses UtentePCGav::setDomicilioIndirizzo()
     * @uses UtentePCGav::setDomicilioNumCivico()
     * @uses UtentePCGav::setDomicilioProvincia()
     * @uses UtentePCGav::setDomicilioProvincia_Descr()
     * @uses UtentePCGav::setFotoProfilo()
     * @uses UtentePCGav::setID()
     * @uses UtentePCGav::setIDDBDitta()
     * @uses UtentePCGav::setIDSezionePredefinita()
     * @uses UtentePCGav::setIDStruttura()
     * @uses UtentePCGav::setNome()
     * @uses UtentePCGav::setNomeStruttura()
     * @uses UtentePCGav::setPRESENZE_GreenPassEsente()
     * @uses UtentePCGav::setProvinciaNascita()
     * @uses UtentePCGav::setQualifiche()
     * @uses UtentePCGav::setRecapiti()
     * @uses UtentePCGav::setResidenzaCAP()
     * @uses UtentePCGav::setResidenzaComune()
     * @uses UtentePCGav::setResidenzaIndirizzo()
     * @uses UtentePCGav::setResidenzaNumCivico()
     * @uses UtentePCGav::setResidenzaProvincia()
     * @uses UtentePCGav::setResidenzaProvincia_Descr()
     * @uses UtentePCGav::setSesso()
     * @uses UtentePCGav::setTipoStruttura()
     * @uses UtentePCGav::setUtenteWeb()
     * @param \Service\ArrayType\ArrayOfAttivitaUtente $attivita
     * @param \Service\ArrayType\ArrayOfPresenza_CheckListRichiestaModel $checkRichieste
     * @param string $codiceFiscale
     * @param string $cognome
     * @param string $comuneNascita
     * @param string $dataNascita
     * @param string $domicilioCAP
     * @param string $domicilioComune
     * @param string $domicilioIndirizzo
     * @param string $domicilioNumCivico
     * @param string $domicilioProvincia
     * @param string $domicilioProvincia_Descr
     * @param string $fotoProfilo
     * @param int $iD
     * @param int $iDDBDitta
     * @param string $iDSezionePredefinita
     * @param int $iDStruttura
     * @param string $nome
     * @param string $nomeStruttura
     * @param bool $pRESENZE_GreenPassEsente
     * @param string $provinciaNascita
     * @param \Service\ArrayType\ArrayOfQualifica $qualifiche
     * @param \Service\ArrayType\ArrayOfRecapito $recapiti
     * @param string $residenzaCAP
     * @param string $residenzaComune
     * @param string $residenzaIndirizzo
     * @param string $residenzaNumCivico
     * @param string $residenzaProvincia
     * @param string $residenzaProvincia_Descr
     * @param string $sesso
     * @param string $tipoStruttura
     * @param string $utenteWeb
     */
    public function __construct(\Service\ArrayType\ArrayOfAttivitaUtente $attivita = null, \Service\ArrayType\ArrayOfPresenza_CheckListRichiestaModel $checkRichieste = null, $codiceFiscale = null, $cognome = null, $comuneNascita = null, $dataNascita = null, $domicilioCAP = null, $domicilioComune = null, $domicilioIndirizzo = null, $domicilioNumCivico = null, $domicilioProvincia = null, $domicilioProvincia_Descr = null, $fotoProfilo = null, $iD = null, $iDDBDitta = null, $iDSezionePredefinita = null, $iDStruttura = null, $nome = null, $nomeStruttura = null, $pRESENZE_GreenPassEsente = null, $provinciaNascita = null, \Service\ArrayType\ArrayOfQualifica $qualifiche = null, \Service\ArrayType\ArrayOfRecapito $recapiti = null, $residenzaCAP = null, $residenzaComune = null, $residenzaIndirizzo = null, $residenzaNumCivico = null, $residenzaProvincia = null, $residenzaProvincia_Descr = null, $sesso = null, $tipoStruttura = null, $utenteWeb = null)
    {
        $this
            ->setAttivita($attivita)
            ->setCheckRichieste($checkRichieste)
            ->setCodiceFiscale($codiceFiscale)
            ->setCognome($cognome)
            ->setComuneNascita($comuneNascita)
            ->setDataNascita($dataNascita)
            ->setDomicilioCAP($domicilioCAP)
            ->setDomicilioComune($domicilioComune)
            ->setDomicilioIndirizzo($domicilioIndirizzo)
            ->setDomicilioNumCivico($domicilioNumCivico)
            ->setDomicilioProvincia($domicilioProvincia)
            ->setDomicilioProvincia_Descr($domicilioProvincia_Descr)
            ->setFotoProfilo($fotoProfilo)
            ->setID($iD)
            ->setIDDBDitta($iDDBDitta)
            ->setIDSezionePredefinita($iDSezionePredefinita)
            ->setIDStruttura($iDStruttura)
            ->setNome($nome)
            ->setNomeStruttura($nomeStruttura)
            ->setPRESENZE_GreenPassEsente($pRESENZE_GreenPassEsente)
            ->setProvinciaNascita($provinciaNascita)
            ->setQualifiche($qualifiche)
            ->setRecapiti($recapiti)
            ->setResidenzaCAP($residenzaCAP)
            ->setResidenzaComune($residenzaComune)
            ->setResidenzaIndirizzo($residenzaIndirizzo)
            ->setResidenzaNumCivico($residenzaNumCivico)
            ->setResidenzaProvincia($residenzaProvincia)
            ->setResidenzaProvincia_Descr($residenzaProvincia_Descr)
            ->setSesso($sesso)
            ->setTipoStruttura($tipoStruttura)
            ->setUtenteWeb($utenteWeb);
    }
    /**
     * Get Attivita value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Service\ArrayType\ArrayOfAttivitaUtente|null
     */
    public function getAttivita()
    {
        return isset($this->Attivita) ? $this->Attivita : null;
    }
    /**
     * Set Attivita value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Service\ArrayType\ArrayOfAttivitaUtente $attivita
     * @return \Service\StructType\UtentePCGav
     */
    public function setAttivita(\Service\ArrayType\ArrayOfAttivitaUtente $attivita = null)
    {
        if (is_null($attivita) || (is_array($attivita) && empty($attivita))) {
            unset($this->Attivita);
        } else {
            $this->Attivita = $attivita;
        }
        return $this;
    }
    /**
     * Get CheckRichieste value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Service\ArrayType\ArrayOfPresenza_CheckListRichiestaModel|null
     */
    public function getCheckRichieste()
    {
        return isset($this->CheckRichieste) ? $this->CheckRichieste : null;
    }
    /**
     * Set CheckRichieste value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Service\ArrayType\ArrayOfPresenza_CheckListRichiestaModel $checkRichieste
     * @return \Service\StructType\UtentePCGav
     */
    public function setCheckRichieste(\Service\ArrayType\ArrayOfPresenza_CheckListRichiestaModel $checkRichieste = null)
    {
        if (is_null($checkRichieste) || (is_array($checkRichieste) && empty($checkRichieste))) {
            unset($this->CheckRichieste);
        } else {
            $this->CheckRichieste = $checkRichieste;
        }
        return $this;
    }
    /**
     * Get CodiceFiscale value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodiceFiscale()
    {
        return isset($this->CodiceFiscale) ? $this->CodiceFiscale : null;
    }
    /**
     * Set CodiceFiscale value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $codiceFiscale
     * @return \Service\StructType\UtentePCGav
     */
    public function setCodiceFiscale($codiceFiscale = null)
    {
        // validation for constraint: string
        if (!is_null($codiceFiscale) && !is_string($codiceFiscale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codiceFiscale, true), gettype($codiceFiscale)), __LINE__);
        }
        if (is_null($codiceFiscale) || (is_array($codiceFiscale) && empty($codiceFiscale))) {
            unset($this->CodiceFiscale);
        } else {
            $this->CodiceFiscale = $codiceFiscale;
        }
        return $this;
    }
    /**
     * Get Cognome value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCognome()
    {
        return isset($this->Cognome) ? $this->Cognome : null;
    }
    /**
     * Set Cognome value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cognome
     * @return \Service\StructType\UtentePCGav
     */
    public function setCognome($cognome = null)
    {
        // validation for constraint: string
        if (!is_null($cognome) && !is_string($cognome)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cognome, true), gettype($cognome)), __LINE__);
        }
        if (is_null($cognome) || (is_array($cognome) && empty($cognome))) {
            unset($this->Cognome);
        } else {
            $this->Cognome = $cognome;
        }
        return $this;
    }
    /**
     * Get ComuneNascita value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getComuneNascita()
    {
        return isset($this->ComuneNascita) ? $this->ComuneNascita : null;
    }
    /**
     * Set ComuneNascita value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $comuneNascita
     * @return \Service\StructType\UtentePCGav
     */
    public function setComuneNascita($comuneNascita = null)
    {
        // validation for constraint: string
        if (!is_null($comuneNascita) && !is_string($comuneNascita)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comuneNascita, true), gettype($comuneNascita)), __LINE__);
        }
        if (is_null($comuneNascita) || (is_array($comuneNascita) && empty($comuneNascita))) {
            unset($this->ComuneNascita);
        } else {
            $this->ComuneNascita = $comuneNascita;
        }
        return $this;
    }
    /**
     * Get DataNascita value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDataNascita()
    {
        return isset($this->DataNascita) ? $this->DataNascita : null;
    }
    /**
     * Set DataNascita value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dataNascita
     * @return \Service\StructType\UtentePCGav
     */
    public function setDataNascita($dataNascita = null)
    {
        // validation for constraint: string
        if (!is_null($dataNascita) && !is_string($dataNascita)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataNascita, true), gettype($dataNascita)), __LINE__);
        }
        if (is_null($dataNascita) || (is_array($dataNascita) && empty($dataNascita))) {
            unset($this->DataNascita);
        } else {
            $this->DataNascita = $dataNascita;
        }
        return $this;
    }
    /**
     * Get DomicilioCAP value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDomicilioCAP()
    {
        return isset($this->DomicilioCAP) ? $this->DomicilioCAP : null;
    }
    /**
     * Set DomicilioCAP value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $domicilioCAP
     * @return \Service\StructType\UtentePCGav
     */
    public function setDomicilioCAP($domicilioCAP = null)
    {
        // validation for constraint: string
        if (!is_null($domicilioCAP) && !is_string($domicilioCAP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($domicilioCAP, true), gettype($domicilioCAP)), __LINE__);
        }
        if (is_null($domicilioCAP) || (is_array($domicilioCAP) && empty($domicilioCAP))) {
            unset($this->DomicilioCAP);
        } else {
            $this->DomicilioCAP = $domicilioCAP;
        }
        return $this;
    }
    /**
     * Get DomicilioComune value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDomicilioComune()
    {
        return isset($this->DomicilioComune) ? $this->DomicilioComune : null;
    }
    /**
     * Set DomicilioComune value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $domicilioComune
     * @return \Service\StructType\UtentePCGav
     */
    public function setDomicilioComune($domicilioComune = null)
    {
        // validation for constraint: string
        if (!is_null($domicilioComune) && !is_string($domicilioComune)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($domicilioComune, true), gettype($domicilioComune)), __LINE__);
        }
        if (is_null($domicilioComune) || (is_array($domicilioComune) && empty($domicilioComune))) {
            unset($this->DomicilioComune);
        } else {
            $this->DomicilioComune = $domicilioComune;
        }
        return $this;
    }
    /**
     * Get DomicilioIndirizzo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDomicilioIndirizzo()
    {
        return isset($this->DomicilioIndirizzo) ? $this->DomicilioIndirizzo : null;
    }
    /**
     * Set DomicilioIndirizzo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $domicilioIndirizzo
     * @return \Service\StructType\UtentePCGav
     */
    public function setDomicilioIndirizzo($domicilioIndirizzo = null)
    {
        // validation for constraint: string
        if (!is_null($domicilioIndirizzo) && !is_string($domicilioIndirizzo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($domicilioIndirizzo, true), gettype($domicilioIndirizzo)), __LINE__);
        }
        if (is_null($domicilioIndirizzo) || (is_array($domicilioIndirizzo) && empty($domicilioIndirizzo))) {
            unset($this->DomicilioIndirizzo);
        } else {
            $this->DomicilioIndirizzo = $domicilioIndirizzo;
        }
        return $this;
    }
    /**
     * Get DomicilioNumCivico value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDomicilioNumCivico()
    {
        return isset($this->DomicilioNumCivico) ? $this->DomicilioNumCivico : null;
    }
    /**
     * Set DomicilioNumCivico value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $domicilioNumCivico
     * @return \Service\StructType\UtentePCGav
     */
    public function setDomicilioNumCivico($domicilioNumCivico = null)
    {
        // validation for constraint: string
        if (!is_null($domicilioNumCivico) && !is_string($domicilioNumCivico)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($domicilioNumCivico, true), gettype($domicilioNumCivico)), __LINE__);
        }
        if (is_null($domicilioNumCivico) || (is_array($domicilioNumCivico) && empty($domicilioNumCivico))) {
            unset($this->DomicilioNumCivico);
        } else {
            $this->DomicilioNumCivico = $domicilioNumCivico;
        }
        return $this;
    }
    /**
     * Get DomicilioProvincia value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDomicilioProvincia()
    {
        return isset($this->DomicilioProvincia) ? $this->DomicilioProvincia : null;
    }
    /**
     * Set DomicilioProvincia value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $domicilioProvincia
     * @return \Service\StructType\UtentePCGav
     */
    public function setDomicilioProvincia($domicilioProvincia = null)
    {
        // validation for constraint: string
        if (!is_null($domicilioProvincia) && !is_string($domicilioProvincia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($domicilioProvincia, true), gettype($domicilioProvincia)), __LINE__);
        }
        if (is_null($domicilioProvincia) || (is_array($domicilioProvincia) && empty($domicilioProvincia))) {
            unset($this->DomicilioProvincia);
        } else {
            $this->DomicilioProvincia = $domicilioProvincia;
        }
        return $this;
    }
    /**
     * Get DomicilioProvincia_Descr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDomicilioProvincia_Descr()
    {
        return isset($this->DomicilioProvincia_Descr) ? $this->DomicilioProvincia_Descr : null;
    }
    /**
     * Set DomicilioProvincia_Descr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $domicilioProvincia_Descr
     * @return \Service\StructType\UtentePCGav
     */
    public function setDomicilioProvincia_Descr($domicilioProvincia_Descr = null)
    {
        // validation for constraint: string
        if (!is_null($domicilioProvincia_Descr) && !is_string($domicilioProvincia_Descr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($domicilioProvincia_Descr, true), gettype($domicilioProvincia_Descr)), __LINE__);
        }
        if (is_null($domicilioProvincia_Descr) || (is_array($domicilioProvincia_Descr) && empty($domicilioProvincia_Descr))) {
            unset($this->DomicilioProvincia_Descr);
        } else {
            $this->DomicilioProvincia_Descr = $domicilioProvincia_Descr;
        }
        return $this;
    }
    /**
     * Get FotoProfilo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFotoProfilo()
    {
        return isset($this->FotoProfilo) ? $this->FotoProfilo : null;
    }
    /**
     * Set FotoProfilo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fotoProfilo
     * @return \Service\StructType\UtentePCGav
     */
    public function setFotoProfilo($fotoProfilo = null)
    {
        // validation for constraint: string
        if (!is_null($fotoProfilo) && !is_string($fotoProfilo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fotoProfilo, true), gettype($fotoProfilo)), __LINE__);
        }
        if (is_null($fotoProfilo) || (is_array($fotoProfilo) && empty($fotoProfilo))) {
            unset($this->FotoProfilo);
        } else {
            $this->FotoProfilo = $fotoProfilo;
        }
        return $this;
    }
    /**
     * Get ID value
     * @return int|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \Service\StructType\UtentePCGav
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !(is_int($iD) || ctype_digit($iD))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get IDDBDitta value
     * @return int|null
     */
    public function getIDDBDitta()
    {
        return $this->IDDBDitta;
    }
    /**
     * Set IDDBDitta value
     * @param int $iDDBDitta
     * @return \Service\StructType\UtentePCGav
     */
    public function setIDDBDitta($iDDBDitta = null)
    {
        // validation for constraint: int
        if (!is_null($iDDBDitta) && !(is_int($iDDBDitta) || ctype_digit($iDDBDitta))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iDDBDitta, true), gettype($iDDBDitta)), __LINE__);
        }
        $this->IDDBDitta = $iDDBDitta;
        return $this;
    }
    /**
     * Get IDSezionePredefinita value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIDSezionePredefinita()
    {
        return isset($this->IDSezionePredefinita) ? $this->IDSezionePredefinita : null;
    }
    /**
     * Set IDSezionePredefinita value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $iDSezionePredefinita
     * @return \Service\StructType\UtentePCGav
     */
    public function setIDSezionePredefinita($iDSezionePredefinita = null)
    {
        // validation for constraint: string
        if (!is_null($iDSezionePredefinita) && !is_string($iDSezionePredefinita)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDSezionePredefinita, true), gettype($iDSezionePredefinita)), __LINE__);
        }
        if (is_null($iDSezionePredefinita) || (is_array($iDSezionePredefinita) && empty($iDSezionePredefinita))) {
            unset($this->IDSezionePredefinita);
        } else {
            $this->IDSezionePredefinita = $iDSezionePredefinita;
        }
        return $this;
    }
    /**
     * Get IDStruttura value
     * @return int|null
     */
    public function getIDStruttura()
    {
        return $this->IDStruttura;
    }
    /**
     * Set IDStruttura value
     * @param int $iDStruttura
     * @return \Service\StructType\UtentePCGav
     */
    public function setIDStruttura($iDStruttura = null)
    {
        // validation for constraint: int
        if (!is_null($iDStruttura) && !(is_int($iDStruttura) || ctype_digit($iDStruttura))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iDStruttura, true), gettype($iDStruttura)), __LINE__);
        }
        $this->IDStruttura = $iDStruttura;
        return $this;
    }
    /**
     * Get Nome value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNome()
    {
        return isset($this->Nome) ? $this->Nome : null;
    }
    /**
     * Set Nome value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nome
     * @return \Service\StructType\UtentePCGav
     */
    public function setNome($nome = null)
    {
        // validation for constraint: string
        if (!is_null($nome) && !is_string($nome)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nome, true), gettype($nome)), __LINE__);
        }
        if (is_null($nome) || (is_array($nome) && empty($nome))) {
            unset($this->Nome);
        } else {
            $this->Nome = $nome;
        }
        return $this;
    }
    /**
     * Get NomeStruttura value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNomeStruttura()
    {
        return isset($this->NomeStruttura) ? $this->NomeStruttura : null;
    }
    /**
     * Set NomeStruttura value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nomeStruttura
     * @return \Service\StructType\UtentePCGav
     */
    public function setNomeStruttura($nomeStruttura = null)
    {
        // validation for constraint: string
        if (!is_null($nomeStruttura) && !is_string($nomeStruttura)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nomeStruttura, true), gettype($nomeStruttura)), __LINE__);
        }
        if (is_null($nomeStruttura) || (is_array($nomeStruttura) && empty($nomeStruttura))) {
            unset($this->NomeStruttura);
        } else {
            $this->NomeStruttura = $nomeStruttura;
        }
        return $this;
    }
    /**
     * Get PRESENZE_GreenPassEsente value
     * @return bool|null
     */
    public function getPRESENZE_GreenPassEsente()
    {
        return $this->PRESENZE_GreenPassEsente;
    }
    /**
     * Set PRESENZE_GreenPassEsente value
     * @param bool $pRESENZE_GreenPassEsente
     * @return \Service\StructType\UtentePCGav
     */
    public function setPRESENZE_GreenPassEsente($pRESENZE_GreenPassEsente = null)
    {
        // validation for constraint: boolean
        if (!is_null($pRESENZE_GreenPassEsente) && !is_bool($pRESENZE_GreenPassEsente)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($pRESENZE_GreenPassEsente, true), gettype($pRESENZE_GreenPassEsente)), __LINE__);
        }
        $this->PRESENZE_GreenPassEsente = $pRESENZE_GreenPassEsente;
        return $this;
    }
    /**
     * Get ProvinciaNascita value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProvinciaNascita()
    {
        return isset($this->ProvinciaNascita) ? $this->ProvinciaNascita : null;
    }
    /**
     * Set ProvinciaNascita value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $provinciaNascita
     * @return \Service\StructType\UtentePCGav
     */
    public function setProvinciaNascita($provinciaNascita = null)
    {
        // validation for constraint: string
        if (!is_null($provinciaNascita) && !is_string($provinciaNascita)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($provinciaNascita, true), gettype($provinciaNascita)), __LINE__);
        }
        if (is_null($provinciaNascita) || (is_array($provinciaNascita) && empty($provinciaNascita))) {
            unset($this->ProvinciaNascita);
        } else {
            $this->ProvinciaNascita = $provinciaNascita;
        }
        return $this;
    }
    /**
     * Get Qualifiche value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Service\ArrayType\ArrayOfQualifica|null
     */
    public function getQualifiche()
    {
        return isset($this->Qualifiche) ? $this->Qualifiche : null;
    }
    /**
     * Set Qualifiche value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Service\ArrayType\ArrayOfQualifica $qualifiche
     * @return \Service\StructType\UtentePCGav
     */
    public function setQualifiche(\Service\ArrayType\ArrayOfQualifica $qualifiche = null)
    {
        if (is_null($qualifiche) || (is_array($qualifiche) && empty($qualifiche))) {
            unset($this->Qualifiche);
        } else {
            $this->Qualifiche = $qualifiche;
        }
        return $this;
    }
    /**
     * Get Recapiti value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Service\ArrayType\ArrayOfRecapito|null
     */
    public function getRecapiti()
    {
        return isset($this->Recapiti) ? $this->Recapiti : null;
    }
    /**
     * Set Recapiti value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Service\ArrayType\ArrayOfRecapito $recapiti
     * @return \Service\StructType\UtentePCGav
     */
    public function setRecapiti(\Service\ArrayType\ArrayOfRecapito $recapiti = null)
    {
        if (is_null($recapiti) || (is_array($recapiti) && empty($recapiti))) {
            unset($this->Recapiti);
        } else {
            $this->Recapiti = $recapiti;
        }
        return $this;
    }
    /**
     * Get ResidenzaCAP value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResidenzaCAP()
    {
        return isset($this->ResidenzaCAP) ? $this->ResidenzaCAP : null;
    }
    /**
     * Set ResidenzaCAP value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $residenzaCAP
     * @return \Service\StructType\UtentePCGav
     */
    public function setResidenzaCAP($residenzaCAP = null)
    {
        // validation for constraint: string
        if (!is_null($residenzaCAP) && !is_string($residenzaCAP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($residenzaCAP, true), gettype($residenzaCAP)), __LINE__);
        }
        if (is_null($residenzaCAP) || (is_array($residenzaCAP) && empty($residenzaCAP))) {
            unset($this->ResidenzaCAP);
        } else {
            $this->ResidenzaCAP = $residenzaCAP;
        }
        return $this;
    }
    /**
     * Get ResidenzaComune value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResidenzaComune()
    {
        return isset($this->ResidenzaComune) ? $this->ResidenzaComune : null;
    }
    /**
     * Set ResidenzaComune value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $residenzaComune
     * @return \Service\StructType\UtentePCGav
     */
    public function setResidenzaComune($residenzaComune = null)
    {
        // validation for constraint: string
        if (!is_null($residenzaComune) && !is_string($residenzaComune)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($residenzaComune, true), gettype($residenzaComune)), __LINE__);
        }
        if (is_null($residenzaComune) || (is_array($residenzaComune) && empty($residenzaComune))) {
            unset($this->ResidenzaComune);
        } else {
            $this->ResidenzaComune = $residenzaComune;
        }
        return $this;
    }
    /**
     * Get ResidenzaIndirizzo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResidenzaIndirizzo()
    {
        return isset($this->ResidenzaIndirizzo) ? $this->ResidenzaIndirizzo : null;
    }
    /**
     * Set ResidenzaIndirizzo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $residenzaIndirizzo
     * @return \Service\StructType\UtentePCGav
     */
    public function setResidenzaIndirizzo($residenzaIndirizzo = null)
    {
        // validation for constraint: string
        if (!is_null($residenzaIndirizzo) && !is_string($residenzaIndirizzo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($residenzaIndirizzo, true), gettype($residenzaIndirizzo)), __LINE__);
        }
        if (is_null($residenzaIndirizzo) || (is_array($residenzaIndirizzo) && empty($residenzaIndirizzo))) {
            unset($this->ResidenzaIndirizzo);
        } else {
            $this->ResidenzaIndirizzo = $residenzaIndirizzo;
        }
        return $this;
    }
    /**
     * Get ResidenzaNumCivico value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResidenzaNumCivico()
    {
        return isset($this->ResidenzaNumCivico) ? $this->ResidenzaNumCivico : null;
    }
    /**
     * Set ResidenzaNumCivico value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $residenzaNumCivico
     * @return \Service\StructType\UtentePCGav
     */
    public function setResidenzaNumCivico($residenzaNumCivico = null)
    {
        // validation for constraint: string
        if (!is_null($residenzaNumCivico) && !is_string($residenzaNumCivico)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($residenzaNumCivico, true), gettype($residenzaNumCivico)), __LINE__);
        }
        if (is_null($residenzaNumCivico) || (is_array($residenzaNumCivico) && empty($residenzaNumCivico))) {
            unset($this->ResidenzaNumCivico);
        } else {
            $this->ResidenzaNumCivico = $residenzaNumCivico;
        }
        return $this;
    }
    /**
     * Get ResidenzaProvincia value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResidenzaProvincia()
    {
        return isset($this->ResidenzaProvincia) ? $this->ResidenzaProvincia : null;
    }
    /**
     * Set ResidenzaProvincia value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $residenzaProvincia
     * @return \Service\StructType\UtentePCGav
     */
    public function setResidenzaProvincia($residenzaProvincia = null)
    {
        // validation for constraint: string
        if (!is_null($residenzaProvincia) && !is_string($residenzaProvincia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($residenzaProvincia, true), gettype($residenzaProvincia)), __LINE__);
        }
        if (is_null($residenzaProvincia) || (is_array($residenzaProvincia) && empty($residenzaProvincia))) {
            unset($this->ResidenzaProvincia);
        } else {
            $this->ResidenzaProvincia = $residenzaProvincia;
        }
        return $this;
    }
    /**
     * Get ResidenzaProvincia_Descr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResidenzaProvincia_Descr()
    {
        return isset($this->ResidenzaProvincia_Descr) ? $this->ResidenzaProvincia_Descr : null;
    }
    /**
     * Set ResidenzaProvincia_Descr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $residenzaProvincia_Descr
     * @return \Service\StructType\UtentePCGav
     */
    public function setResidenzaProvincia_Descr($residenzaProvincia_Descr = null)
    {
        // validation for constraint: string
        if (!is_null($residenzaProvincia_Descr) && !is_string($residenzaProvincia_Descr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($residenzaProvincia_Descr, true), gettype($residenzaProvincia_Descr)), __LINE__);
        }
        if (is_null($residenzaProvincia_Descr) || (is_array($residenzaProvincia_Descr) && empty($residenzaProvincia_Descr))) {
            unset($this->ResidenzaProvincia_Descr);
        } else {
            $this->ResidenzaProvincia_Descr = $residenzaProvincia_Descr;
        }
        return $this;
    }
    /**
     * Get Sesso value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSesso()
    {
        return isset($this->Sesso) ? $this->Sesso : null;
    }
    /**
     * Set Sesso value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sesso
     * @return \Service\StructType\UtentePCGav
     */
    public function setSesso($sesso = null)
    {
        // validation for constraint: string
        if (!is_null($sesso) && !is_string($sesso)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sesso, true), gettype($sesso)), __LINE__);
        }
        if (is_null($sesso) || (is_array($sesso) && empty($sesso))) {
            unset($this->Sesso);
        } else {
            $this->Sesso = $sesso;
        }
        return $this;
    }
    /**
     * Get TipoStruttura value
     * @return string|null
     */
    public function getTipoStruttura()
    {
        return $this->TipoStruttura;
    }
    /**
     * Set TipoStruttura value
     * @uses \Service\EnumType\TipiStruttura::valueIsValid()
     * @uses \Service\EnumType\TipiStruttura::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tipoStruttura
     * @return \Service\StructType\UtentePCGav
     */
    public function setTipoStruttura($tipoStruttura = null)
    {
        // validation for constraint: enumeration
        if (!\Service\EnumType\TipiStruttura::valueIsValid($tipoStruttura)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Service\EnumType\TipiStruttura', is_array($tipoStruttura) ? implode(', ', $tipoStruttura) : var_export($tipoStruttura, true), implode(', ', \Service\EnumType\TipiStruttura::getValidValues())), __LINE__);
        }
        $this->TipoStruttura = $tipoStruttura;
        return $this;
    }
    /**
     * Get UtenteWeb value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUtenteWeb()
    {
        return isset($this->UtenteWeb) ? $this->UtenteWeb : null;
    }
    /**
     * Set UtenteWeb value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $utenteWeb
     * @return \Service\StructType\UtentePCGav
     */
    public function setUtenteWeb($utenteWeb = null)
    {
        // validation for constraint: string
        if (!is_null($utenteWeb) && !is_string($utenteWeb)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($utenteWeb, true), gettype($utenteWeb)), __LINE__);
        }
        if (is_null($utenteWeb) || (is_array($utenteWeb) && empty($utenteWeb))) {
            unset($this->UtenteWeb);
        } else {
            $this->UtenteWeb = $utenteWeb;
        }
        return $this;
    }
}
