<?php

namespace Service\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Turno_Qualifica StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Turno_Qualifica
 * @subpackage Structs
 */
class Turno_Qualifica extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ID;
    /**
     * The IDTipologia
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IDTipologia;
    /**
     * The Nome
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Nome;
    /**
     * The Personale
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Service\ArrayType\ArrayOfPartecipante
     */
    public $Personale;
    /**
     * The PersonaleMinimo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PersonaleMinimo;
    /**
     * The ResponsabileTurno
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ResponsabileTurno;
    /**
     * The Richiesta
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Richiesta;
    /**
     * Constructor method for Turno_Qualifica
     * @uses Turno_Qualifica::setID()
     * @uses Turno_Qualifica::setIDTipologia()
     * @uses Turno_Qualifica::setNome()
     * @uses Turno_Qualifica::setPersonale()
     * @uses Turno_Qualifica::setPersonaleMinimo()
     * @uses Turno_Qualifica::setResponsabileTurno()
     * @uses Turno_Qualifica::setRichiesta()
     * @param int $iD
     * @param int $iDTipologia
     * @param string $nome
     * @param \Service\ArrayType\ArrayOfPartecipante $personale
     * @param int $personaleMinimo
     * @param bool $responsabileTurno
     * @param bool $richiesta
     */
    public function __construct($iD = null, $iDTipologia = null, $nome = null, \Service\ArrayType\ArrayOfPartecipante $personale = null, $personaleMinimo = null, $responsabileTurno = null, $richiesta = null)
    {
        $this
            ->setID($iD)
            ->setIDTipologia($iDTipologia)
            ->setNome($nome)
            ->setPersonale($personale)
            ->setPersonaleMinimo($personaleMinimo)
            ->setResponsabileTurno($responsabileTurno)
            ->setRichiesta($richiesta);
    }
    /**
     * Get ID value
     * @return int|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \Service\StructType\Turno_Qualifica
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !(is_int($iD) || ctype_digit($iD))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get IDTipologia value
     * @return int|null
     */
    public function getIDTipologia()
    {
        return $this->IDTipologia;
    }
    /**
     * Set IDTipologia value
     * @param int $iDTipologia
     * @return \Service\StructType\Turno_Qualifica
     */
    public function setIDTipologia($iDTipologia = null)
    {
        // validation for constraint: int
        if (!is_null($iDTipologia) && !(is_int($iDTipologia) || ctype_digit($iDTipologia))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iDTipologia, true), gettype($iDTipologia)), __LINE__);
        }
        $this->IDTipologia = $iDTipologia;
        return $this;
    }
    /**
     * Get Nome value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNome()
    {
        return isset($this->Nome) ? $this->Nome : null;
    }
    /**
     * Set Nome value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nome
     * @return \Service\StructType\Turno_Qualifica
     */
    public function setNome($nome = null)
    {
        // validation for constraint: string
        if (!is_null($nome) && !is_string($nome)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nome, true), gettype($nome)), __LINE__);
        }
        if (is_null($nome) || (is_array($nome) && empty($nome))) {
            unset($this->Nome);
        } else {
            $this->Nome = $nome;
        }
        return $this;
    }
    /**
     * Get Personale value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Service\ArrayType\ArrayOfPartecipante|null
     */
    public function getPersonale()
    {
        return isset($this->Personale) ? $this->Personale : null;
    }
    /**
     * Set Personale value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Service\ArrayType\ArrayOfPartecipante $personale
     * @return \Service\StructType\Turno_Qualifica
     */
    public function setPersonale(\Service\ArrayType\ArrayOfPartecipante $personale = null)
    {
        if (is_null($personale) || (is_array($personale) && empty($personale))) {
            unset($this->Personale);
        } else {
            $this->Personale = $personale;
        }
        return $this;
    }
    /**
     * Get PersonaleMinimo value
     * @return int|null
     */
    public function getPersonaleMinimo()
    {
        return $this->PersonaleMinimo;
    }
    /**
     * Set PersonaleMinimo value
     * @param int $personaleMinimo
     * @return \Service\StructType\Turno_Qualifica
     */
    public function setPersonaleMinimo($personaleMinimo = null)
    {
        // validation for constraint: int
        if (!is_null($personaleMinimo) && !(is_int($personaleMinimo) || ctype_digit($personaleMinimo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($personaleMinimo, true), gettype($personaleMinimo)), __LINE__);
        }
        $this->PersonaleMinimo = $personaleMinimo;
        return $this;
    }
    /**
     * Get ResponsabileTurno value
     * @return bool|null
     */
    public function getResponsabileTurno()
    {
        return $this->ResponsabileTurno;
    }
    /**
     * Set ResponsabileTurno value
     * @param bool $responsabileTurno
     * @return \Service\StructType\Turno_Qualifica
     */
    public function setResponsabileTurno($responsabileTurno = null)
    {
        // validation for constraint: boolean
        if (!is_null($responsabileTurno) && !is_bool($responsabileTurno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($responsabileTurno, true), gettype($responsabileTurno)), __LINE__);
        }
        $this->ResponsabileTurno = $responsabileTurno;
        return $this;
    }
    /**
     * Get Richiesta value
     * @return bool|null
     */
    public function getRichiesta()
    {
        return $this->Richiesta;
    }
    /**
     * Set Richiesta value
     * @param bool $richiesta
     * @return \Service\StructType\Turno_Qualifica
     */
    public function setRichiesta($richiesta = null)
    {
        // validation for constraint: boolean
        if (!is_null($richiesta) && !is_bool($richiesta)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($richiesta, true), gettype($richiesta)), __LINE__);
        }
        $this->Richiesta = $richiesta;
        return $this;
    }
}
