<?php

namespace Service\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SalvaAnagrafe StructType
 * @subpackage Structs
 */
class SalvaAnagrafe extends AbstractStructBase
{
    /**
     * The IDProdotto
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $IDProdotto;
    /**
     * The Anagrafe
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Service\StructType\AnagraficaDettaglio_Model
     */
    public $Anagrafe;
    /**
     * Constructor method for SalvaAnagrafe
     * @uses SalvaAnagrafe::setIDProdotto()
     * @uses SalvaAnagrafe::setAnagrafe()
     * @param string $iDProdotto
     * @param \Service\StructType\AnagraficaDettaglio_Model $anagrafe
     */
    public function __construct($iDProdotto = null, \Service\StructType\AnagraficaDettaglio_Model $anagrafe = null)
    {
        $this
            ->setIDProdotto($iDProdotto)
            ->setAnagrafe($anagrafe);
    }
    /**
     * Get IDProdotto value
     * @return string|null
     */
    public function getIDProdotto()
    {
        return $this->IDProdotto;
    }
    /**
     * Set IDProdotto value
     * @uses \Service\EnumType\SoftwareClient::valueIsValid()
     * @uses \Service\EnumType\SoftwareClient::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $iDProdotto
     * @return \Service\StructType\SalvaAnagrafe
     */
    public function setIDProdotto($iDProdotto = null)
    {
        // validation for constraint: enumeration
        if (!\Service\EnumType\SoftwareClient::valueIsValid($iDProdotto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Service\EnumType\SoftwareClient', is_array($iDProdotto) ? implode(', ', $iDProdotto) : var_export($iDProdotto, true), implode(', ', \Service\EnumType\SoftwareClient::getValidValues())), __LINE__);
        }
        $this->IDProdotto = $iDProdotto;
        return $this;
    }
    /**
     * Get Anagrafe value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Service\StructType\AnagraficaDettaglio_Model|null
     */
    public function getAnagrafe()
    {
        return isset($this->Anagrafe) ? $this->Anagrafe : null;
    }
    /**
     * Set Anagrafe value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Service\StructType\AnagraficaDettaglio_Model $anagrafe
     * @return \Service\StructType\SalvaAnagrafe
     */
    public function setAnagrafe(\Service\StructType\AnagraficaDettaglio_Model $anagrafe = null)
    {
        if (is_null($anagrafe) || (is_array($anagrafe) && empty($anagrafe))) {
            unset($this->Anagrafe);
        } else {
            $this->Anagrafe = $anagrafe;
        }
        return $this;
    }
}
