<?php

namespace Service\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetListaSegnalazioniGuasto_Result StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetListaSegnalazioniGuasto_Result
 * @subpackage Structs
 */
class GetListaSegnalazioniGuasto_Result extends WebService_GenericResult
{
    /**
     * The NeedsToLoadMore
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $NeedsToLoadMore;
    /**
     * The Segnalazioni
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Service\ArrayType\ArrayOfSegnalazioneGuasto_Model
     */
    public $Segnalazioni;
    /**
     * The UltimaRiga
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $UltimaRiga;
    /**
     * Constructor method for GetListaSegnalazioniGuasto_Result
     * @uses GetListaSegnalazioniGuasto_Result::setNeedsToLoadMore()
     * @uses GetListaSegnalazioniGuasto_Result::setSegnalazioni()
     * @uses GetListaSegnalazioniGuasto_Result::setUltimaRiga()
     * @param bool $needsToLoadMore
     * @param \Service\ArrayType\ArrayOfSegnalazioneGuasto_Model $segnalazioni
     * @param int $ultimaRiga
     */
    public function __construct($needsToLoadMore = null, \Service\ArrayType\ArrayOfSegnalazioneGuasto_Model $segnalazioni = null, $ultimaRiga = null)
    {
        $this
            ->setNeedsToLoadMore($needsToLoadMore)
            ->setSegnalazioni($segnalazioni)
            ->setUltimaRiga($ultimaRiga);
    }
    /**
     * Get NeedsToLoadMore value
     * @return bool|null
     */
    public function getNeedsToLoadMore()
    {
        return $this->NeedsToLoadMore;
    }
    /**
     * Set NeedsToLoadMore value
     * @param bool $needsToLoadMore
     * @return \Service\StructType\GetListaSegnalazioniGuasto_Result
     */
    public function setNeedsToLoadMore($needsToLoadMore = null)
    {
        // validation for constraint: boolean
        if (!is_null($needsToLoadMore) && !is_bool($needsToLoadMore)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($needsToLoadMore, true), gettype($needsToLoadMore)), __LINE__);
        }
        $this->NeedsToLoadMore = $needsToLoadMore;
        return $this;
    }
    /**
     * Get Segnalazioni value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Service\ArrayType\ArrayOfSegnalazioneGuasto_Model|null
     */
    public function getSegnalazioni()
    {
        return isset($this->Segnalazioni) ? $this->Segnalazioni : null;
    }
    /**
     * Set Segnalazioni value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Service\ArrayType\ArrayOfSegnalazioneGuasto_Model $segnalazioni
     * @return \Service\StructType\GetListaSegnalazioniGuasto_Result
     */
    public function setSegnalazioni(\Service\ArrayType\ArrayOfSegnalazioneGuasto_Model $segnalazioni = null)
    {
        if (is_null($segnalazioni) || (is_array($segnalazioni) && empty($segnalazioni))) {
            unset($this->Segnalazioni);
        } else {
            $this->Segnalazioni = $segnalazioni;
        }
        return $this;
    }
    /**
     * Get UltimaRiga value
     * @return int|null
     */
    public function getUltimaRiga()
    {
        return $this->UltimaRiga;
    }
    /**
     * Set UltimaRiga value
     * @param int $ultimaRiga
     * @return \Service\StructType\GetListaSegnalazioniGuasto_Result
     */
    public function setUltimaRiga($ultimaRiga = null)
    {
        // validation for constraint: int
        if (!is_null($ultimaRiga) && !(is_int($ultimaRiga) || ctype_digit($ultimaRiga))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ultimaRiga, true), gettype($ultimaRiga)), __LINE__);
        }
        $this->UltimaRiga = $ultimaRiga;
        return $this;
    }
}
