<?php

namespace Service\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AttivitaModel StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AttivitaModel
 * @subpackage Structs
 */
class AttivitaModel extends AbstractStructBase
{
    /**
     * The Descrizione
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Descrizione;
    /**
     * The DottyVisible
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $DottyVisible;
    /**
     * The IDTipologia
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IDTipologia;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Id;
    /**
     * The Qualifiche
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Service\ArrayType\ArrayOfQualifica
     */
    public $Qualifiche;
    /**
     * The TurniVisible
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $TurniVisible;
    /**
     * Constructor method for AttivitaModel
     * @uses AttivitaModel::setDescrizione()
     * @uses AttivitaModel::setDottyVisible()
     * @uses AttivitaModel::setIDTipologia()
     * @uses AttivitaModel::setId()
     * @uses AttivitaModel::setQualifiche()
     * @uses AttivitaModel::setTurniVisible()
     * @param string $descrizione
     * @param bool $dottyVisible
     * @param int $iDTipologia
     * @param int $id
     * @param \Service\ArrayType\ArrayOfQualifica $qualifiche
     * @param bool $turniVisible
     */
    public function __construct($descrizione = null, $dottyVisible = null, $iDTipologia = null, $id = null, \Service\ArrayType\ArrayOfQualifica $qualifiche = null, $turniVisible = null)
    {
        $this
            ->setDescrizione($descrizione)
            ->setDottyVisible($dottyVisible)
            ->setIDTipologia($iDTipologia)
            ->setId($id)
            ->setQualifiche($qualifiche)
            ->setTurniVisible($turniVisible);
    }
    /**
     * Get Descrizione value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescrizione()
    {
        return isset($this->Descrizione) ? $this->Descrizione : null;
    }
    /**
     * Set Descrizione value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $descrizione
     * @return \Service\StructType\AttivitaModel
     */
    public function setDescrizione($descrizione = null)
    {
        // validation for constraint: string
        if (!is_null($descrizione) && !is_string($descrizione)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descrizione, true), gettype($descrizione)), __LINE__);
        }
        if (is_null($descrizione) || (is_array($descrizione) && empty($descrizione))) {
            unset($this->Descrizione);
        } else {
            $this->Descrizione = $descrizione;
        }
        return $this;
    }
    /**
     * Get DottyVisible value
     * @return bool|null
     */
    public function getDottyVisible()
    {
        return $this->DottyVisible;
    }
    /**
     * Set DottyVisible value
     * @param bool $dottyVisible
     * @return \Service\StructType\AttivitaModel
     */
    public function setDottyVisible($dottyVisible = null)
    {
        // validation for constraint: boolean
        if (!is_null($dottyVisible) && !is_bool($dottyVisible)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($dottyVisible, true), gettype($dottyVisible)), __LINE__);
        }
        $this->DottyVisible = $dottyVisible;
        return $this;
    }
    /**
     * Get IDTipologia value
     * @return int|null
     */
    public function getIDTipologia()
    {
        return $this->IDTipologia;
    }
    /**
     * Set IDTipologia value
     * @param int $iDTipologia
     * @return \Service\StructType\AttivitaModel
     */
    public function setIDTipologia($iDTipologia = null)
    {
        // validation for constraint: int
        if (!is_null($iDTipologia) && !(is_int($iDTipologia) || ctype_digit($iDTipologia))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iDTipologia, true), gettype($iDTipologia)), __LINE__);
        }
        $this->IDTipologia = $iDTipologia;
        return $this;
    }
    /**
     * Get Id value
     * @return int|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \Service\StructType\AttivitaModel
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Qualifiche value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Service\ArrayType\ArrayOfQualifica|null
     */
    public function getQualifiche()
    {
        return isset($this->Qualifiche) ? $this->Qualifiche : null;
    }
    /**
     * Set Qualifiche value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Service\ArrayType\ArrayOfQualifica $qualifiche
     * @return \Service\StructType\AttivitaModel
     */
    public function setQualifiche(\Service\ArrayType\ArrayOfQualifica $qualifiche = null)
    {
        if (is_null($qualifiche) || (is_array($qualifiche) && empty($qualifiche))) {
            unset($this->Qualifiche);
        } else {
            $this->Qualifiche = $qualifiche;
        }
        return $this;
    }
    /**
     * Get TurniVisible value
     * @return bool|null
     */
    public function getTurniVisible()
    {
        return $this->TurniVisible;
    }
    /**
     * Set TurniVisible value
     * @param bool $turniVisible
     * @return \Service\StructType\AttivitaModel
     */
    public function setTurniVisible($turniVisible = null)
    {
        // validation for constraint: boolean
        if (!is_null($turniVisible) && !is_bool($turniVisible)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($turniVisible, true), gettype($turniVisible)), __LINE__);
        }
        $this->TurniVisible = $turniVisible;
        return $this;
    }
}
