<?php

namespace Service;

/**
 * Class which returns the class map definition
 * @package
 */
class ClassMap
{
    /**
     * Returns the mapping between the WSDL Structs and generated Structs' classes
     * This array is sent to the \SoapClient when calling the WS
     * @return string[]
     */
    final public static function get()
    {
        return array(
            'ArrayOfCorsoFormazione' => '\\Service\\ArrayType\\ArrayOfCorsoFormazione',
            'CorsoFormazione' => '\\Service\\StructType\\CorsoFormazione',
            'UtentePCGav' => '\\Service\\StructType\\UtentePCGav',
            'ArrayOfAttivitaUtente' => '\\Service\\ArrayType\\ArrayOfAttivitaUtente',
            'AttivitaUtente' => '\\Service\\StructType\\AttivitaUtente',
            'AttivitaModel' => '\\Service\\StructType\\AttivitaModel',
            'ArrayOfQualifica' => '\\Service\\ArrayType\\ArrayOfQualifica',
            'Qualifica' => '\\Service\\StructType\\Qualifica',
            'ArrayOfPresenza_CheckListRichiestaModel' => '\\Service\\ArrayType\\ArrayOfPresenza_CheckListRichiestaModel',
            'Presenza_CheckListRichiestaModel' => '\\Service\\StructType\\Presenza_CheckListRichiestaModel',
            'ArrayOfRecapito' => '\\Service\\ArrayType\\ArrayOfRecapito',
            'Recapito' => '\\Service\\StructType\\Recapito',
            'Configurazione' => '\\Service\\StructType\\Configurazione',
            'ConfigurazioneBase' => '\\Service\\StructType\\ConfigurazioneBase',
            'IntegrazioneCupMisericordie' => '\\Service\\StructType\\IntegrazioneCupMisericordie',
            'IntegrazioneCupSubito' => '\\Service\\StructType\\IntegrazioneCupSubito',
            'ArrayOfMezzo_Model' => '\\Service\\ArrayType\\ArrayOfMezzo_Model',
            'Mezzo_Model' => '\\Service\\StructType\\Mezzo_Model',
            'ArrayOfRichiestaCartellino_Motivo' => '\\Service\\ArrayType\\ArrayOfRichiestaCartellino_Motivo',
            'RichiestaCartellino_Motivo' => '\\Service\\StructType\\RichiestaCartellino_Motivo',
            'RichiestaCartellino_Motivo_Identificativo' => '\\Service\\StructType\\RichiestaCartellino_Motivo_Identificativo',
            'ArrayOfSezione' => '\\Service\\ArrayType\\ArrayOfSezione',
            'Sezione' => '\\Service\\StructType\\Sezione',
            'Coordinate' => '\\Service\\StructType\\Coordinate',
            'ArrayOfGruppoTurni' => '\\Service\\ArrayType\\ArrayOfGruppoTurni',
            'GruppoTurni' => '\\Service\\StructType\\GruppoTurni',
            'ArrayOfSezione_Model' => '\\Service\\ArrayType\\ArrayOfSezione_Model',
            'Sezione_Model' => '\\Service\\StructType\\Sezione_Model',
            'ArrayOfTipoRecapito' => '\\Service\\ArrayType\\ArrayOfTipoRecapito',
            'TipoRecapito' => '\\Service\\StructType\\TipoRecapito',
            'Login_Result' => '\\Service\\StructType\\Login_Result',
            'AdditionaInformation' => '\\Service\\StructType\\AdditionaInformation',
            'RegistraFCMToken_Result' => '\\Service\\StructType\\RegistraFCMToken_Result',
            'WebService_GenericResult' => '\\Service\\StructType\\WebService_GenericResult',
            'UnregisterFCMToken_Request' => '\\Service\\StructType\\UnregisterFCMToken_Request',
            'DeviceModel' => '\\Service\\StructType\\DeviceModel',
            'UnregisterFCMToken_Response' => '\\Service\\StructType\\UnregisterFCMToken_Response',
            'Login_EasyGAV_Web_Result' => '\\Service\\StructType\\Login_EasyGAV_Web_Result',
            'ConfigurazioneApp' => '\\Service\\StructType\\ConfigurazioneApp',
            'Login_SGEServer_Result' => '\\Service\\StructType\\Login_SGEServer_Result',
            'Classe_Model' => '\\Service\\StructType\\Classe_Model',
            'Quota_Model' => '\\Service\\StructType\\Quota_Model',
            'ArrayOfProvincia_Model' => '\\Service\\ArrayType\\ArrayOfProvincia_Model',
            'Provincia_Model' => '\\Service\\StructType\\Provincia_Model',
            'GetProfilo_Result' => '\\Service\\StructType\\GetProfilo_Result',
            'UpdateUser_Result' => '\\Service\\StructType\\UpdateUser_Result',
            'UpdateUserProfilePhoto_Result' => '\\Service\\StructType\\UpdateUserProfilePhoto_Result',
            'GetConfigurazione_Result' => '\\Service\\StructType\\GetConfigurazione_Result',
            'InviaPresenza_Result' => '\\Service\\StructType\\InviaPresenza_Result',
            'Presenza' => '\\Service\\StructType\\Presenza',
            'InviaPresenza_Request' => '\\Service\\StructType\\InviaPresenza_Request',
            'PresenzaModel' => '\\Service\\StructType\\PresenzaModel',
            'ArrayOfPresenza_CheckListRispostaModel' => '\\Service\\ArrayType\\ArrayOfPresenza_CheckListRispostaModel',
            'Presenza_CheckListRispostaModel' => '\\Service\\StructType\\Presenza_CheckListRispostaModel',
            'InviaPresenza_Response' => '\\Service\\StructType\\InviaPresenza_Response',
            'InviaPresenza3_Request' => '\\Service\\StructType\\InviaPresenza3_Request',
            'GetCheckList_Richieste_Request' => '\\Service\\StructType\\GetCheckList_Richieste_Request',
            'GetCheckList_Richieste_Response' => '\\Service\\StructType\\GetCheckList_Richieste_Response',
            'GetRegioni_Result' => '\\Service\\StructType\\GetRegioni_Result',
            'ArrayOfResultCodiceDescrizione' => '\\Service\\ArrayType\\ArrayOfResultCodiceDescrizione',
            'ResultCodiceDescrizione' => '\\Service\\StructType\\ResultCodiceDescrizione',
            'GetProvince_Result' => '\\Service\\StructType\\GetProvince_Result',
            'GetComuni_Result' => '\\Service\\StructType\\GetComuni_Result',
            'GetRecapiti_Result' => '\\Service\\StructType\\GetRecapiti_Result',
            'GetRecapito_Result' => '\\Service\\StructType\\GetRecapito_Result',
            'Recapito_Model' => '\\Service\\StructType\\Recapito_Model',
            'SalvaRecapito_Result' => '\\Service\\StructType\\SalvaRecapito_Result',
            'DeleteRecapito_Result' => '\\Service\\StructType\\DeleteRecapito_Result',
            'GetQualifiche_Result' => '\\Service\\StructType\\GetQualifiche_Result',
            'SendRecapiti_Result' => '\\Service\\StructType\\SendRecapiti_Result',
            'GetCorsi_Result' => '\\Service\\StructType\\GetCorsi_Result',
            'ArrayOfDatiCorso' => '\\Service\\ArrayType\\ArrayOfDatiCorso',
            'DatiCorso' => '\\Service\\StructType\\DatiCorso',
            'Anagrafica_Model' => '\\Service\\StructType\\Anagrafica_Model',
            'Socio_Model' => '\\Service\\StructType\\Socio_Model',
            'Volontario_Model' => '\\Service\\StructType\\Volontario_Model',
            'SendCorsoRegistrazione_Result' => '\\Service\\StructType\\SendCorsoRegistrazione_Result',
            'SendCorsoCancellaRegistrazione_Result' => '\\Service\\StructType\\SendCorsoCancellaRegistrazione_Result',
            'GetTurni_Result' => '\\Service\\StructType\\GetTurni_Result',
            'ArrayOfTGiorno' => '\\Service\\ArrayType\\ArrayOfTGiorno',
            'TGiorno' => '\\Service\\StructType\\TGiorno',
            'ArrayOfTurno' => '\\Service\\ArrayType\\ArrayOfTurno',
            'Turno' => '\\Service\\StructType\\Turno',
            'ArrayOfTAttivita' => '\\Service\\ArrayType\\ArrayOfTAttivita',
            'TAttivita' => '\\Service\\StructType\\TAttivita',
            'ArrayOfTPartecipante' => '\\Service\\ArrayType\\ArrayOfTPartecipante',
            'TPartecipante' => '\\Service\\StructType\\TPartecipante',
            'Partecipante' => '\\Service\\StructType\\Partecipante',
            'Mezzo' => '\\Service\\StructType\\Mezzo',
            'ArrayOfTurno_Qualifica' => '\\Service\\ArrayType\\ArrayOfTurno_Qualifica',
            'Turno_Qualifica' => '\\Service\\StructType\\Turno_Qualifica',
            'ArrayOfPartecipante' => '\\Service\\ArrayType\\ArrayOfPartecipante',
            'GetTurniOperatore_Result' => '\\Service\\StructType\\GetTurniOperatore_Result',
            'GetEventiOperatore_Result' => '\\Service\\StructType\\GetEventiOperatore_Result',
            'GetEventi_Result' => '\\Service\\StructType\\GetEventi_Result',
            'ArrayOfEGiorno' => '\\Service\\ArrayType\\ArrayOfEGiorno',
            'EGiorno' => '\\Service\\StructType\\EGiorno',
            'ArrayOfEvento' => '\\Service\\ArrayType\\ArrayOfEvento',
            'Evento' => '\\Service\\StructType\\Evento',
            'ArrayOfEAttivita' => '\\Service\\ArrayType\\ArrayOfEAttivita',
            'EAttivita' => '\\Service\\StructType\\EAttivita',
            'ArrayOfEPartecipante' => '\\Service\\ArrayType\\ArrayOfEPartecipante',
            'EPartecipante' => '\\Service\\StructType\\EPartecipante',
            'GetCalendarioTurniLite_Result' => '\\Service\\StructType\\GetCalendarioTurniLite_Result',
            'ArrayOfTurnoLite' => '\\Service\\ArrayType\\ArrayOfTurnoLite',
            'TurnoLite' => '\\Service\\StructType\\TurnoLite',
            'GetTurnoSpecifico_Result' => '\\Service\\StructType\\GetTurnoSpecifico_Result',
            'GetGiornoEvento_Result' => '\\Service\\StructType\\GetGiornoEvento_Result',
            'IscrizioneTurno_Result' => '\\Service\\StructType\\IscrizioneTurno_Result',
            'ModificaIscrizioneTurno_Result' => '\\Service\\StructType\\ModificaIscrizioneTurno_Result',
            'IscrizioneEvento_Result' => '\\Service\\StructType\\IscrizioneEvento_Result',
            'CancellazioneIscrizioneTurno_Result' => '\\Service\\StructType\\CancellazioneIscrizioneTurno_Result',
            'CancellazioneIscrizioneEvento_Result' => '\\Service\\StructType\\CancellazioneIscrizioneEvento_Result',
            'GetAttivitaUtente_Result' => '\\Service\\StructType\\GetAttivitaUtente_Result',
            'GetMessaggi_Result' => '\\Service\\StructType\\GetMessaggi_Result',
            'ArrayOfMessaggio' => '\\Service\\ArrayType\\ArrayOfMessaggio',
            'Messaggio' => '\\Service\\StructType\\Messaggio',
            'GetLastPresenza_Result' => '\\Service\\StructType\\GetLastPresenza_Result',
            'GetLastPresenza_Request' => '\\Service\\StructType\\GetLastPresenza_Request',
            'GetLastPresenza_Response' => '\\Service\\StructType\\GetLastPresenza_Response',
            'GetNotifiche_Result' => '\\Service\\StructType\\GetNotifiche_Result',
            'ArrayOfNotificaClient' => '\\Service\\ArrayType\\ArrayOfNotificaClient',
            'NotificaClient' => '\\Service\\StructType\\NotificaClient',
            'Notifica' => '\\Service\\StructType\\Notifica',
            'GetTestoNotifica_Result' => '\\Service\\StructType\\GetTestoNotifica_Result',
            'GetTotaleNotificheDaNotificare_Result' => '\\Service\\StructType\\GetTotaleNotificheDaNotificare_Result',
            'SetNotificaLetta_Result' => '\\Service\\StructType\\SetNotificaLetta_Result',
            'SetNotificheNotificate_Result' => '\\Service\\StructType\\SetNotificheNotificate_Result',
            'Anagrafe_Ricerca' => '\\Service\\StructType\\Anagrafe_Ricerca',
            'Anagrafe_Ricerca_Result' => '\\Service\\StructType\\Anagrafe_Ricerca_Result',
            'ArrayOfAnagrafica_Model' => '\\Service\\ArrayType\\ArrayOfAnagrafica_Model',
            'Anagrafe_Get_Result' => '\\Service\\StructType\\Anagrafe_Get_Result',
            'AnagraficaDettaglio_Model' => '\\Service\\StructType\\AnagraficaDettaglio_Model',
            'Comune_Model' => '\\Service\\StructType\\Comune_Model',
            'Donatore_Model' => '\\Service\\StructType\\Donatore_Model',
            'ArrayOfAnagrafePrivacy_Model' => '\\Service\\ArrayType\\ArrayOfAnagrafePrivacy_Model',
            'AnagrafePrivacy_Model' => '\\Service\\StructType\\AnagrafePrivacy_Model',
            'Privacy_Model' => '\\Service\\StructType\\Privacy_Model',
            'ArrayOfRecapito_Model' => '\\Service\\ArrayType\\ArrayOfRecapito_Model',
            'Stradario_Identifier_Model' => '\\Service\\StructType\\Stradario_Identifier_Model',
            'Report_Get_Result' => '\\Service\\StructType\\Report_Get_Result',
            'OutputCsv_Get_Result' => '\\Service\\StructType\\OutputCsv_Get_Result',
            'GetListaSegnalazioniGuasto_Result' => '\\Service\\StructType\\GetListaSegnalazioniGuasto_Result',
            'ArrayOfSegnalazioneGuasto_Model' => '\\Service\\ArrayType\\ArrayOfSegnalazioneGuasto_Model',
            'SegnalazioneGuasto_Model' => '\\Service\\StructType\\SegnalazioneGuasto_Model',
            'Articolo_Model' => '\\Service\\StructType\\Articolo_Model',
            'GetListaArticoliSegnalazioneGuasto_Result' => '\\Service\\StructType\\GetListaArticoliSegnalazioneGuasto_Result',
            'ArrayOfArticolo_Model' => '\\Service\\ArrayType\\ArrayOfArticolo_Model',
            'SendSegnalazioniGuasto_Result' => '\\Service\\StructType\\SendSegnalazioniGuasto_Result',
            'RiassegnaMezzoMissioni_Request' => '\\Service\\StructType\\RiassegnaMezzoMissioni_Request',
            'ArrayOfMissioneBase_Model' => '\\Service\\ArrayType\\ArrayOfMissioneBase_Model',
            'MissioneBase_Model' => '\\Service\\StructType\\MissioneBase_Model',
            'RiassegnaMezzoMissioni_Result' => '\\Service\\StructType\\RiassegnaMezzoMissioni_Result',
            'InsertRichiestaCartellino_Request' => '\\Service\\StructType\\InsertRichiestaCartellino_Request',
            'RichiestaCartellino' => '\\Service\\StructType\\RichiestaCartellino',
            'RichiestaCartellinoBase' => '\\Service\\StructType\\RichiestaCartellinoBase',
            'RichestaCartellino_DatiBollatura' => '\\Service\\StructType\\RichestaCartellino_DatiBollatura',
            'RichestaCartellino_DatiBollatura_Identificativo' => '\\Service\\StructType\\RichestaCartellino_DatiBollatura_Identificativo',
            'RichiestaCartellino_Identificativo' => '\\Service\\StructType\\RichiestaCartellino_Identificativo',
            'ArrayOfRichiestaCartellino_Evento' => '\\Service\\ArrayType\\ArrayOfRichiestaCartellino_Evento',
            'RichiestaCartellino_Evento' => '\\Service\\StructType\\RichiestaCartellino_Evento',
            'RichiestaCartellino_Evento_Identificativo' => '\\Service\\StructType\\RichiestaCartellino_Evento_Identificativo',
            'AnagraficaModel' => '\\Service\\StructType\\AnagraficaModel',
            'AnagraficaModel_Identificativo' => '\\Service\\StructType\\AnagraficaModel_Identificativo',
            'InsertRichiestaCartellino_Response' => '\\Service\\StructType\\InsertRichiestaCartellino_Response',
            'UpdateRichiestaCartellino_Request' => '\\Service\\StructType\\UpdateRichiestaCartellino_Request',
            'UpdateRichiestaCartellino_Response' => '\\Service\\StructType\\UpdateRichiestaCartellino_Response',
            'GetRichiesteCartellino_Request' => '\\Service\\StructType\\GetRichiesteCartellino_Request',
            'GetRichiesteCartellino_Response' => '\\Service\\StructType\\GetRichiesteCartellino_Response',
            'ArrayOfRichiestaCartellino' => '\\Service\\ArrayType\\ArrayOfRichiestaCartellino',
            'GetRichiestaCartellino_Request' => '\\Service\\StructType\\GetRichiestaCartellino_Request',
            'GetRichiestaCartellino_Response' => '\\Service\\StructType\\GetRichiestaCartellino_Response',
            'DeleteRichiestaCartellino_Request' => '\\Service\\StructType\\DeleteRichiestaCartellino_Request',
            'DeleteRichiestaCartellino_Response' => '\\Service\\StructType\\DeleteRichiestaCartellino_Response',
            'InsertEventolRichiestaCartellino_Request' => '\\Service\\StructType\\InsertEventolRichiestaCartellino_Request',
            'InsertEventolRichiestaCartellino_Response' => '\\Service\\StructType\\InsertEventolRichiestaCartellino_Response',
            'GetListaRuoliOperatori_Request' => '\\Service\\StructType\\GetListaRuoliOperatori_Request',
            'GetListaRuoliOperatori_Response' => '\\Service\\StructType\\GetListaRuoliOperatori_Response',
            'ArrayOfRuoloOperatori_Model' => '\\Service\\ArrayType\\ArrayOfRuoloOperatori_Model',
            'RuoloOperatori_Model' => '\\Service\\StructType\\RuoloOperatori_Model',
            'ArrayOfAnagraficaPersonale_Model' => '\\Service\\ArrayType\\ArrayOfAnagraficaPersonale_Model',
            'AnagraficaPersonale_Model' => '\\Service\\StructType\\AnagraficaPersonale_Model',
            'GetListaStradari_Request' => '\\Service\\StructType\\GetListaStradari_Request',
            'GetListaStradari_Response' => '\\Service\\StructType\\GetListaStradari_Response',
            'ArrayOfStradario_Model' => '\\Service\\ArrayType\\ArrayOfStradario_Model',
            'Stradario_Model' => '\\Service\\StructType\\Stradario_Model',
            'CheckGreenPassResponse' => '\\Service\\StructType\\CheckGreenPassResponse',
            'GetCorsiUtenteRequest' => '\\Service\\StructType\\GetCorsiUtenteRequest',
            'GetCorsiUtenteRespone' => '\\Service\\StructType\\GetCorsiUtenteRespone',
            'ArrayOfCorso' => '\\Service\\ArrayType\\ArrayOfCorso',
            'Corso' => '\\Service\\StructType\\Corso',
            'CancellaIscrizioneCorsoRequest' => '\\Service\\StructType\\CancellaIscrizioneCorsoRequest',
            'CancellaIscrizioneCorsoResponse' => '\\Service\\StructType\\CancellaIscrizioneCorsoResponse',
            'GetVersion' => '\\Service\\StructType\\GetVersion',
            'GetVersionResponse' => '\\Service\\StructType\\GetVersionResponse',
            'Login' => '\\Service\\StructType\\Login',
            'LoginResponse' => '\\Service\\StructType\\LoginResponse',
            'RegistraFCMToken' => '\\Service\\StructType\\RegistraFCMToken',
            'RegistraFCMTokenResponse' => '\\Service\\StructType\\RegistraFCMTokenResponse',
            'UnRegisterFCMToken' => '\\Service\\StructType\\UnRegisterFCMToken',
            'UnRegisterFCMTokenResponse' => '\\Service\\StructType\\UnRegisterFCMTokenResponse',
            'Login_Tessera' => '\\Service\\StructType\\Login_Tessera',
            'Login_TesseraResponse' => '\\Service\\StructType\\Login_TesseraResponse',
            'Login_EasyGAV_Web' => '\\Service\\StructType\\Login_EasyGAV_Web',
            'Login_EasyGAV_WebResponse' => '\\Service\\StructType\\Login_EasyGAV_WebResponse',
            'Login_SGEServer' => '\\Service\\StructType\\Login_SGEServer',
            'Login_SGEServerResponse' => '\\Service\\StructType\\Login_SGEServerResponse',
            'GetInternalProtocolVersion' => '\\Service\\StructType\\GetInternalProtocolVersion',
            'GetInternalProtocolVersionResponse' => '\\Service\\StructType\\GetInternalProtocolVersionResponse',
            'GetProfilo' => '\\Service\\StructType\\GetProfilo',
            'GetProfiloResponse' => '\\Service\\StructType\\GetProfiloResponse',
            'UpdateUser' => '\\Service\\StructType\\UpdateUser',
            'UpdateUserResponse' => '\\Service\\StructType\\UpdateUserResponse',
            'UpdateUserProfilePhoto' => '\\Service\\StructType\\UpdateUserProfilePhoto',
            'UpdateUserProfilePhotoResponse' => '\\Service\\StructType\\UpdateUserProfilePhotoResponse',
            'GetConfigurazione' => '\\Service\\StructType\\GetConfigurazione',
            'GetConfigurazioneResponse' => '\\Service\\StructType\\GetConfigurazioneResponse',
            'InviaPresenza' => '\\Service\\StructType\\InviaPresenza',
            'InviaPresenzaResponse' => '\\Service\\StructType\\InviaPresenzaResponse',
            'InviaPresenza2' => '\\Service\\StructType\\InviaPresenza2',
            'InviaPresenza2Response' => '\\Service\\StructType\\InviaPresenza2Response',
            'InviaPresenza3' => '\\Service\\StructType\\InviaPresenza3',
            'InviaPresenza3Response' => '\\Service\\StructType\\InviaPresenza3Response',
            'GetCheckList_Richieste' => '\\Service\\StructType\\GetCheckList_Richieste',
            'GetCheckList_RichiesteResponse' => '\\Service\\StructType\\GetCheckList_RichiesteResponse',
            'GetRegioni' => '\\Service\\StructType\\GetRegioni',
            'GetRegioniResponse' => '\\Service\\StructType\\GetRegioniResponse',
            'GetProvince' => '\\Service\\StructType\\GetProvince',
            'GetProvinceResponse' => '\\Service\\StructType\\GetProvinceResponse',
            'GetComuni' => '\\Service\\StructType\\GetComuni',
            'GetComuniResponse' => '\\Service\\StructType\\GetComuniResponse',
            'GetRecapiti' => '\\Service\\StructType\\GetRecapiti',
            'GetRecapitiResponse' => '\\Service\\StructType\\GetRecapitiResponse',
            'GetRecapito' => '\\Service\\StructType\\GetRecapito',
            'GetRecapitoResponse' => '\\Service\\StructType\\GetRecapitoResponse',
            'SalvaRecapito' => '\\Service\\StructType\\SalvaRecapito',
            'SalvaRecapitoResponse' => '\\Service\\StructType\\SalvaRecapitoResponse',
            'DeleteRecapito' => '\\Service\\StructType\\DeleteRecapito',
            'DeleteRecapitoResponse' => '\\Service\\StructType\\DeleteRecapitoResponse',
            'GetQualifiche' => '\\Service\\StructType\\GetQualifiche',
            'GetQualificheResponse' => '\\Service\\StructType\\GetQualificheResponse',
            'SendRecapiti' => '\\Service\\StructType\\SendRecapiti',
            'SendRecapitiResponse' => '\\Service\\StructType\\SendRecapitiResponse',
            'GetCorsi' => '\\Service\\StructType\\GetCorsi',
            'GetCorsiResponse' => '\\Service\\StructType\\GetCorsiResponse',
            'GetCorsiUtente' => '\\Service\\StructType\\GetCorsiUtente',
            'GetCorsiUtenteResponse' => '\\Service\\StructType\\GetCorsiUtenteResponse',
            'CancellaIscrizioneACorso' => '\\Service\\StructType\\CancellaIscrizioneACorso',
            'CancellaIscrizioneACorsoResponse' => '\\Service\\StructType\\CancellaIscrizioneACorsoResponse',
            'SendCorsoRegistrazione' => '\\Service\\StructType\\SendCorsoRegistrazione',
            'SendCorsoRegistrazioneResponse' => '\\Service\\StructType\\SendCorsoRegistrazioneResponse',
            'SendCorsoCancellaRegistrazione' => '\\Service\\StructType\\SendCorsoCancellaRegistrazione',
            'SendCorsoCancellaRegistrazioneResponse' => '\\Service\\StructType\\SendCorsoCancellaRegistrazioneResponse',
            'GetTurni' => '\\Service\\StructType\\GetTurni',
            'GetTurniResponse' => '\\Service\\StructType\\GetTurniResponse',
            'GetTurniOperatore' => '\\Service\\StructType\\GetTurniOperatore',
            'GetTurniOperatoreResponse' => '\\Service\\StructType\\GetTurniOperatoreResponse',
            'GetEventiOperatore' => '\\Service\\StructType\\GetEventiOperatore',
            'GetEventiOperatoreResponse' => '\\Service\\StructType\\GetEventiOperatoreResponse',
            'GetCalendarioTurni' => '\\Service\\StructType\\GetCalendarioTurni',
            'GetCalendarioTurniResponse' => '\\Service\\StructType\\GetCalendarioTurniResponse',
            'GetCalendarioTurniLite' => '\\Service\\StructType\\GetCalendarioTurniLite',
            'GetCalendarioTurniLiteResponse' => '\\Service\\StructType\\GetCalendarioTurniLiteResponse',
            'GetEventi' => '\\Service\\StructType\\GetEventi',
            'GetEventiResponse' => '\\Service\\StructType\\GetEventiResponse',
            'GetCalendarioEventi' => '\\Service\\StructType\\GetCalendarioEventi',
            'GetCalendarioEventiResponse' => '\\Service\\StructType\\GetCalendarioEventiResponse',
            'GetTurnoSpecifico' => '\\Service\\StructType\\GetTurnoSpecifico',
            'GetTurnoSpecificoResponse' => '\\Service\\StructType\\GetTurnoSpecificoResponse',
            'GetTurnoSpecifico2' => '\\Service\\StructType\\GetTurnoSpecifico2',
            'GetTurnoSpecifico2Response' => '\\Service\\StructType\\GetTurnoSpecifico2Response',
            'GetGiornoEvento' => '\\Service\\StructType\\GetGiornoEvento',
            'GetGiornoEventoResponse' => '\\Service\\StructType\\GetGiornoEventoResponse',
            'IscrizioneTurno' => '\\Service\\StructType\\IscrizioneTurno',
            'IscrizioneTurnoResponse' => '\\Service\\StructType\\IscrizioneTurnoResponse',
            'IscrizioneTurno2' => '\\Service\\StructType\\IscrizioneTurno2',
            'IscrizioneTurno2Response' => '\\Service\\StructType\\IscrizioneTurno2Response',
            'ModificaIscrizioneTurno' => '\\Service\\StructType\\ModificaIscrizioneTurno',
            'ModificaIscrizioneTurnoResponse' => '\\Service\\StructType\\ModificaIscrizioneTurnoResponse',
            'ModificaIscrizioneTurno2' => '\\Service\\StructType\\ModificaIscrizioneTurno2',
            'ModificaIscrizioneTurno2Response' => '\\Service\\StructType\\ModificaIscrizioneTurno2Response',
            'IscrizioneEvento' => '\\Service\\StructType\\IscrizioneEvento',
            'IscrizioneEventoResponse' => '\\Service\\StructType\\IscrizioneEventoResponse',
            'CancellazioneIscrizioneTurno' => '\\Service\\StructType\\CancellazioneIscrizioneTurno',
            'CancellazioneIscrizioneTurnoResponse' => '\\Service\\StructType\\CancellazioneIscrizioneTurnoResponse',
            'CancellazioneIscrizioneTurno2' => '\\Service\\StructType\\CancellazioneIscrizioneTurno2',
            'CancellazioneIscrizioneTurno2Response' => '\\Service\\StructType\\CancellazioneIscrizioneTurno2Response',
            'CancellazioneIscrizioneEvento' => '\\Service\\StructType\\CancellazioneIscrizioneEvento',
            'CancellazioneIscrizioneEventoResponse' => '\\Service\\StructType\\CancellazioneIscrizioneEventoResponse',
            'GetAttivitaUtente' => '\\Service\\StructType\\GetAttivitaUtente',
            'GetAttivitaUtenteResponse' => '\\Service\\StructType\\GetAttivitaUtenteResponse',
            'GetMessaggi' => '\\Service\\StructType\\GetMessaggi',
            'GetMessaggiResponse' => '\\Service\\StructType\\GetMessaggiResponse',
            'GetLastPresenza' => '\\Service\\StructType\\GetLastPresenza',
            'GetLastPresenzaResponse' => '\\Service\\StructType\\GetLastPresenzaResponse',
            'GetLastPresenza2' => '\\Service\\StructType\\GetLastPresenza2',
            'GetLastPresenza2Response' => '\\Service\\StructType\\GetLastPresenza2Response',
            'GetNotifiche' => '\\Service\\StructType\\GetNotifiche',
            'GetNotificheResponse' => '\\Service\\StructType\\GetNotificheResponse',
            'GetTestoNotifica' => '\\Service\\StructType\\GetTestoNotifica',
            'GetTestoNotificaResponse' => '\\Service\\StructType\\GetTestoNotificaResponse',
            'GetTotaleNotificheDaNotificare' => '\\Service\\StructType\\GetTotaleNotificheDaNotificare',
            'GetTotaleNotificheDaNotificareResponse' => '\\Service\\StructType\\GetTotaleNotificheDaNotificareResponse',
            'SetNotificaLetta' => '\\Service\\StructType\\SetNotificaLetta',
            'SetNotificaLettaResponse' => '\\Service\\StructType\\SetNotificaLettaResponse',
            'SetNotificheNotificate' => '\\Service\\StructType\\SetNotificheNotificate',
            'SetNotificheNotificateResponse' => '\\Service\\StructType\\SetNotificheNotificateResponse',
            'RicercaAnagrafe' => '\\Service\\StructType\\RicercaAnagrafe',
            'RicercaAnagrafeResponse' => '\\Service\\StructType\\RicercaAnagrafeResponse',
            'GetAnagrafe' => '\\Service\\StructType\\GetAnagrafe',
            'GetAnagrafeResponse' => '\\Service\\StructType\\GetAnagrafeResponse',
            'SalvaAnagrafe' => '\\Service\\StructType\\SalvaAnagrafe',
            'SalvaAnagrafeResponse' => '\\Service\\StructType\\SalvaAnagrafeResponse',
            'IncassaQuotaAssociativa' => '\\Service\\StructType\\IncassaQuotaAssociativa',
            'IncassaQuotaAssociativaResponse' => '\\Service\\StructType\\IncassaQuotaAssociativaResponse',
            'AnnullaIncassoQuotaAssociativa' => '\\Service\\StructType\\AnnullaIncassoQuotaAssociativa',
            'AnnullaIncassoQuotaAssociativaResponse' => '\\Service\\StructType\\AnnullaIncassoQuotaAssociativaResponse',
            'StampaModuloPrivacy' => '\\Service\\StructType\\StampaModuloPrivacy',
            'StampaModuloPrivacyResponse' => '\\Service\\StructType\\StampaModuloPrivacyResponse',
            'RinnovaPrivacy' => '\\Service\\StructType\\RinnovaPrivacy',
            'RinnovaPrivacyResponse' => '\\Service\\StructType\\RinnovaPrivacyResponse',
            'RevocaPrivacy' => '\\Service\\StructType\\RevocaPrivacy',
            'RevocaPrivacyResponse' => '\\Service\\StructType\\RevocaPrivacyResponse',
            'GetCsvSociConRecapito' => '\\Service\\StructType\\GetCsvSociConRecapito',
            'GetCsvSociConRecapitoResponse' => '\\Service\\StructType\\GetCsvSociConRecapitoResponse',
            'GetCsvSituazionePrivacy' => '\\Service\\StructType\\GetCsvSituazionePrivacy',
            'GetCsvSituazionePrivacyResponse' => '\\Service\\StructType\\GetCsvSituazionePrivacyResponse',
            'GetCsvCampagnaSoci' => '\\Service\\StructType\\GetCsvCampagnaSoci',
            'GetCsvCampagnaSociResponse' => '\\Service\\StructType\\GetCsvCampagnaSociResponse',
            'GetListaSegnalazioniGuasto' => '\\Service\\StructType\\GetListaSegnalazioniGuasto',
            'GetListaSegnalazioniGuastoResponse' => '\\Service\\StructType\\GetListaSegnalazioniGuastoResponse',
            'GetListaArticoliSegnalazioneGuasto' => '\\Service\\StructType\\GetListaArticoliSegnalazioneGuasto',
            'GetListaArticoliSegnalazioneGuastoResponse' => '\\Service\\StructType\\GetListaArticoliSegnalazioneGuastoResponse',
            'SendSegnalazioneGuasto' => '\\Service\\StructType\\SendSegnalazioneGuasto',
            'SendSegnalazioneGuastoResponse' => '\\Service\\StructType\\SendSegnalazioneGuastoResponse',
            'RiassegnaMezzoMissioni' => '\\Service\\StructType\\RiassegnaMezzoMissioni',
            'RiassegnaMezzoMissioniResponse' => '\\Service\\StructType\\RiassegnaMezzoMissioniResponse',
            'InsertRichiestaCartellino' => '\\Service\\StructType\\InsertRichiestaCartellino',
            'InsertRichiestaCartellinoResponse' => '\\Service\\StructType\\InsertRichiestaCartellinoResponse',
            'UpdateRichiestaCartellino' => '\\Service\\StructType\\UpdateRichiestaCartellino',
            'UpdateRichiestaCartellinoResponse' => '\\Service\\StructType\\UpdateRichiestaCartellinoResponse',
            'GetRichiesteCartellino' => '\\Service\\StructType\\GetRichiesteCartellino',
            'GetRichiesteCartellinoResponse' => '\\Service\\StructType\\GetRichiesteCartellinoResponse',
            'GetRichiestaCartellino' => '\\Service\\StructType\\GetRichiestaCartellino',
            'GetRichiestaCartellinoResponse' => '\\Service\\StructType\\GetRichiestaCartellinoResponse',
            'DeleteRichiestaCartellino' => '\\Service\\StructType\\DeleteRichiestaCartellino',
            'DeleteRichiestaCartellinoResponse' => '\\Service\\StructType\\DeleteRichiestaCartellinoResponse',
            'InsertEventolRichiestaCartellino' => '\\Service\\StructType\\InsertEventolRichiestaCartellino',
            'InsertEventolRichiestaCartellinoResponse' => '\\Service\\StructType\\InsertEventolRichiestaCartellinoResponse',
            'GetListaRuoliOperatori' => '\\Service\\StructType\\GetListaRuoliOperatori',
            'GetListaRuoliOperatoriResponse' => '\\Service\\StructType\\GetListaRuoliOperatoriResponse',
            'GetListaStradari' => '\\Service\\StructType\\GetListaStradari',
            'GetListaStradariResponse' => '\\Service\\StructType\\GetListaStradariResponse',
            'CheckGreenPass' => '\\Service\\StructType\\CheckGreenPass',
        );
    }
}
