<?php

namespace Service\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Turno StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Turno
 * @subpackage Structs
 */
class Turno extends AbstractStructBase
{
    /**
     * The AbilitaInserimentoOrario
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $AbilitaInserimentoOrario;
    /**
     * The Annotazioni
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Annotazioni;
    /**
     * The Attivita
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Service\ArrayType\ArrayOfTAttivita
     */
    public $Attivita;
    /**
     * The Cancellabile
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Cancellabile;
    /**
     * The CancellabileOre
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CancellabileOre;
    /**
     * The ConsentiSoloAttivitaRichieste
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ConsentiSoloAttivitaRichieste;
    /**
     * The Descrizione
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Descrizione;
    /**
     * The Etichetta
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Etichetta;
    /**
     * The EvidenziaMinorenni
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $EvidenziaMinorenni;
    /**
     * The EvidenziaResponsabili
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $EvidenziaResponsabili;
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ID;
    /**
     * The IDTestata
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IDTestata;
    /**
     * The Mezzo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Service\StructType\Mezzo
     */
    public $Mezzo;
    /**
     * The MostraEtichette
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $MostraEtichette;
    /**
     * The MostraQualificheOperatore
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $MostraQualificheOperatore;
    /**
     * The NumMaxPersonale
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NumMaxPersonale;
    /**
     * The NumMinPersonale
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NumMinPersonale;
    /**
     * The OraFineTurno
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OraFineTurno;
    /**
     * The OraInizioTurno
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OraInizioTurno;
    /**
     * The Qualifiche
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Service\ArrayType\ArrayOfTurno_Qualifica
     */
    public $Qualifiche;
    /**
     * The StatoOperativo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $StatoOperativo;
    /**
     * Constructor method for Turno
     * @uses Turno::setAbilitaInserimentoOrario()
     * @uses Turno::setAnnotazioni()
     * @uses Turno::setAttivita()
     * @uses Turno::setCancellabile()
     * @uses Turno::setCancellabileOre()
     * @uses Turno::setConsentiSoloAttivitaRichieste()
     * @uses Turno::setDescrizione()
     * @uses Turno::setEtichetta()
     * @uses Turno::setEvidenziaMinorenni()
     * @uses Turno::setEvidenziaResponsabili()
     * @uses Turno::setID()
     * @uses Turno::setIDTestata()
     * @uses Turno::setMezzo()
     * @uses Turno::setMostraEtichette()
     * @uses Turno::setMostraQualificheOperatore()
     * @uses Turno::setNumMaxPersonale()
     * @uses Turno::setNumMinPersonale()
     * @uses Turno::setOraFineTurno()
     * @uses Turno::setOraInizioTurno()
     * @uses Turno::setQualifiche()
     * @uses Turno::setStatoOperativo()
     * @param bool $abilitaInserimentoOrario
     * @param string $annotazioni
     * @param \Service\ArrayType\ArrayOfTAttivita $attivita
     * @param bool $cancellabile
     * @param int $cancellabileOre
     * @param bool $consentiSoloAttivitaRichieste
     * @param string $descrizione
     * @param string $etichetta
     * @param bool $evidenziaMinorenni
     * @param bool $evidenziaResponsabili
     * @param int $iD
     * @param int $iDTestata
     * @param \Service\StructType\Mezzo $mezzo
     * @param bool $mostraEtichette
     * @param bool $mostraQualificheOperatore
     * @param int $numMaxPersonale
     * @param int $numMinPersonale
     * @param string $oraFineTurno
     * @param string $oraInizioTurno
     * @param \Service\ArrayType\ArrayOfTurno_Qualifica $qualifiche
     * @param string $statoOperativo
     */
    public function __construct($abilitaInserimentoOrario = null, $annotazioni = null, \Service\ArrayType\ArrayOfTAttivita $attivita = null, $cancellabile = null, $cancellabileOre = null, $consentiSoloAttivitaRichieste = null, $descrizione = null, $etichetta = null, $evidenziaMinorenni = null, $evidenziaResponsabili = null, $iD = null, $iDTestata = null, \Service\StructType\Mezzo $mezzo = null, $mostraEtichette = null, $mostraQualificheOperatore = null, $numMaxPersonale = null, $numMinPersonale = null, $oraFineTurno = null, $oraInizioTurno = null, \Service\ArrayType\ArrayOfTurno_Qualifica $qualifiche = null, $statoOperativo = null)
    {
        $this
            ->setAbilitaInserimentoOrario($abilitaInserimentoOrario)
            ->setAnnotazioni($annotazioni)
            ->setAttivita($attivita)
            ->setCancellabile($cancellabile)
            ->setCancellabileOre($cancellabileOre)
            ->setConsentiSoloAttivitaRichieste($consentiSoloAttivitaRichieste)
            ->setDescrizione($descrizione)
            ->setEtichetta($etichetta)
            ->setEvidenziaMinorenni($evidenziaMinorenni)
            ->setEvidenziaResponsabili($evidenziaResponsabili)
            ->setID($iD)
            ->setIDTestata($iDTestata)
            ->setMezzo($mezzo)
            ->setMostraEtichette($mostraEtichette)
            ->setMostraQualificheOperatore($mostraQualificheOperatore)
            ->setNumMaxPersonale($numMaxPersonale)
            ->setNumMinPersonale($numMinPersonale)
            ->setOraFineTurno($oraFineTurno)
            ->setOraInizioTurno($oraInizioTurno)
            ->setQualifiche($qualifiche)
            ->setStatoOperativo($statoOperativo);
    }
    /**
     * Get AbilitaInserimentoOrario value
     * @return bool|null
     */
    public function getAbilitaInserimentoOrario()
    {
        return $this->AbilitaInserimentoOrario;
    }
    /**
     * Set AbilitaInserimentoOrario value
     * @param bool $abilitaInserimentoOrario
     * @return \Service\StructType\Turno
     */
    public function setAbilitaInserimentoOrario($abilitaInserimentoOrario = null)
    {
        // validation for constraint: boolean
        if (!is_null($abilitaInserimentoOrario) && !is_bool($abilitaInserimentoOrario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($abilitaInserimentoOrario, true), gettype($abilitaInserimentoOrario)), __LINE__);
        }
        $this->AbilitaInserimentoOrario = $abilitaInserimentoOrario;
        return $this;
    }
    /**
     * Get Annotazioni value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAnnotazioni()
    {
        return isset($this->Annotazioni) ? $this->Annotazioni : null;
    }
    /**
     * Set Annotazioni value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $annotazioni
     * @return \Service\StructType\Turno
     */
    public function setAnnotazioni($annotazioni = null)
    {
        // validation for constraint: string
        if (!is_null($annotazioni) && !is_string($annotazioni)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($annotazioni, true), gettype($annotazioni)), __LINE__);
        }
        if (is_null($annotazioni) || (is_array($annotazioni) && empty($annotazioni))) {
            unset($this->Annotazioni);
        } else {
            $this->Annotazioni = $annotazioni;
        }
        return $this;
    }
    /**
     * Get Attivita value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Service\ArrayType\ArrayOfTAttivita|null
     */
    public function getAttivita()
    {
        return isset($this->Attivita) ? $this->Attivita : null;
    }
    /**
     * Set Attivita value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Service\ArrayType\ArrayOfTAttivita $attivita
     * @return \Service\StructType\Turno
     */
    public function setAttivita(\Service\ArrayType\ArrayOfTAttivita $attivita = null)
    {
        if (is_null($attivita) || (is_array($attivita) && empty($attivita))) {
            unset($this->Attivita);
        } else {
            $this->Attivita = $attivita;
        }
        return $this;
    }
    /**
     * Get Cancellabile value
     * @return bool|null
     */
    public function getCancellabile()
    {
        return $this->Cancellabile;
    }
    /**
     * Set Cancellabile value
     * @param bool $cancellabile
     * @return \Service\StructType\Turno
     */
    public function setCancellabile($cancellabile = null)
    {
        // validation for constraint: boolean
        if (!is_null($cancellabile) && !is_bool($cancellabile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($cancellabile, true), gettype($cancellabile)), __LINE__);
        }
        $this->Cancellabile = $cancellabile;
        return $this;
    }
    /**
     * Get CancellabileOre value
     * @return int|null
     */
    public function getCancellabileOre()
    {
        return $this->CancellabileOre;
    }
    /**
     * Set CancellabileOre value
     * @param int $cancellabileOre
     * @return \Service\StructType\Turno
     */
    public function setCancellabileOre($cancellabileOre = null)
    {
        // validation for constraint: int
        if (!is_null($cancellabileOre) && !(is_int($cancellabileOre) || ctype_digit($cancellabileOre))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cancellabileOre, true), gettype($cancellabileOre)), __LINE__);
        }
        $this->CancellabileOre = $cancellabileOre;
        return $this;
    }
    /**
     * Get ConsentiSoloAttivitaRichieste value
     * @return bool|null
     */
    public function getConsentiSoloAttivitaRichieste()
    {
        return $this->ConsentiSoloAttivitaRichieste;
    }
    /**
     * Set ConsentiSoloAttivitaRichieste value
     * @param bool $consentiSoloAttivitaRichieste
     * @return \Service\StructType\Turno
     */
    public function setConsentiSoloAttivitaRichieste($consentiSoloAttivitaRichieste = null)
    {
        // validation for constraint: boolean
        if (!is_null($consentiSoloAttivitaRichieste) && !is_bool($consentiSoloAttivitaRichieste)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($consentiSoloAttivitaRichieste, true), gettype($consentiSoloAttivitaRichieste)), __LINE__);
        }
        $this->ConsentiSoloAttivitaRichieste = $consentiSoloAttivitaRichieste;
        return $this;
    }
    /**
     * Get Descrizione value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescrizione()
    {
        return isset($this->Descrizione) ? $this->Descrizione : null;
    }
    /**
     * Set Descrizione value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $descrizione
     * @return \Service\StructType\Turno
     */
    public function setDescrizione($descrizione = null)
    {
        // validation for constraint: string
        if (!is_null($descrizione) && !is_string($descrizione)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descrizione, true), gettype($descrizione)), __LINE__);
        }
        if (is_null($descrizione) || (is_array($descrizione) && empty($descrizione))) {
            unset($this->Descrizione);
        } else {
            $this->Descrizione = $descrizione;
        }
        return $this;
    }
    /**
     * Get Etichetta value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEtichetta()
    {
        return isset($this->Etichetta) ? $this->Etichetta : null;
    }
    /**
     * Set Etichetta value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $etichetta
     * @return \Service\StructType\Turno
     */
    public function setEtichetta($etichetta = null)
    {
        // validation for constraint: string
        if (!is_null($etichetta) && !is_string($etichetta)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($etichetta, true), gettype($etichetta)), __LINE__);
        }
        if (is_null($etichetta) || (is_array($etichetta) && empty($etichetta))) {
            unset($this->Etichetta);
        } else {
            $this->Etichetta = $etichetta;
        }
        return $this;
    }
    /**
     * Get EvidenziaMinorenni value
     * @return bool|null
     */
    public function getEvidenziaMinorenni()
    {
        return $this->EvidenziaMinorenni;
    }
    /**
     * Set EvidenziaMinorenni value
     * @param bool $evidenziaMinorenni
     * @return \Service\StructType\Turno
     */
    public function setEvidenziaMinorenni($evidenziaMinorenni = null)
    {
        // validation for constraint: boolean
        if (!is_null($evidenziaMinorenni) && !is_bool($evidenziaMinorenni)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($evidenziaMinorenni, true), gettype($evidenziaMinorenni)), __LINE__);
        }
        $this->EvidenziaMinorenni = $evidenziaMinorenni;
        return $this;
    }
    /**
     * Get EvidenziaResponsabili value
     * @return bool|null
     */
    public function getEvidenziaResponsabili()
    {
        return $this->EvidenziaResponsabili;
    }
    /**
     * Set EvidenziaResponsabili value
     * @param bool $evidenziaResponsabili
     * @return \Service\StructType\Turno
     */
    public function setEvidenziaResponsabili($evidenziaResponsabili = null)
    {
        // validation for constraint: boolean
        if (!is_null($evidenziaResponsabili) && !is_bool($evidenziaResponsabili)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($evidenziaResponsabili, true), gettype($evidenziaResponsabili)), __LINE__);
        }
        $this->EvidenziaResponsabili = $evidenziaResponsabili;
        return $this;
    }
    /**
     * Get ID value
     * @return int|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \Service\StructType\Turno
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !(is_int($iD) || ctype_digit($iD))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get IDTestata value
     * @return int|null
     */
    public function getIDTestata()
    {
        return $this->IDTestata;
    }
    /**
     * Set IDTestata value
     * @param int $iDTestata
     * @return \Service\StructType\Turno
     */
    public function setIDTestata($iDTestata = null)
    {
        // validation for constraint: int
        if (!is_null($iDTestata) && !(is_int($iDTestata) || ctype_digit($iDTestata))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iDTestata, true), gettype($iDTestata)), __LINE__);
        }
        $this->IDTestata = $iDTestata;
        return $this;
    }
    /**
     * Get Mezzo value
     * @return \Service\StructType\Mezzo|null
     */
    public function getMezzo()
    {
        return $this->Mezzo;
    }
    /**
     * Set Mezzo value
     * @param \Service\StructType\Mezzo $mezzo
     * @return \Service\StructType\Turno
     */
    public function setMezzo(\Service\StructType\Mezzo $mezzo = null)
    {
        $this->Mezzo = $mezzo;
        return $this;
    }
    /**
     * Get MostraEtichette value
     * @return bool|null
     */
    public function getMostraEtichette()
    {
        return $this->MostraEtichette;
    }
    /**
     * Set MostraEtichette value
     * @param bool $mostraEtichette
     * @return \Service\StructType\Turno
     */
    public function setMostraEtichette($mostraEtichette = null)
    {
        // validation for constraint: boolean
        if (!is_null($mostraEtichette) && !is_bool($mostraEtichette)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($mostraEtichette, true), gettype($mostraEtichette)), __LINE__);
        }
        $this->MostraEtichette = $mostraEtichette;
        return $this;
    }
    /**
     * Get MostraQualificheOperatore value
     * @return bool|null
     */
    public function getMostraQualificheOperatore()
    {
        return $this->MostraQualificheOperatore;
    }
    /**
     * Set MostraQualificheOperatore value
     * @param bool $mostraQualificheOperatore
     * @return \Service\StructType\Turno
     */
    public function setMostraQualificheOperatore($mostraQualificheOperatore = null)
    {
        // validation for constraint: boolean
        if (!is_null($mostraQualificheOperatore) && !is_bool($mostraQualificheOperatore)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($mostraQualificheOperatore, true), gettype($mostraQualificheOperatore)), __LINE__);
        }
        $this->MostraQualificheOperatore = $mostraQualificheOperatore;
        return $this;
    }
    /**
     * Get NumMaxPersonale value
     * @return int|null
     */
    public function getNumMaxPersonale()
    {
        return $this->NumMaxPersonale;
    }
    /**
     * Set NumMaxPersonale value
     * @param int $numMaxPersonale
     * @return \Service\StructType\Turno
     */
    public function setNumMaxPersonale($numMaxPersonale = null)
    {
        // validation for constraint: int
        if (!is_null($numMaxPersonale) && !(is_int($numMaxPersonale) || ctype_digit($numMaxPersonale))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numMaxPersonale, true), gettype($numMaxPersonale)), __LINE__);
        }
        $this->NumMaxPersonale = $numMaxPersonale;
        return $this;
    }
    /**
     * Get NumMinPersonale value
     * @return int|null
     */
    public function getNumMinPersonale()
    {
        return $this->NumMinPersonale;
    }
    /**
     * Set NumMinPersonale value
     * @param int $numMinPersonale
     * @return \Service\StructType\Turno
     */
    public function setNumMinPersonale($numMinPersonale = null)
    {
        // validation for constraint: int
        if (!is_null($numMinPersonale) && !(is_int($numMinPersonale) || ctype_digit($numMinPersonale))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numMinPersonale, true), gettype($numMinPersonale)), __LINE__);
        }
        $this->NumMinPersonale = $numMinPersonale;
        return $this;
    }
    /**
     * Get OraFineTurno value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOraFineTurno()
    {
        return isset($this->OraFineTurno) ? $this->OraFineTurno : null;
    }
    /**
     * Set OraFineTurno value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $oraFineTurno
     * @return \Service\StructType\Turno
     */
    public function setOraFineTurno($oraFineTurno = null)
    {
        // validation for constraint: string
        if (!is_null($oraFineTurno) && !is_string($oraFineTurno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oraFineTurno, true), gettype($oraFineTurno)), __LINE__);
        }
        if (is_null($oraFineTurno) || (is_array($oraFineTurno) && empty($oraFineTurno))) {
            unset($this->OraFineTurno);
        } else {
            $this->OraFineTurno = $oraFineTurno;
        }
        return $this;
    }
    /**
     * Get OraInizioTurno value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOraInizioTurno()
    {
        return isset($this->OraInizioTurno) ? $this->OraInizioTurno : null;
    }
    /**
     * Set OraInizioTurno value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $oraInizioTurno
     * @return \Service\StructType\Turno
     */
    public function setOraInizioTurno($oraInizioTurno = null)
    {
        // validation for constraint: string
        if (!is_null($oraInizioTurno) && !is_string($oraInizioTurno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oraInizioTurno, true), gettype($oraInizioTurno)), __LINE__);
        }
        if (is_null($oraInizioTurno) || (is_array($oraInizioTurno) && empty($oraInizioTurno))) {
            unset($this->OraInizioTurno);
        } else {
            $this->OraInizioTurno = $oraInizioTurno;
        }
        return $this;
    }
    /**
     * Get Qualifiche value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Service\ArrayType\ArrayOfTurno_Qualifica|null
     */
    public function getQualifiche()
    {
        return isset($this->Qualifiche) ? $this->Qualifiche : null;
    }
    /**
     * Set Qualifiche value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Service\ArrayType\ArrayOfTurno_Qualifica $qualifiche
     * @return \Service\StructType\Turno
     */
    public function setQualifiche(\Service\ArrayType\ArrayOfTurno_Qualifica $qualifiche = null)
    {
        if (is_null($qualifiche) || (is_array($qualifiche) && empty($qualifiche))) {
            unset($this->Qualifiche);
        } else {
            $this->Qualifiche = $qualifiche;
        }
        return $this;
    }
    /**
     * Get StatoOperativo value
     * @return string|null
     */
    public function getStatoOperativo()
    {
        return $this->StatoOperativo;
    }
    /**
     * Set StatoOperativo value
     * @uses \Service\EnumType\StatoOperativoTurno::valueIsValid()
     * @uses \Service\EnumType\StatoOperativoTurno::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $statoOperativo
     * @return \Service\StructType\Turno
     */
    public function setStatoOperativo($statoOperativo = null)
    {
        // validation for constraint: enumeration
        if (!\Service\EnumType\StatoOperativoTurno::valueIsValid($statoOperativo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Service\EnumType\StatoOperativoTurno', is_array($statoOperativo) ? implode(', ', $statoOperativo) : var_export($statoOperativo, true), implode(', ', \Service\EnumType\StatoOperativoTurno::getValidValues())), __LINE__);
        }
        $this->StatoOperativo = $statoOperativo;
        return $this;
    }
}
