<?php

namespace Service\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AnnullaIncassoQuotaAssociativa StructType
 * @subpackage Structs
 */
class AnnullaIncassoQuotaAssociativa extends AbstractStructBase
{
    /**
     * The IDProdotto
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $IDProdotto;
    /**
     * The IDAnagrafe
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IDAnagrafe;
    /**
     * Constructor method for AnnullaIncassoQuotaAssociativa
     * @uses AnnullaIncassoQuotaAssociativa::setIDProdotto()
     * @uses AnnullaIncassoQuotaAssociativa::setIDAnagrafe()
     * @param string $iDProdotto
     * @param int $iDAnagrafe
     */
    public function __construct($iDProdotto = null, $iDAnagrafe = null)
    {
        $this
            ->setIDProdotto($iDProdotto)
            ->setIDAnagrafe($iDAnagrafe);
    }
    /**
     * Get IDProdotto value
     * @return string|null
     */
    public function getIDProdotto()
    {
        return $this->IDProdotto;
    }
    /**
     * Set IDProdotto value
     * @uses \Service\EnumType\SoftwareClient::valueIsValid()
     * @uses \Service\EnumType\SoftwareClient::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $iDProdotto
     * @return \Service\StructType\AnnullaIncassoQuotaAssociativa
     */
    public function setIDProdotto($iDProdotto = null)
    {
        // validation for constraint: enumeration
        if (!\Service\EnumType\SoftwareClient::valueIsValid($iDProdotto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Service\EnumType\SoftwareClient', is_array($iDProdotto) ? implode(', ', $iDProdotto) : var_export($iDProdotto, true), implode(', ', \Service\EnumType\SoftwareClient::getValidValues())), __LINE__);
        }
        $this->IDProdotto = $iDProdotto;
        return $this;
    }
    /**
     * Get IDAnagrafe value
     * @return int|null
     */
    public function getIDAnagrafe()
    {
        return $this->IDAnagrafe;
    }
    /**
     * Set IDAnagrafe value
     * @param int $iDAnagrafe
     * @return \Service\StructType\AnnullaIncassoQuotaAssociativa
     */
    public function setIDAnagrafe($iDAnagrafe = null)
    {
        // validation for constraint: int
        if (!is_null($iDAnagrafe) && !(is_int($iDAnagrafe) || ctype_digit($iDAnagrafe))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iDAnagrafe, true), gettype($iDAnagrafe)), __LINE__);
        }
        $this->IDAnagrafe = $iDAnagrafe;
        return $this;
    }
}
