<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetProvince_Result StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetProvince_Result
 * @subpackage Structs
 */
class GetProvince_Result extends AbstractStructBase
{
    /**
     * The Informazioni
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AdditionaInformation
     */
    public $Informazioni;
    /**
     * The Province
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfResultCodiceDescrizione
     */
    public $Province;
    /**
     * Constructor method for GetProvince_Result
     * @uses GetProvince_Result::setInformazioni()
     * @uses GetProvince_Result::setProvince()
     * @param \StructType\AdditionaInformation $informazioni
     * @param \ArrayType\ArrayOfResultCodiceDescrizione $province
     */
    public function __construct(\StructType\AdditionaInformation $informazioni = null, \ArrayType\ArrayOfResultCodiceDescrizione $province = null)
    {
        $this
            ->setInformazioni($informazioni)
            ->setProvince($province);
    }
    /**
     * Get Informazioni value
     * @return \StructType\AdditionaInformation|null
     */
    public function getInformazioni()
    {
        return $this->Informazioni;
    }
    /**
     * Set Informazioni value
     * @param \StructType\AdditionaInformation $informazioni
     * @return \StructType\GetProvince_Result
     */
    public function setInformazioni(\StructType\AdditionaInformation $informazioni = null)
    {
        $this->Informazioni = $informazioni;
        return $this;
    }
    /**
     * Get Province value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfResultCodiceDescrizione|null
     */
    public function getProvince()
    {
        return isset($this->Province) ? $this->Province : null;
    }
    /**
     * Set Province value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfResultCodiceDescrizione $province
     * @return \StructType\GetProvince_Result
     */
    public function setProvince(\ArrayType\ArrayOfResultCodiceDescrizione $province = null)
    {
        if (is_null($province) || (is_array($province) && empty($province))) {
            unset($this->Province);
        } else {
            $this->Province = $province;
        }
        return $this;
    }
}
