<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CancellazioneIscrizioneEvento StructType
 * @subpackage Structs
 */
class CancellazioneIscrizioneEvento extends AbstractStructBase
{
    /**
     * The Esercizio
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Esercizio;
    /**
     * The Registro
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Registro;
    /**
     * The Numero
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Numero;
    /**
     * The NumeroRiga
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NumeroRiga;
    /**
     * The IDOperatore
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IDOperatore;
    /**
     * Constructor method for CancellazioneIscrizioneEvento
     * @uses CancellazioneIscrizioneEvento::setEsercizio()
     * @uses CancellazioneIscrizioneEvento::setRegistro()
     * @uses CancellazioneIscrizioneEvento::setNumero()
     * @uses CancellazioneIscrizioneEvento::setNumeroRiga()
     * @uses CancellazioneIscrizioneEvento::setIDOperatore()
     * @param string $esercizio
     * @param string $registro
     * @param int $numero
     * @param int $numeroRiga
     * @param int $iDOperatore
     */
    public function __construct($esercizio = null, $registro = null, $numero = null, $numeroRiga = null, $iDOperatore = null)
    {
        $this
            ->setEsercizio($esercizio)
            ->setRegistro($registro)
            ->setNumero($numero)
            ->setNumeroRiga($numeroRiga)
            ->setIDOperatore($iDOperatore);
    }
    /**
     * Get Esercizio value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEsercizio()
    {
        return isset($this->Esercizio) ? $this->Esercizio : null;
    }
    /**
     * Set Esercizio value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $esercizio
     * @return \StructType\CancellazioneIscrizioneEvento
     */
    public function setEsercizio($esercizio = null)
    {
        // validation for constraint: string
        if (!is_null($esercizio) && !is_string($esercizio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($esercizio, true), gettype($esercizio)), __LINE__);
        }
        if (is_null($esercizio) || (is_array($esercizio) && empty($esercizio))) {
            unset($this->Esercizio);
        } else {
            $this->Esercizio = $esercizio;
        }
        return $this;
    }
    /**
     * Get Registro value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRegistro()
    {
        return isset($this->Registro) ? $this->Registro : null;
    }
    /**
     * Set Registro value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $registro
     * @return \StructType\CancellazioneIscrizioneEvento
     */
    public function setRegistro($registro = null)
    {
        // validation for constraint: string
        if (!is_null($registro) && !is_string($registro)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($registro, true), gettype($registro)), __LINE__);
        }
        if (is_null($registro) || (is_array($registro) && empty($registro))) {
            unset($this->Registro);
        } else {
            $this->Registro = $registro;
        }
        return $this;
    }
    /**
     * Get Numero value
     * @return int|null
     */
    public function getNumero()
    {
        return $this->Numero;
    }
    /**
     * Set Numero value
     * @param int $numero
     * @return \StructType\CancellazioneIscrizioneEvento
     */
    public function setNumero($numero = null)
    {
        // validation for constraint: int
        if (!is_null($numero) && !(is_int($numero) || ctype_digit($numero))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numero, true), gettype($numero)), __LINE__);
        }
        $this->Numero = $numero;
        return $this;
    }
    /**
     * Get NumeroRiga value
     * @return int|null
     */
    public function getNumeroRiga()
    {
        return $this->NumeroRiga;
    }
    /**
     * Set NumeroRiga value
     * @param int $numeroRiga
     * @return \StructType\CancellazioneIscrizioneEvento
     */
    public function setNumeroRiga($numeroRiga = null)
    {
        // validation for constraint: int
        if (!is_null($numeroRiga) && !(is_int($numeroRiga) || ctype_digit($numeroRiga))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numeroRiga, true), gettype($numeroRiga)), __LINE__);
        }
        $this->NumeroRiga = $numeroRiga;
        return $this;
    }
    /**
     * Get IDOperatore value
     * @return int|null
     */
    public function getIDOperatore()
    {
        return $this->IDOperatore;
    }
    /**
     * Set IDOperatore value
     * @param int $iDOperatore
     * @return \StructType\CancellazioneIscrizioneEvento
     */
    public function setIDOperatore($iDOperatore = null)
    {
        // validation for constraint: int
        if (!is_null($iDOperatore) && !(is_int($iDOperatore) || ctype_digit($iDOperatore))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iDOperatore, true), gettype($iDOperatore)), __LINE__);
        }
        $this->IDOperatore = $iDOperatore;
        return $this;
    }
}
