<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Login ServiceType
 * @subpackage Services
 */
class Login extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Login
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Login $parameters
     * @return \StructType\LoginResponse|bool
     */
    public function Login(\StructType\Login $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Login($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Login_Tessera
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Login_Tessera $parameters
     * @return \StructType\Login_TesseraResponse|bool
     */
    public function Login_Tessera(\StructType\Login_Tessera $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Login_Tessera($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Login_EasyGAV_Web
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Login_EasyGAV_Web $parameters
     * @return \StructType\Login_EasyGAV_WebResponse|bool
     */
    public function Login_EasyGAV_Web(\StructType\Login_EasyGAV_Web $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Login_EasyGAV_Web($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Login_SGEServer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Login_SGEServer $parameters
     * @return \StructType\Login_SGEServerResponse|bool
     */
    public function Login_SGEServer(\StructType\Login_SGEServer $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Login_SGEServer($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\LoginResponse|\StructType\Login_EasyGAV_WebResponse|\StructType\Login_SGEServerResponse|\StructType\Login_TesseraResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
