<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StoxWebQuantityContract StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: q26:StoxWebQuantityContract
 * @subpackage Structs
 */
class StoxWebQuantityContract extends AbstractStructBase
{
    /**
     * The DeliveryDelay
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DeliveryDelay;
    /**
     * The Qty
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Qty;
    /**
     * Constructor method for StoxWebQuantityContract
     * @uses StoxWebQuantityContract::setDeliveryDelay()
     * @uses StoxWebQuantityContract::setQty()
     * @param string $deliveryDelay
     * @param float $qty
     */
    public function __construct($deliveryDelay = null, $qty = null)
    {
        $this
            ->setDeliveryDelay($deliveryDelay)
            ->setQty($qty);
    }
    /**
     * Get DeliveryDelay value
     * @return string|null
     */
    public function getDeliveryDelay()
    {
        return $this->DeliveryDelay;
    }
    /**
     * Set DeliveryDelay value
     * @uses \EnumType\DeliveryDelay::valueIsValid()
     * @uses \EnumType\DeliveryDelay::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $deliveryDelay
     * @return \StructType\StoxWebQuantityContract
     */
    public function setDeliveryDelay($deliveryDelay = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DeliveryDelay::valueIsValid($deliveryDelay)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $deliveryDelay, implode(', ', \EnumType\DeliveryDelay::getValidValues())), __LINE__);
        }
        $this->DeliveryDelay = $deliveryDelay;
        return $this;
    }
    /**
     * Get Qty value
     * @return float|null
     */
    public function getQty()
    {
        return $this->Qty;
    }
    /**
     * Set Qty value
     * @param float $qty
     * @return \StructType\StoxWebQuantityContract
     */
    public function setQty($qty = null)
    {
        $this->Qty = $qty;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StoxWebQuantityContract
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
