<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StoxWebCustomerContract StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: q6:StoxWebCustomerContract
 * @subpackage Structs
 */
class StoxWebCustomerContract extends AbstractStructBase
{
    /**
     * The SubCustomerNo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SubCustomerNo;
    /**
     * The SubCustomerLocation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SubCustomerLocation;
    /**
     * The SubCustomerStoxInternalAccountNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SubCustomerStoxInternalAccountNumber;
    /**
     * The SubCustomerStoxInternalCustomerId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SubCustomerStoxInternalCustomerId;
    /**
     * Constructor method for StoxWebCustomerContract
     * @uses StoxWebCustomerContract::setSubCustomerNo()
     * @uses StoxWebCustomerContract::setSubCustomerLocation()
     * @uses StoxWebCustomerContract::setSubCustomerStoxInternalAccountNumber()
     * @uses StoxWebCustomerContract::setSubCustomerStoxInternalCustomerId()
     * @param string $subCustomerNo
     * @param string $subCustomerLocation
     * @param string $subCustomerStoxInternalAccountNumber
     * @param int $subCustomerStoxInternalCustomerId
     */
    public function __construct($subCustomerNo = null, $subCustomerLocation = null, $subCustomerStoxInternalAccountNumber = null, $subCustomerStoxInternalCustomerId = null)
    {
        $this
            ->setSubCustomerNo($subCustomerNo)
            ->setSubCustomerLocation($subCustomerLocation)
            ->setSubCustomerStoxInternalAccountNumber($subCustomerStoxInternalAccountNumber)
            ->setSubCustomerStoxInternalCustomerId($subCustomerStoxInternalCustomerId);
    }
    /**
     * Get SubCustomerNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubCustomerNo()
    {
        return isset($this->SubCustomerNo) ? $this->SubCustomerNo : null;
    }
    /**
     * Set SubCustomerNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subCustomerNo
     * @return \StructType\StoxWebCustomerContract
     */
    public function setSubCustomerNo($subCustomerNo = null)
    {
        // validation for constraint: string
        if (!is_null($subCustomerNo) && !is_string($subCustomerNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subCustomerNo)), __LINE__);
        }
        if (is_null($subCustomerNo) || (is_array($subCustomerNo) && empty($subCustomerNo))) {
            unset($this->SubCustomerNo);
        } else {
            $this->SubCustomerNo = $subCustomerNo;
        }
        return $this;
    }
    /**
     * Get SubCustomerLocation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubCustomerLocation()
    {
        return isset($this->SubCustomerLocation) ? $this->SubCustomerLocation : null;
    }
    /**
     * Set SubCustomerLocation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subCustomerLocation
     * @return \StructType\StoxWebCustomerContract
     */
    public function setSubCustomerLocation($subCustomerLocation = null)
    {
        // validation for constraint: string
        if (!is_null($subCustomerLocation) && !is_string($subCustomerLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subCustomerLocation)), __LINE__);
        }
        if (is_null($subCustomerLocation) || (is_array($subCustomerLocation) && empty($subCustomerLocation))) {
            unset($this->SubCustomerLocation);
        } else {
            $this->SubCustomerLocation = $subCustomerLocation;
        }
        return $this;
    }
    /**
     * Get SubCustomerStoxInternalAccountNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubCustomerStoxInternalAccountNumber()
    {
        return isset($this->SubCustomerStoxInternalAccountNumber) ? $this->SubCustomerStoxInternalAccountNumber : null;
    }
    /**
     * Set SubCustomerStoxInternalAccountNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subCustomerStoxInternalAccountNumber
     * @return \StructType\StoxWebCustomerContract
     */
    public function setSubCustomerStoxInternalAccountNumber($subCustomerStoxInternalAccountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($subCustomerStoxInternalAccountNumber) && !is_string($subCustomerStoxInternalAccountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subCustomerStoxInternalAccountNumber)), __LINE__);
        }
        if (is_null($subCustomerStoxInternalAccountNumber) || (is_array($subCustomerStoxInternalAccountNumber) && empty($subCustomerStoxInternalAccountNumber))) {
            unset($this->SubCustomerStoxInternalAccountNumber);
        } else {
            $this->SubCustomerStoxInternalAccountNumber = $subCustomerStoxInternalAccountNumber;
        }
        return $this;
    }
    /**
     * Get SubCustomerStoxInternalCustomerId value
     * @return int|null
     */
    public function getSubCustomerStoxInternalCustomerId()
    {
        return $this->SubCustomerStoxInternalCustomerId;
    }
    /**
     * Set SubCustomerStoxInternalCustomerId value
     * @param int $subCustomerStoxInternalCustomerId
     * @return \StructType\StoxWebCustomerContract
     */
    public function setSubCustomerStoxInternalCustomerId($subCustomerStoxInternalCustomerId = null)
    {
        // validation for constraint: int
        if (!is_null($subCustomerStoxInternalCustomerId) && !is_numeric($subCustomerStoxInternalCustomerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($subCustomerStoxInternalCustomerId)), __LINE__);
        }
        $this->SubCustomerStoxInternalCustomerId = $subCustomerStoxInternalCustomerId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StoxWebCustomerContract
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
