<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductSearchCriteriaContract StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: q11:ProductSearchCriteriaContract
 * @subpackage Structs
 */
class ProductSearchCriteriaContract extends AbstractStructBase
{
    /**
     * The ProductId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ProductId;
    /**
     * The AnyBrand
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $AnyBrand;
    /**
     * The BrandId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $BrandId;
    /**
     * The BrandName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BrandName;
    /**
     * The EntireBrand
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $EntireBrand;
    /**
     * The ProductNo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProductNo;
    /**
     * The Width
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Width;
    /**
     * The Ratio
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Ratio;
    /**
     * The Diameter
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Diameter;
    /**
     * The Seasons
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Seasons;
    /**
     * The ProductTypes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ProductTypes;
    /**
     * The TGPCarTireId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TGPCarTireId;
    /**
     * Constructor method for ProductSearchCriteriaContract
     * @uses ProductSearchCriteriaContract::setProductId()
     * @uses ProductSearchCriteriaContract::setAnyBrand()
     * @uses ProductSearchCriteriaContract::setBrandId()
     * @uses ProductSearchCriteriaContract::setBrandName()
     * @uses ProductSearchCriteriaContract::setEntireBrand()
     * @uses ProductSearchCriteriaContract::setProductNo()
     * @uses ProductSearchCriteriaContract::setWidth()
     * @uses ProductSearchCriteriaContract::setRatio()
     * @uses ProductSearchCriteriaContract::setDiameter()
     * @uses ProductSearchCriteriaContract::setSeasons()
     * @uses ProductSearchCriteriaContract::setProductTypes()
     * @uses ProductSearchCriteriaContract::setTGPCarTireId()
     * @param int $productId
     * @param bool $anyBrand
     * @param int $brandId
     * @param string $brandName
     * @param bool $entireBrand
     * @param string $productNo
     * @param string $width
     * @param string $ratio
     * @param string $diameter
     * @param string $seasons
     * @param string $productTypes
     * @param int $tGPCarTireId
     */
    public function __construct($productId = null, $anyBrand = null, $brandId = null, $brandName = null, $entireBrand = null, $productNo = null, $width = null, $ratio = null, $diameter = null, $seasons = null, $productTypes = null, $tGPCarTireId = null)
    {
        $this
            ->setProductId($productId)
            ->setAnyBrand($anyBrand)
            ->setBrandId($brandId)
            ->setBrandName($brandName)
            ->setEntireBrand($entireBrand)
            ->setProductNo($productNo)
            ->setWidth($width)
            ->setRatio($ratio)
            ->setDiameter($diameter)
            ->setSeasons($seasons)
            ->setProductTypes($productTypes)
            ->setTGPCarTireId($tGPCarTireId);
    }
    /**
     * Get ProductId value
     * @return int|null
     */
    public function getProductId()
    {
        return $this->ProductId;
    }
    /**
     * Set ProductId value
     * @param int $productId
     * @return \StructType\ProductSearchCriteriaContract
     */
    public function setProductId($productId = null)
    {
        // validation for constraint: int
        if (!is_null($productId) && !is_numeric($productId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($productId)), __LINE__);
        }
        $this->ProductId = $productId;
        return $this;
    }
    /**
     * Get AnyBrand value
     * @return bool|null
     */
    public function getAnyBrand()
    {
        return $this->AnyBrand;
    }
    /**
     * Set AnyBrand value
     * @param bool $anyBrand
     * @return \StructType\ProductSearchCriteriaContract
     */
    public function setAnyBrand($anyBrand = null)
    {
        $this->AnyBrand = $anyBrand;
        return $this;
    }
    /**
     * Get BrandId value
     * @return int|null
     */
    public function getBrandId()
    {
        return $this->BrandId;
    }
    /**
     * Set BrandId value
     * @param int $brandId
     * @return \StructType\ProductSearchCriteriaContract
     */
    public function setBrandId($brandId = null)
    {
        // validation for constraint: int
        if (!is_null($brandId) && !is_numeric($brandId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($brandId)), __LINE__);
        }
        $this->BrandId = $brandId;
        return $this;
    }
    /**
     * Get BrandName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBrandName()
    {
        return isset($this->BrandName) ? $this->BrandName : null;
    }
    /**
     * Set BrandName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $brandName
     * @return \StructType\ProductSearchCriteriaContract
     */
    public function setBrandName($brandName = null)
    {
        // validation for constraint: string
        if (!is_null($brandName) && !is_string($brandName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($brandName)), __LINE__);
        }
        if (is_null($brandName) || (is_array($brandName) && empty($brandName))) {
            unset($this->BrandName);
        } else {
            $this->BrandName = $brandName;
        }
        return $this;
    }
    /**
     * Get EntireBrand value
     * @return bool|null
     */
    public function getEntireBrand()
    {
        return $this->EntireBrand;
    }
    /**
     * Set EntireBrand value
     * @param bool $entireBrand
     * @return \StructType\ProductSearchCriteriaContract
     */
    public function setEntireBrand($entireBrand = null)
    {
        $this->EntireBrand = $entireBrand;
        return $this;
    }
    /**
     * Get ProductNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProductNo()
    {
        return isset($this->ProductNo) ? $this->ProductNo : null;
    }
    /**
     * Set ProductNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $productNo
     * @return \StructType\ProductSearchCriteriaContract
     */
    public function setProductNo($productNo = null)
    {
        // validation for constraint: string
        if (!is_null($productNo) && !is_string($productNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productNo)), __LINE__);
        }
        if (is_null($productNo) || (is_array($productNo) && empty($productNo))) {
            unset($this->ProductNo);
        } else {
            $this->ProductNo = $productNo;
        }
        return $this;
    }
    /**
     * Get Width value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWidth()
    {
        return isset($this->Width) ? $this->Width : null;
    }
    /**
     * Set Width value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $width
     * @return \StructType\ProductSearchCriteriaContract
     */
    public function setWidth($width = null)
    {
        // validation for constraint: string
        if (!is_null($width) && !is_string($width)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($width)), __LINE__);
        }
        if (is_null($width) || (is_array($width) && empty($width))) {
            unset($this->Width);
        } else {
            $this->Width = $width;
        }
        return $this;
    }
    /**
     * Get Ratio value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRatio()
    {
        return isset($this->Ratio) ? $this->Ratio : null;
    }
    /**
     * Set Ratio value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ratio
     * @return \StructType\ProductSearchCriteriaContract
     */
    public function setRatio($ratio = null)
    {
        // validation for constraint: string
        if (!is_null($ratio) && !is_string($ratio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ratio)), __LINE__);
        }
        if (is_null($ratio) || (is_array($ratio) && empty($ratio))) {
            unset($this->Ratio);
        } else {
            $this->Ratio = $ratio;
        }
        return $this;
    }
    /**
     * Get Diameter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDiameter()
    {
        return isset($this->Diameter) ? $this->Diameter : null;
    }
    /**
     * Set Diameter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $diameter
     * @return \StructType\ProductSearchCriteriaContract
     */
    public function setDiameter($diameter = null)
    {
        // validation for constraint: string
        if (!is_null($diameter) && !is_string($diameter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($diameter)), __LINE__);
        }
        if (is_null($diameter) || (is_array($diameter) && empty($diameter))) {
            unset($this->Diameter);
        } else {
            $this->Diameter = $diameter;
        }
        return $this;
    }
    /**
     * Get Seasons value
     * @return string|null
     */
    public function getSeasons()
    {
        return $this->Seasons;
    }
    /**
     * Set Seasons value
     * @uses \EnumType\Season::valueIsValid()
     * @uses \EnumType\Season::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $seasons
     * @return \StructType\ProductSearchCriteriaContract
     */
    public function setSeasons($seasons = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Season::valueIsValid($seasons)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $seasons, implode(', ', \EnumType\Season::getValidValues())), __LINE__);
        }
        $this->Seasons = $seasons;
        return $this;
    }
    /**
     * Get ProductTypes value
     * @return string|null
     */
    public function getProductTypes()
    {
        return $this->ProductTypes;
    }
    /**
     * Set ProductTypes value
     * @uses \EnumType\ProductType::valueIsValid()
     * @uses \EnumType\ProductType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $productTypes
     * @return \StructType\ProductSearchCriteriaContract
     */
    public function setProductTypes($productTypes = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ProductType::valueIsValid($productTypes)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $productTypes, implode(', ', \EnumType\ProductType::getValidValues())), __LINE__);
        }
        $this->ProductTypes = $productTypes;
        return $this;
    }
    /**
     * Get TGPCarTireId value
     * @return int|null
     */
    public function getTGPCarTireId()
    {
        return $this->TGPCarTireId;
    }
    /**
     * Set TGPCarTireId value
     * @param int $tGPCarTireId
     * @return \StructType\ProductSearchCriteriaContract
     */
    public function setTGPCarTireId($tGPCarTireId = null)
    {
        // validation for constraint: int
        if (!is_null($tGPCarTireId) && !is_numeric($tGPCarTireId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($tGPCarTireId)), __LINE__);
        }
        $this->TGPCarTireId = $tGPCarTireId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProductSearchCriteriaContract
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
