<?php

namespace EnumType;

/**
 * This class stands for StoxWebErrorSubCategory EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:StoxWebErrorSubCategory
 * @subpackage Enumerations
 */
class StoxWebErrorSubCategory
{
    /**
     * Constant for value 'None'
     * @return string 'None'
     */
    const VALUE_NONE = 'None';
    /**
     * Constant for value 'Qty'
     * @return string 'Qty'
     */
    const VALUE_QTY = 'Qty';
    /**
     * Constant for value 'Customer'
     * @return string 'Customer'
     */
    const VALUE_CUSTOMER = 'Customer';
    /**
     * Constant for value 'BillToSubCustomer'
     * @return string 'BillToSubCustomer'
     */
    const VALUE_BILL_TO_SUB_CUSTOMER = 'BillToSubCustomer';
    /**
     * Constant for value 'ShipToSubCustomer'
     * @return string 'ShipToSubCustomer'
     */
    const VALUE_SHIP_TO_SUB_CUSTOMER = 'ShipToSubCustomer';
    /**
     * Constant for value 'Product'
     * @return string 'Product'
     */
    const VALUE_PRODUCT = 'Product';
    /**
     * Constant for value 'Brand'
     * @return string 'Brand'
     */
    const VALUE_BRAND = 'Brand';
    /**
     * Constant for value 'Credentials'
     * @return string 'Credentials'
     */
    const VALUE_CREDENTIALS = 'Credentials';
    /**
     * Constant for value 'Autorization'
     * @return string 'Autorization'
     */
    const VALUE_AUTORIZATION = 'Autorization';
    /**
     * Constant for value 'SearchParameters'
     * @return string 'SearchParameters'
     */
    const VALUE_SEARCH_PARAMETERS = 'SearchParameters';
    /**
     * Constant for value 'StorageCustomer'
     * @return string 'StorageCustomer'
     */
    const VALUE_STORAGE_CUSTOMER = 'StorageCustomer';
    /**
     * Constant for value 'StorageVehicle'
     * @return string 'StorageVehicle'
     */
    const VALUE_STORAGE_VEHICLE = 'StorageVehicle';
    /**
     * Constant for value 'StorageItem'
     * @return string 'StorageItem'
     */
    const VALUE_STORAGE_ITEM = 'StorageItem';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NONE
     * @uses self::VALUE_QTY
     * @uses self::VALUE_CUSTOMER
     * @uses self::VALUE_BILL_TO_SUB_CUSTOMER
     * @uses self::VALUE_SHIP_TO_SUB_CUSTOMER
     * @uses self::VALUE_PRODUCT
     * @uses self::VALUE_BRAND
     * @uses self::VALUE_CREDENTIALS
     * @uses self::VALUE_AUTORIZATION
     * @uses self::VALUE_SEARCH_PARAMETERS
     * @uses self::VALUE_STORAGE_CUSTOMER
     * @uses self::VALUE_STORAGE_VEHICLE
     * @uses self::VALUE_STORAGE_ITEM
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NONE,
            self::VALUE_QTY,
            self::VALUE_CUSTOMER,
            self::VALUE_BILL_TO_SUB_CUSTOMER,
            self::VALUE_SHIP_TO_SUB_CUSTOMER,
            self::VALUE_PRODUCT,
            self::VALUE_BRAND,
            self::VALUE_CREDENTIALS,
            self::VALUE_AUTORIZATION,
            self::VALUE_SEARCH_PARAMETERS,
            self::VALUE_STORAGE_CUSTOMER,
            self::VALUE_STORAGE_VEHICLE,
            self::VALUE_STORAGE_ITEM,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
