<?php

namespace EnumType;

/**
 * This class stands for StoxWebErrorCategory EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:StoxWebErrorCategory
 * @subpackage Enumerations
 */
class StoxWebErrorCategory
{
    /**
     * Constant for value 'General'
     * @return string 'General'
     */
    const VALUE_GENERAL = 'General';
    /**
     * Constant for value 'Authentication'
     * @return string 'Authentication'
     */
    const VALUE_AUTHENTICATION = 'Authentication';
    /**
     * Constant for value 'Autorization'
     * @return string 'Autorization'
     */
    const VALUE_AUTORIZATION = 'Autorization';
    /**
     * Constant for value 'Customer'
     * @return string 'Customer'
     */
    const VALUE_CUSTOMER = 'Customer';
    /**
     * Constant for value 'SubCustomer'
     * @return string 'SubCustomer'
     */
    const VALUE_SUB_CUSTOMER = 'SubCustomer';
    /**
     * Constant for value 'Product'
     * @return string 'Product'
     */
    const VALUE_PRODUCT = 'Product';
    /**
     * Constant for value 'Brand'
     * @return string 'Brand'
     */
    const VALUE_BRAND = 'Brand';
    /**
     * Constant for value 'Order'
     * @return string 'Order'
     */
    const VALUE_ORDER = 'Order';
    /**
     * Constant for value 'Location'
     * @return string 'Location'
     */
    const VALUE_LOCATION = 'Location';
    /**
     * Constant for value 'Invoice'
     * @return string 'Invoice'
     */
    const VALUE_INVOICE = 'Invoice';
    /**
     * Constant for value 'Storage'
     * @return string 'Storage'
     */
    const VALUE_STORAGE = 'Storage';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_GENERAL
     * @uses self::VALUE_AUTHENTICATION
     * @uses self::VALUE_AUTORIZATION
     * @uses self::VALUE_CUSTOMER
     * @uses self::VALUE_SUB_CUSTOMER
     * @uses self::VALUE_PRODUCT
     * @uses self::VALUE_BRAND
     * @uses self::VALUE_ORDER
     * @uses self::VALUE_LOCATION
     * @uses self::VALUE_INVOICE
     * @uses self::VALUE_STORAGE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_GENERAL,
            self::VALUE_AUTHENTICATION,
            self::VALUE_AUTORIZATION,
            self::VALUE_CUSTOMER,
            self::VALUE_SUB_CUSTOMER,
            self::VALUE_PRODUCT,
            self::VALUE_BRAND,
            self::VALUE_ORDER,
            self::VALUE_LOCATION,
            self::VALUE_INVOICE,
            self::VALUE_STORAGE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
