<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StoxWebProductQuantityContract StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: q65:StoxWebProductQuantityContract
 * @subpackage Structs
 */
class StoxWebProductQuantityContract extends AbstractStructBase
{
    /**
     * The Brand
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StoxWebBrandContract
     */
    public $Brand;
    /**
     * The ProductId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ProductId;
    /**
     * The ProductNo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProductNo;
    /**
     * The Quantities
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfStoxWebQuantityContract
     */
    public $Quantities;
    /**
     * Constructor method for StoxWebProductQuantityContract
     * @uses StoxWebProductQuantityContract::setBrand()
     * @uses StoxWebProductQuantityContract::setProductId()
     * @uses StoxWebProductQuantityContract::setProductNo()
     * @uses StoxWebProductQuantityContract::setQuantities()
     * @param \StructType\StoxWebBrandContract $brand
     * @param int $productId
     * @param string $productNo
     * @param \ArrayType\ArrayOfStoxWebQuantityContract $quantities
     */
    public function __construct(\StructType\StoxWebBrandContract $brand = null, $productId = null, $productNo = null, \ArrayType\ArrayOfStoxWebQuantityContract $quantities = null)
    {
        $this
            ->setBrand($brand)
            ->setProductId($productId)
            ->setProductNo($productNo)
            ->setQuantities($quantities);
    }
    /**
     * Get Brand value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StoxWebBrandContract|null
     */
    public function getBrand()
    {
        return isset($this->Brand) ? $this->Brand : null;
    }
    /**
     * Set Brand value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StoxWebBrandContract $brand
     * @return \StructType\StoxWebProductQuantityContract
     */
    public function setBrand(\StructType\StoxWebBrandContract $brand = null)
    {
        if (is_null($brand) || (is_array($brand) && empty($brand))) {
            unset($this->Brand);
        } else {
            $this->Brand = $brand;
        }
        return $this;
    }
    /**
     * Get ProductId value
     * @return int|null
     */
    public function getProductId()
    {
        return $this->ProductId;
    }
    /**
     * Set ProductId value
     * @param int $productId
     * @return \StructType\StoxWebProductQuantityContract
     */
    public function setProductId($productId = null)
    {
        // validation for constraint: int
        if (!is_null($productId) && !is_numeric($productId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($productId)), __LINE__);
        }
        $this->ProductId = $productId;
        return $this;
    }
    /**
     * Get ProductNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProductNo()
    {
        return isset($this->ProductNo) ? $this->ProductNo : null;
    }
    /**
     * Set ProductNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $productNo
     * @return \StructType\StoxWebProductQuantityContract
     */
    public function setProductNo($productNo = null)
    {
        // validation for constraint: string
        if (!is_null($productNo) && !is_string($productNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productNo)), __LINE__);
        }
        if (is_null($productNo) || (is_array($productNo) && empty($productNo))) {
            unset($this->ProductNo);
        } else {
            $this->ProductNo = $productNo;
        }
        return $this;
    }
    /**
     * Get Quantities value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfStoxWebQuantityContract|null
     */
    public function getQuantities()
    {
        return isset($this->Quantities) ? $this->Quantities : null;
    }
    /**
     * Set Quantities value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfStoxWebQuantityContract $quantities
     * @return \StructType\StoxWebProductQuantityContract
     */
    public function setQuantities(\ArrayType\ArrayOfStoxWebQuantityContract $quantities = null)
    {
        if (is_null($quantities) || (is_array($quantities) && empty($quantities))) {
            unset($this->Quantities);
        } else {
            $this->Quantities = $quantities;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StoxWebProductQuantityContract
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
