<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetProducts
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetProducts $parameters
     * @return \StructType\GetProductsResponse|bool
     */
    public function GetProducts(\StructType\GetProducts $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetProducts($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetBrands
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetBrands $parameters
     * @return \StructType\GetBrandsResponse|bool
     */
    public function GetBrands(\StructType\GetBrands $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetBrands($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetLocations
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetLocations $parameters
     * @return \StructType\GetLocationsResponse|bool
     */
    public function GetLocations(\StructType\GetLocations $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetLocations($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetProductQuantities
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetProductQuantities $parameters
     * @return \StructType\GetProductQuantitiesResponse|bool
     */
    public function GetProductQuantities(\StructType\GetProductQuantities $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetProductQuantities($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetProductDetailedQuantities
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetProductDetailedQuantities $parameters
     * @return \StructType\GetProductDetailedQuantitiesResponse|bool
     */
    public function GetProductDetailedQuantities(\StructType\GetProductDetailedQuantities $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetProductDetailedQuantities($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetBrandsResponse|\StructType\GetLocationsResponse|\StructType\GetProductDetailedQuantitiesResponse|\StructType\GetProductQuantitiesResponse|\StructType\GetProductsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
