<?php

namespace EnumType;

/**
 * This class stands for ProductType EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ProductType
 * @subpackage Enumerations
 */
class ProductType
{
    /**
     * Constant for value 'Any'
     * @return string 'Any'
     */
    const VALUE_ANY = 'Any';
    /**
     * Constant for value 'Tire'
     * @return string 'Tire'
     */
    const VALUE_TIRE = 'Tire';
    /**
     * Constant for value 'Wheel'
     * @return string 'Wheel'
     */
    const VALUE_WHEEL = 'Wheel';
    /**
     * Constant for value 'WheelCaps'
     * @return string 'WheelCaps'
     */
    const VALUE_WHEEL_CAPS = 'WheelCaps';
    /**
     * Constant for value 'TPMS'
     * @return string 'TPMS'
     */
    const VALUE_TPMS = 'TPMS';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ANY
     * @uses self::VALUE_TIRE
     * @uses self::VALUE_WHEEL
     * @uses self::VALUE_WHEEL_CAPS
     * @uses self::VALUE_TPMS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ANY,
            self::VALUE_TIRE,
            self::VALUE_WHEEL,
            self::VALUE_WHEEL_CAPS,
            self::VALUE_TPMS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
