<?php

namespace EnumType;

/**
 * This class stands for DeliveryDelay EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:DeliveryDelay
 * @subpackage Enumerations
 */
class DeliveryDelay
{
    /**
     * Constant for value 'Stock'
     * @return string 'Stock'
     */
    const VALUE_STOCK = 'Stock';
    /**
     * Constant for value 'D1'
     * @return string 'D1'
     */
    const VALUE_D_1 = 'D1';
    /**
     * Constant for value 'D2'
     * @return string 'D2'
     */
    const VALUE_D_2 = 'D2';
    /**
     * Constant for value 'D3'
     * @return string 'D3'
     */
    const VALUE_D_3 = 'D3';
    /**
     * Constant for value 'None'
     * @return string 'None'
     */
    const VALUE_NONE = 'None';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_STOCK
     * @uses self::VALUE_D_1
     * @uses self::VALUE_D_2
     * @uses self::VALUE_D_3
     * @uses self::VALUE_NONE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_STOCK,
            self::VALUE_D_1,
            self::VALUE_D_2,
            self::VALUE_D_3,
            self::VALUE_NONE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
