<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StoxWebProductRequestContract StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: q4:StoxWebProductRequestContract
 * @subpackage Structs
 */
class StoxWebProductRequestContract extends AbstractStructBase
{
    /**
     * The StoxWebServiceCredentials
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StoxWebServiceCredentialsContract
     */
    public $StoxWebServiceCredentials;
    /**
     * The StoxWebCustomer
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StoxWebCustomerContract
     */
    public $StoxWebCustomer;
    /**
     * The ProductsToFind
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfProductSearchCriteriaContract
     */
    public $ProductsToFind;
    /**
     * The ExportData
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ExportData;
    /**
     * Constructor method for StoxWebProductRequestContract
     * @uses StoxWebProductRequestContract::setStoxWebServiceCredentials()
     * @uses StoxWebProductRequestContract::setStoxWebCustomer()
     * @uses StoxWebProductRequestContract::setProductsToFind()
     * @uses StoxWebProductRequestContract::setExportData()
     * @param \StructType\StoxWebServiceCredentialsContract $stoxWebServiceCredentials
     * @param \StructType\StoxWebCustomerContract $stoxWebCustomer
     * @param \ArrayType\ArrayOfProductSearchCriteriaContract $productsToFind
     * @param bool $exportData
     */
    public function __construct(\StructType\StoxWebServiceCredentialsContract $stoxWebServiceCredentials = null, \StructType\StoxWebCustomerContract $stoxWebCustomer = null, \ArrayType\ArrayOfProductSearchCriteriaContract $productsToFind = null, $exportData = null)
    {
        $this
            ->setStoxWebServiceCredentials($stoxWebServiceCredentials)
            ->setStoxWebCustomer($stoxWebCustomer)
            ->setProductsToFind($productsToFind)
            ->setExportData($exportData);
    }
    /**
     * Get StoxWebServiceCredentials value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StoxWebServiceCredentialsContract|null
     */
    public function getStoxWebServiceCredentials()
    {
        return isset($this->StoxWebServiceCredentials) ? $this->StoxWebServiceCredentials : null;
    }
    /**
     * Set StoxWebServiceCredentials value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StoxWebServiceCredentialsContract $stoxWebServiceCredentials
     * @return \StructType\StoxWebProductRequestContract
     */
    public function setStoxWebServiceCredentials(\StructType\StoxWebServiceCredentialsContract $stoxWebServiceCredentials = null)
    {
        if (is_null($stoxWebServiceCredentials) || (is_array($stoxWebServiceCredentials) && empty($stoxWebServiceCredentials))) {
            unset($this->StoxWebServiceCredentials);
        } else {
            $this->StoxWebServiceCredentials = $stoxWebServiceCredentials;
        }
        return $this;
    }
    /**
     * Get StoxWebCustomer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StoxWebCustomerContract|null
     */
    public function getStoxWebCustomer()
    {
        return isset($this->StoxWebCustomer) ? $this->StoxWebCustomer : null;
    }
    /**
     * Set StoxWebCustomer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StoxWebCustomerContract $stoxWebCustomer
     * @return \StructType\StoxWebProductRequestContract
     */
    public function setStoxWebCustomer(\StructType\StoxWebCustomerContract $stoxWebCustomer = null)
    {
        if (is_null($stoxWebCustomer) || (is_array($stoxWebCustomer) && empty($stoxWebCustomer))) {
            unset($this->StoxWebCustomer);
        } else {
            $this->StoxWebCustomer = $stoxWebCustomer;
        }
        return $this;
    }
    /**
     * Get ProductsToFind value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfProductSearchCriteriaContract|null
     */
    public function getProductsToFind()
    {
        return isset($this->ProductsToFind) ? $this->ProductsToFind : null;
    }
    /**
     * Set ProductsToFind value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfProductSearchCriteriaContract $productsToFind
     * @return \StructType\StoxWebProductRequestContract
     */
    public function setProductsToFind(\ArrayType\ArrayOfProductSearchCriteriaContract $productsToFind = null)
    {
        if (is_null($productsToFind) || (is_array($productsToFind) && empty($productsToFind))) {
            unset($this->ProductsToFind);
        } else {
            $this->ProductsToFind = $productsToFind;
        }
        return $this;
    }
    /**
     * Get ExportData value
     * @return bool|null
     */
    public function getExportData()
    {
        return $this->ExportData;
    }
    /**
     * Set ExportData value
     * @param bool $exportData
     * @return \StructType\StoxWebProductRequestContract
     */
    public function setExportData($exportData = null)
    {
        $this->ExportData = $exportData;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StoxWebProductRequestContract
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
