<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StoxWebProductContract StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: q21:StoxWebProductContract
 * @subpackage Structs
 */
class StoxWebProductContract extends AbstractStructBase
{
    /**
     * The Brand
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StoxWebBrandContract
     */
    public $Brand;
    /**
     * The ProductId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ProductId;
    /**
     * The ProductNo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProductNo;
    /**
     * The ListPrice
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ListPrice;
    /**
     * The CostPrice
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $CostPrice;
    /**
     * The RetailPrice
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $RetailPrice;
    /**
     * The Quantities
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfStoxWebQuantityContract
     */
    public $Quantities;
    /**
     * The Season
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Season;
    /**
     * The ProductType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ProductType;
    /**
     * The ProductDescription
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProductDescription;
    /**
     * Constructor method for StoxWebProductContract
     * @uses StoxWebProductContract::setBrand()
     * @uses StoxWebProductContract::setProductId()
     * @uses StoxWebProductContract::setProductNo()
     * @uses StoxWebProductContract::setListPrice()
     * @uses StoxWebProductContract::setCostPrice()
     * @uses StoxWebProductContract::setRetailPrice()
     * @uses StoxWebProductContract::setQuantities()
     * @uses StoxWebProductContract::setSeason()
     * @uses StoxWebProductContract::setProductType()
     * @uses StoxWebProductContract::setProductDescription()
     * @param \StructType\StoxWebBrandContract $brand
     * @param int $productId
     * @param string $productNo
     * @param float $listPrice
     * @param float $costPrice
     * @param float $retailPrice
     * @param \ArrayType\ArrayOfStoxWebQuantityContract $quantities
     * @param string $season
     * @param string $productType
     * @param string $productDescription
     */
    public function __construct(\StructType\StoxWebBrandContract $brand = null, $productId = null, $productNo = null, $listPrice = null, $costPrice = null, $retailPrice = null, \ArrayType\ArrayOfStoxWebQuantityContract $quantities = null, $season = null, $productType = null, $productDescription = null)
    {
        $this
            ->setBrand($brand)
            ->setProductId($productId)
            ->setProductNo($productNo)
            ->setListPrice($listPrice)
            ->setCostPrice($costPrice)
            ->setRetailPrice($retailPrice)
            ->setQuantities($quantities)
            ->setSeason($season)
            ->setProductType($productType)
            ->setProductDescription($productDescription);
    }
    /**
     * Get Brand value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StoxWebBrandContract|null
     */
    public function getBrand()
    {
        return isset($this->Brand) ? $this->Brand : null;
    }
    /**
     * Set Brand value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StoxWebBrandContract $brand
     * @return \StructType\StoxWebProductContract
     */
    public function setBrand(\StructType\StoxWebBrandContract $brand = null)
    {
        if (is_null($brand) || (is_array($brand) && empty($brand))) {
            unset($this->Brand);
        } else {
            $this->Brand = $brand;
        }
        return $this;
    }
    /**
     * Get ProductId value
     * @return int|null
     */
    public function getProductId()
    {
        return $this->ProductId;
    }
    /**
     * Set ProductId value
     * @param int $productId
     * @return \StructType\StoxWebProductContract
     */
    public function setProductId($productId = null)
    {
        // validation for constraint: int
        if (!is_null($productId) && !is_numeric($productId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($productId)), __LINE__);
        }
        $this->ProductId = $productId;
        return $this;
    }
    /**
     * Get ProductNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProductNo()
    {
        return isset($this->ProductNo) ? $this->ProductNo : null;
    }
    /**
     * Set ProductNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $productNo
     * @return \StructType\StoxWebProductContract
     */
    public function setProductNo($productNo = null)
    {
        // validation for constraint: string
        if (!is_null($productNo) && !is_string($productNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productNo)), __LINE__);
        }
        if (is_null($productNo) || (is_array($productNo) && empty($productNo))) {
            unset($this->ProductNo);
        } else {
            $this->ProductNo = $productNo;
        }
        return $this;
    }
    /**
     * Get ListPrice value
     * @return float|null
     */
    public function getListPrice()
    {
        return $this->ListPrice;
    }
    /**
     * Set ListPrice value
     * @param float $listPrice
     * @return \StructType\StoxWebProductContract
     */
    public function setListPrice($listPrice = null)
    {
        $this->ListPrice = $listPrice;
        return $this;
    }
    /**
     * Get CostPrice value
     * @return float|null
     */
    public function getCostPrice()
    {
        return $this->CostPrice;
    }
    /**
     * Set CostPrice value
     * @param float $costPrice
     * @return \StructType\StoxWebProductContract
     */
    public function setCostPrice($costPrice = null)
    {
        $this->CostPrice = $costPrice;
        return $this;
    }
    /**
     * Get RetailPrice value
     * @return float|null
     */
    public function getRetailPrice()
    {
        return $this->RetailPrice;
    }
    /**
     * Set RetailPrice value
     * @param float $retailPrice
     * @return \StructType\StoxWebProductContract
     */
    public function setRetailPrice($retailPrice = null)
    {
        $this->RetailPrice = $retailPrice;
        return $this;
    }
    /**
     * Get Quantities value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfStoxWebQuantityContract|null
     */
    public function getQuantities()
    {
        return isset($this->Quantities) ? $this->Quantities : null;
    }
    /**
     * Set Quantities value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfStoxWebQuantityContract $quantities
     * @return \StructType\StoxWebProductContract
     */
    public function setQuantities(\ArrayType\ArrayOfStoxWebQuantityContract $quantities = null)
    {
        if (is_null($quantities) || (is_array($quantities) && empty($quantities))) {
            unset($this->Quantities);
        } else {
            $this->Quantities = $quantities;
        }
        return $this;
    }
    /**
     * Get Season value
     * @return string|null
     */
    public function getSeason()
    {
        return $this->Season;
    }
    /**
     * Set Season value
     * @uses \EnumType\Season::valueIsValid()
     * @uses \EnumType\Season::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $season
     * @return \StructType\StoxWebProductContract
     */
    public function setSeason($season = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Season::valueIsValid($season)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $season, implode(', ', \EnumType\Season::getValidValues())), __LINE__);
        }
        $this->Season = $season;
        return $this;
    }
    /**
     * Get ProductType value
     * @return string|null
     */
    public function getProductType()
    {
        return $this->ProductType;
    }
    /**
     * Set ProductType value
     * @uses \EnumType\ProductType::valueIsValid()
     * @uses \EnumType\ProductType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $productType
     * @return \StructType\StoxWebProductContract
     */
    public function setProductType($productType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ProductType::valueIsValid($productType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $productType, implode(', ', \EnumType\ProductType::getValidValues())), __LINE__);
        }
        $this->ProductType = $productType;
        return $this;
    }
    /**
     * Get ProductDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProductDescription()
    {
        return isset($this->ProductDescription) ? $this->ProductDescription : null;
    }
    /**
     * Set ProductDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $productDescription
     * @return \StructType\StoxWebProductContract
     */
    public function setProductDescription($productDescription = null)
    {
        // validation for constraint: string
        if (!is_null($productDescription) && !is_string($productDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productDescription)), __LINE__);
        }
        if (is_null($productDescription) || (is_array($productDescription) && empty($productDescription))) {
            unset($this->ProductDescription);
        } else {
            $this->ProductDescription = $productDescription;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StoxWebProductContract
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
