<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetProductDetailedQuantities StructType
 * @subpackage Structs
 */
class GetProductDetailedQuantities extends AbstractStructBase
{
    /**
     * The productRequest
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StoxWebProductRequestContract
     */
    public $productRequest;
    /**
     * Constructor method for GetProductDetailedQuantities
     * @uses GetProductDetailedQuantities::setProductRequest()
     * @param \StructType\StoxWebProductRequestContract $productRequest
     */
    public function __construct(\StructType\StoxWebProductRequestContract $productRequest = null)
    {
        $this
            ->setProductRequest($productRequest);
    }
    /**
     * Get productRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StoxWebProductRequestContract|null
     */
    public function getProductRequest()
    {
        return isset($this->productRequest) ? $this->productRequest : null;
    }
    /**
     * Set productRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StoxWebProductRequestContract $productRequest
     * @return \StructType\GetProductDetailedQuantities
     */
    public function setProductRequest(\StructType\StoxWebProductRequestContract $productRequest = null)
    {
        if (is_null($productRequest) || (is_array($productRequest) && empty($productRequest))) {
            unset($this->productRequest);
        } else {
            $this->productRequest = $productRequest;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetProductDetailedQuantities
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
