<?php

namespace EnumType;

/**
 * This class stands for StoxWebErrorLevel EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:StoxWebErrorLevel
 * @subpackage Enumerations
 */
class StoxWebErrorLevel
{
    /**
     * Constant for value 'Info'
     * @return string 'Info'
     */
    const VALUE_INFO = 'Info';
    /**
     * Constant for value 'Warning'
     * @return string 'Warning'
     */
    const VALUE_WARNING = 'Warning';
    /**
     * Constant for value 'Error'
     * @return string 'Error'
     */
    const VALUE_ERROR = 'Error';
    /**
     * Constant for value 'Fatal'
     * @return string 'Fatal'
     */
    const VALUE_FATAL = 'Fatal';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_INFO
     * @uses self::VALUE_WARNING
     * @uses self::VALUE_ERROR
     * @uses self::VALUE_FATAL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_INFO,
            self::VALUE_WARNING,
            self::VALUE_ERROR,
            self::VALUE_FATAL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
