<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StoxWebProductDetailedQuantityContract StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: q73:StoxWebProductDetailedQuantityContract
 * @subpackage Structs
 */
class StoxWebProductDetailedQuantityContract extends AbstractStructBase
{
    /**
     * The Brand
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StoxWebBrandContract
     */
    public $Brand;
    /**
     * The ProductId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ProductId;
    /**
     * The ProductNo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProductNo;
    /**
     * The QuantitiesByLocation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfStoxWebDetailedQuantityContract
     */
    public $QuantitiesByLocation;
    /**
     * Constructor method for StoxWebProductDetailedQuantityContract
     * @uses StoxWebProductDetailedQuantityContract::setBrand()
     * @uses StoxWebProductDetailedQuantityContract::setProductId()
     * @uses StoxWebProductDetailedQuantityContract::setProductNo()
     * @uses StoxWebProductDetailedQuantityContract::setQuantitiesByLocation()
     * @param \StructType\StoxWebBrandContract $brand
     * @param int $productId
     * @param string $productNo
     * @param \ArrayType\ArrayOfStoxWebDetailedQuantityContract $quantitiesByLocation
     */
    public function __construct(\StructType\StoxWebBrandContract $brand = null, $productId = null, $productNo = null, \ArrayType\ArrayOfStoxWebDetailedQuantityContract $quantitiesByLocation = null)
    {
        $this
            ->setBrand($brand)
            ->setProductId($productId)
            ->setProductNo($productNo)
            ->setQuantitiesByLocation($quantitiesByLocation);
    }
    /**
     * Get Brand value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StoxWebBrandContract|null
     */
    public function getBrand()
    {
        return isset($this->Brand) ? $this->Brand : null;
    }
    /**
     * Set Brand value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StoxWebBrandContract $brand
     * @return \StructType\StoxWebProductDetailedQuantityContract
     */
    public function setBrand(\StructType\StoxWebBrandContract $brand = null)
    {
        if (is_null($brand) || (is_array($brand) && empty($brand))) {
            unset($this->Brand);
        } else {
            $this->Brand = $brand;
        }
        return $this;
    }
    /**
     * Get ProductId value
     * @return int|null
     */
    public function getProductId()
    {
        return $this->ProductId;
    }
    /**
     * Set ProductId value
     * @param int $productId
     * @return \StructType\StoxWebProductDetailedQuantityContract
     */
    public function setProductId($productId = null)
    {
        // validation for constraint: int
        if (!is_null($productId) && !is_numeric($productId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($productId)), __LINE__);
        }
        $this->ProductId = $productId;
        return $this;
    }
    /**
     * Get ProductNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProductNo()
    {
        return isset($this->ProductNo) ? $this->ProductNo : null;
    }
    /**
     * Set ProductNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $productNo
     * @return \StructType\StoxWebProductDetailedQuantityContract
     */
    public function setProductNo($productNo = null)
    {
        // validation for constraint: string
        if (!is_null($productNo) && !is_string($productNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productNo)), __LINE__);
        }
        if (is_null($productNo) || (is_array($productNo) && empty($productNo))) {
            unset($this->ProductNo);
        } else {
            $this->ProductNo = $productNo;
        }
        return $this;
    }
    /**
     * Get QuantitiesByLocation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfStoxWebDetailedQuantityContract|null
     */
    public function getQuantitiesByLocation()
    {
        return isset($this->QuantitiesByLocation) ? $this->QuantitiesByLocation : null;
    }
    /**
     * Set QuantitiesByLocation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfStoxWebDetailedQuantityContract $quantitiesByLocation
     * @return \StructType\StoxWebProductDetailedQuantityContract
     */
    public function setQuantitiesByLocation(\ArrayType\ArrayOfStoxWebDetailedQuantityContract $quantitiesByLocation = null)
    {
        if (is_null($quantitiesByLocation) || (is_array($quantitiesByLocation) && empty($quantitiesByLocation))) {
            unset($this->QuantitiesByLocation);
        } else {
            $this->QuantitiesByLocation = $quantitiesByLocation;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StoxWebProductDetailedQuantityContract
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
