<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StoxWebLocationContract StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: q55:StoxWebLocationContract
 * @subpackage Structs
 */
class StoxWebLocationContract extends AbstractStructBase
{
    /**
     * The LocationId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $LocationId;
    /**
     * The LocationName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LocationName;
    /**
     * The LocationAddress1
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LocationAddress1;
    /**
     * The LocationAddress2
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LocationAddress2;
    /**
     * The LocationCity
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LocationCity;
    /**
     * The LocationPostalCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LocationPostalCode;
    /**
     * The LocationProvince
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LocationProvince;
    /**
     * Constructor method for StoxWebLocationContract
     * @uses StoxWebLocationContract::setLocationId()
     * @uses StoxWebLocationContract::setLocationName()
     * @uses StoxWebLocationContract::setLocationAddress1()
     * @uses StoxWebLocationContract::setLocationAddress2()
     * @uses StoxWebLocationContract::setLocationCity()
     * @uses StoxWebLocationContract::setLocationPostalCode()
     * @uses StoxWebLocationContract::setLocationProvince()
     * @param int $locationId
     * @param string $locationName
     * @param string $locationAddress1
     * @param string $locationAddress2
     * @param string $locationCity
     * @param string $locationPostalCode
     * @param string $locationProvince
     */
    public function __construct($locationId = null, $locationName = null, $locationAddress1 = null, $locationAddress2 = null, $locationCity = null, $locationPostalCode = null, $locationProvince = null)
    {
        $this
            ->setLocationId($locationId)
            ->setLocationName($locationName)
            ->setLocationAddress1($locationAddress1)
            ->setLocationAddress2($locationAddress2)
            ->setLocationCity($locationCity)
            ->setLocationPostalCode($locationPostalCode)
            ->setLocationProvince($locationProvince);
    }
    /**
     * Get LocationId value
     * @return int|null
     */
    public function getLocationId()
    {
        return $this->LocationId;
    }
    /**
     * Set LocationId value
     * @param int $locationId
     * @return \StructType\StoxWebLocationContract
     */
    public function setLocationId($locationId = null)
    {
        // validation for constraint: int
        if (!is_null($locationId) && !is_numeric($locationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($locationId)), __LINE__);
        }
        $this->LocationId = $locationId;
        return $this;
    }
    /**
     * Get LocationName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLocationName()
    {
        return isset($this->LocationName) ? $this->LocationName : null;
    }
    /**
     * Set LocationName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $locationName
     * @return \StructType\StoxWebLocationContract
     */
    public function setLocationName($locationName = null)
    {
        // validation for constraint: string
        if (!is_null($locationName) && !is_string($locationName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($locationName)), __LINE__);
        }
        if (is_null($locationName) || (is_array($locationName) && empty($locationName))) {
            unset($this->LocationName);
        } else {
            $this->LocationName = $locationName;
        }
        return $this;
    }
    /**
     * Get LocationAddress1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLocationAddress1()
    {
        return isset($this->LocationAddress1) ? $this->LocationAddress1 : null;
    }
    /**
     * Set LocationAddress1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $locationAddress1
     * @return \StructType\StoxWebLocationContract
     */
    public function setLocationAddress1($locationAddress1 = null)
    {
        // validation for constraint: string
        if (!is_null($locationAddress1) && !is_string($locationAddress1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($locationAddress1)), __LINE__);
        }
        if (is_null($locationAddress1) || (is_array($locationAddress1) && empty($locationAddress1))) {
            unset($this->LocationAddress1);
        } else {
            $this->LocationAddress1 = $locationAddress1;
        }
        return $this;
    }
    /**
     * Get LocationAddress2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLocationAddress2()
    {
        return isset($this->LocationAddress2) ? $this->LocationAddress2 : null;
    }
    /**
     * Set LocationAddress2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $locationAddress2
     * @return \StructType\StoxWebLocationContract
     */
    public function setLocationAddress2($locationAddress2 = null)
    {
        // validation for constraint: string
        if (!is_null($locationAddress2) && !is_string($locationAddress2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($locationAddress2)), __LINE__);
        }
        if (is_null($locationAddress2) || (is_array($locationAddress2) && empty($locationAddress2))) {
            unset($this->LocationAddress2);
        } else {
            $this->LocationAddress2 = $locationAddress2;
        }
        return $this;
    }
    /**
     * Get LocationCity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLocationCity()
    {
        return isset($this->LocationCity) ? $this->LocationCity : null;
    }
    /**
     * Set LocationCity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $locationCity
     * @return \StructType\StoxWebLocationContract
     */
    public function setLocationCity($locationCity = null)
    {
        // validation for constraint: string
        if (!is_null($locationCity) && !is_string($locationCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($locationCity)), __LINE__);
        }
        if (is_null($locationCity) || (is_array($locationCity) && empty($locationCity))) {
            unset($this->LocationCity);
        } else {
            $this->LocationCity = $locationCity;
        }
        return $this;
    }
    /**
     * Get LocationPostalCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLocationPostalCode()
    {
        return isset($this->LocationPostalCode) ? $this->LocationPostalCode : null;
    }
    /**
     * Set LocationPostalCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $locationPostalCode
     * @return \StructType\StoxWebLocationContract
     */
    public function setLocationPostalCode($locationPostalCode = null)
    {
        // validation for constraint: string
        if (!is_null($locationPostalCode) && !is_string($locationPostalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($locationPostalCode)), __LINE__);
        }
        if (is_null($locationPostalCode) || (is_array($locationPostalCode) && empty($locationPostalCode))) {
            unset($this->LocationPostalCode);
        } else {
            $this->LocationPostalCode = $locationPostalCode;
        }
        return $this;
    }
    /**
     * Get LocationProvince value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLocationProvince()
    {
        return isset($this->LocationProvince) ? $this->LocationProvince : null;
    }
    /**
     * Set LocationProvince value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $locationProvince
     * @return \StructType\StoxWebLocationContract
     */
    public function setLocationProvince($locationProvince = null)
    {
        // validation for constraint: string
        if (!is_null($locationProvince) && !is_string($locationProvince)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($locationProvince)), __LINE__);
        }
        if (is_null($locationProvince) || (is_array($locationProvince) && empty($locationProvince))) {
            unset($this->LocationProvince);
        } else {
            $this->LocationProvince = $locationProvince;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StoxWebLocationContract
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
