<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StoxWebDetailedQuantityContract StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: q77:StoxWebDetailedQuantityContract
 * @subpackage Structs
 */
class StoxWebDetailedQuantityContract extends AbstractStructBase
{
    /**
     * The LocationId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $LocationId;
    /**
     * The DeliveryDelay
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DeliveryDelay;
    /**
     * The Qty
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Qty;
    /**
     * Constructor method for StoxWebDetailedQuantityContract
     * @uses StoxWebDetailedQuantityContract::setLocationId()
     * @uses StoxWebDetailedQuantityContract::setDeliveryDelay()
     * @uses StoxWebDetailedQuantityContract::setQty()
     * @param int $locationId
     * @param string $deliveryDelay
     * @param float $qty
     */
    public function __construct($locationId = null, $deliveryDelay = null, $qty = null)
    {
        $this
            ->setLocationId($locationId)
            ->setDeliveryDelay($deliveryDelay)
            ->setQty($qty);
    }
    /**
     * Get LocationId value
     * @return int|null
     */
    public function getLocationId()
    {
        return $this->LocationId;
    }
    /**
     * Set LocationId value
     * @param int $locationId
     * @return \StructType\StoxWebDetailedQuantityContract
     */
    public function setLocationId($locationId = null)
    {
        // validation for constraint: int
        if (!is_null($locationId) && !is_numeric($locationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($locationId)), __LINE__);
        }
        $this->LocationId = $locationId;
        return $this;
    }
    /**
     * Get DeliveryDelay value
     * @return string|null
     */
    public function getDeliveryDelay()
    {
        return $this->DeliveryDelay;
    }
    /**
     * Set DeliveryDelay value
     * @uses \EnumType\DeliveryDelay::valueIsValid()
     * @uses \EnumType\DeliveryDelay::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $deliveryDelay
     * @return \StructType\StoxWebDetailedQuantityContract
     */
    public function setDeliveryDelay($deliveryDelay = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DeliveryDelay::valueIsValid($deliveryDelay)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $deliveryDelay, implode(', ', \EnumType\DeliveryDelay::getValidValues())), __LINE__);
        }
        $this->DeliveryDelay = $deliveryDelay;
        return $this;
    }
    /**
     * Get Qty value
     * @return float|null
     */
    public function getQty()
    {
        return $this->Qty;
    }
    /**
     * Set Qty value
     * @param float $qty
     * @return \StructType\StoxWebDetailedQuantityContract
     */
    public function setQty($qty = null)
    {
        $this->Qty = $qty;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StoxWebDetailedQuantityContract
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
