<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BaseStoxWebServiceErrorContract StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: q34:BaseStoxWebServiceErrorContract
 * @subpackage Structs
 */
class BaseStoxWebServiceErrorContract extends AbstractStructBase
{
    /**
     * The ErrorLevel
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ErrorLevel;
    /**
     * The ErrorCategory
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ErrorCategory;
    /**
     * The ErrorSubCategory
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ErrorSubCategory;
    /**
     * The ErrorCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ErrorCode;
    /**
     * The ErrorMessages
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfArrayOfKeyValueOfstringstring
     */
    public $ErrorMessages;
    /**
     * Constructor method for BaseStoxWebServiceErrorContract
     * @uses BaseStoxWebServiceErrorContract::setErrorLevel()
     * @uses BaseStoxWebServiceErrorContract::setErrorCategory()
     * @uses BaseStoxWebServiceErrorContract::setErrorSubCategory()
     * @uses BaseStoxWebServiceErrorContract::setErrorCode()
     * @uses BaseStoxWebServiceErrorContract::setErrorMessages()
     * @param string $errorLevel
     * @param string $errorCategory
     * @param string $errorSubCategory
     * @param string $errorCode
     * @param \ArrayType\ArrayOfArrayOfKeyValueOfstringstring $errorMessages
     */
    public function __construct($errorLevel = null, $errorCategory = null, $errorSubCategory = null, $errorCode = null, \ArrayType\ArrayOfArrayOfKeyValueOfstringstring $errorMessages = null)
    {
        $this
            ->setErrorLevel($errorLevel)
            ->setErrorCategory($errorCategory)
            ->setErrorSubCategory($errorSubCategory)
            ->setErrorCode($errorCode)
            ->setErrorMessages($errorMessages);
    }
    /**
     * Get ErrorLevel value
     * @return string|null
     */
    public function getErrorLevel()
    {
        return $this->ErrorLevel;
    }
    /**
     * Set ErrorLevel value
     * @uses \EnumType\StoxWebErrorLevel::valueIsValid()
     * @uses \EnumType\StoxWebErrorLevel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $errorLevel
     * @return \StructType\BaseStoxWebServiceErrorContract
     */
    public function setErrorLevel($errorLevel = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\StoxWebErrorLevel::valueIsValid($errorLevel)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $errorLevel, implode(', ', \EnumType\StoxWebErrorLevel::getValidValues())), __LINE__);
        }
        $this->ErrorLevel = $errorLevel;
        return $this;
    }
    /**
     * Get ErrorCategory value
     * @return string|null
     */
    public function getErrorCategory()
    {
        return $this->ErrorCategory;
    }
    /**
     * Set ErrorCategory value
     * @uses \EnumType\StoxWebErrorCategory::valueIsValid()
     * @uses \EnumType\StoxWebErrorCategory::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $errorCategory
     * @return \StructType\BaseStoxWebServiceErrorContract
     */
    public function setErrorCategory($errorCategory = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\StoxWebErrorCategory::valueIsValid($errorCategory)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $errorCategory, implode(', ', \EnumType\StoxWebErrorCategory::getValidValues())), __LINE__);
        }
        $this->ErrorCategory = $errorCategory;
        return $this;
    }
    /**
     * Get ErrorSubCategory value
     * @return string|null
     */
    public function getErrorSubCategory()
    {
        return $this->ErrorSubCategory;
    }
    /**
     * Set ErrorSubCategory value
     * @uses \EnumType\StoxWebErrorSubCategory::valueIsValid()
     * @uses \EnumType\StoxWebErrorSubCategory::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $errorSubCategory
     * @return \StructType\BaseStoxWebServiceErrorContract
     */
    public function setErrorSubCategory($errorSubCategory = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\StoxWebErrorSubCategory::valueIsValid($errorSubCategory)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $errorSubCategory, implode(', ', \EnumType\StoxWebErrorSubCategory::getValidValues())), __LINE__);
        }
        $this->ErrorSubCategory = $errorSubCategory;
        return $this;
    }
    /**
     * Get ErrorCode value
     * @return string|null
     */
    public function getErrorCode()
    {
        return $this->ErrorCode;
    }
    /**
     * Set ErrorCode value
     * @uses \EnumType\StoxWebErrorCode::valueIsValid()
     * @uses \EnumType\StoxWebErrorCode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $errorCode
     * @return \StructType\BaseStoxWebServiceErrorContract
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\StoxWebErrorCode::valueIsValid($errorCode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $errorCode, implode(', ', \EnumType\StoxWebErrorCode::getValidValues())), __LINE__);
        }
        $this->ErrorCode = $errorCode;
        return $this;
    }
    /**
     * Get ErrorMessages value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfArrayOfKeyValueOfstringstring|null
     */
    public function getErrorMessages()
    {
        return isset($this->ErrorMessages) ? $this->ErrorMessages : null;
    }
    /**
     * Set ErrorMessages value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfArrayOfKeyValueOfstringstring $errorMessages
     * @return \StructType\BaseStoxWebServiceErrorContract
     */
    public function setErrorMessages(\ArrayType\ArrayOfArrayOfKeyValueOfstringstring $errorMessages = null)
    {
        if (is_null($errorMessages) || (is_array($errorMessages) && empty($errorMessages))) {
            unset($this->ErrorMessages);
        } else {
            $this->ErrorMessages = $errorMessages;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BaseStoxWebServiceErrorContract
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
