<?php

namespace EnumType;

/**
 * This class stands for StoxWebErrorCode EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:StoxWebErrorCode
 * @subpackage Enumerations
 */
class StoxWebErrorCode
{
    /**
     * Constant for value 'General'
     * @return string 'General'
     */
    const VALUE_GENERAL = 'General';
    /**
     * Constant for value 'NotFound'
     * @return string 'NotFound'
     */
    const VALUE_NOT_FOUND = 'NotFound';
    /**
     * Constant for value 'Discontinued'
     * @return string 'Discontinued'
     */
    const VALUE_DISCONTINUED = 'Discontinued';
    /**
     * Constant for value 'Denied'
     * @return string 'Denied'
     */
    const VALUE_DENIED = 'Denied';
    /**
     * Constant for value 'Empty'
     * @return string 'Empty'
     */
    const VALUE_EMPTY = 'Empty';
    /**
     * Constant for value 'Invalid'
     * @return string 'Invalid'
     */
    const VALUE_INVALID = 'Invalid';
    /**
     * Constant for value 'Failed'
     * @return string 'Failed'
     */
    const VALUE_FAILED = 'Failed';
    /**
     * Constant for value 'Missing'
     * @return string 'Missing'
     */
    const VALUE_MISSING = 'Missing';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_GENERAL
     * @uses self::VALUE_NOT_FOUND
     * @uses self::VALUE_DISCONTINUED
     * @uses self::VALUE_DENIED
     * @uses self::VALUE_EMPTY
     * @uses self::VALUE_INVALID
     * @uses self::VALUE_FAILED
     * @uses self::VALUE_MISSING
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_GENERAL,
            self::VALUE_NOT_FOUND,
            self::VALUE_DISCONTINUED,
            self::VALUE_DENIED,
            self::VALUE_EMPTY,
            self::VALUE_INVALID,
            self::VALUE_FAILED,
            self::VALUE_MISSING,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
