<?php

namespace EnumType;

/**
 * This class stands for Season EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Season
 * @subpackage Enumerations
 */
class Season
{
    /**
     * Constant for value 'Any'
     * @return string 'Any'
     */
    const VALUE_ANY = 'Any';
    /**
     * Constant for value 'Winter'
     * @return string 'Winter'
     */
    const VALUE_WINTER = 'Winter';
    /**
     * Constant for value 'Summer'
     * @return string 'Summer'
     */
    const VALUE_SUMMER = 'Summer';
    /**
     * Constant for value 'ThreeSeason'
     * @return string 'ThreeSeason'
     */
    const VALUE_THREE_SEASON = 'ThreeSeason';
    /**
     * Constant for value 'AllWeather'
     * @return string 'AllWeather'
     */
    const VALUE_ALL_WEATHER = 'AllWeather';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ANY
     * @uses self::VALUE_WINTER
     * @uses self::VALUE_SUMMER
     * @uses self::VALUE_THREE_SEASON
     * @uses self::VALUE_ALL_WEATHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ANY,
            self::VALUE_WINTER,
            self::VALUE_SUMMER,
            self::VALUE_THREE_SEASON,
            self::VALUE_ALL_WEATHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
