<?php

namespace Service\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateUserProfilePhoto StructType
 * @subpackage Structs
 */
class UpdateUserProfilePhoto extends AbstractStructBase
{
    /**
     * The IDUtente
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IDUtente;
    /**
     * The Image
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Image;
    /**
     * Constructor method for UpdateUserProfilePhoto
     * @uses UpdateUserProfilePhoto::setIDUtente()
     * @uses UpdateUserProfilePhoto::setImage()
     * @param int $iDUtente
     * @param string $image
     */
    public function __construct($iDUtente = null, $image = null)
    {
        $this
            ->setIDUtente($iDUtente)
            ->setImage($image);
    }
    /**
     * Get IDUtente value
     * @return int|null
     */
    public function getIDUtente()
    {
        return $this->IDUtente;
    }
    /**
     * Set IDUtente value
     * @param int $iDUtente
     * @return \Service\StructType\UpdateUserProfilePhoto
     */
    public function setIDUtente($iDUtente = null)
    {
        // validation for constraint: int
        if (!is_null($iDUtente) && !(is_int($iDUtente) || ctype_digit($iDUtente))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iDUtente, true), gettype($iDUtente)), __LINE__);
        }
        $this->IDUtente = $iDUtente;
        return $this;
    }
    /**
     * Get Image value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getImage()
    {
        return isset($this->Image) ? $this->Image : null;
    }
    /**
     * Set Image value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $image
     * @return \Service\StructType\UpdateUserProfilePhoto
     */
    public function setImage($image = null)
    {
        // validation for constraint: string
        if (!is_null($image) && !is_string($image)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($image, true), gettype($image)), __LINE__);
        }
        if (is_null($image) || (is_array($image) && empty($image))) {
            unset($this->Image);
        } else {
            $this->Image = $image;
        }
        return $this;
    }
}
