<?php

namespace Service\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RegistraFCMToken StructType
 * @subpackage Structs
 */
class RegistraFCMToken extends AbstractStructBase
{
    /**
     * The IDUtente
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IDUtente;
    /**
     * The IMEI
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IMEI;
    /**
     * The FCMToken
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FCMToken;
    /**
     * Constructor method for RegistraFCMToken
     * @uses RegistraFCMToken::setIDUtente()
     * @uses RegistraFCMToken::setIMEI()
     * @uses RegistraFCMToken::setFCMToken()
     * @param int $iDUtente
     * @param string $iMEI
     * @param string $fCMToken
     */
    public function __construct($iDUtente = null, $iMEI = null, $fCMToken = null)
    {
        $this
            ->setIDUtente($iDUtente)
            ->setIMEI($iMEI)
            ->setFCMToken($fCMToken);
    }
    /**
     * Get IDUtente value
     * @return int|null
     */
    public function getIDUtente()
    {
        return $this->IDUtente;
    }
    /**
     * Set IDUtente value
     * @param int $iDUtente
     * @return \Service\StructType\RegistraFCMToken
     */
    public function setIDUtente($iDUtente = null)
    {
        // validation for constraint: int
        if (!is_null($iDUtente) && !(is_int($iDUtente) || ctype_digit($iDUtente))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iDUtente, true), gettype($iDUtente)), __LINE__);
        }
        $this->IDUtente = $iDUtente;
        return $this;
    }
    /**
     * Get IMEI value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIMEI()
    {
        return isset($this->IMEI) ? $this->IMEI : null;
    }
    /**
     * Set IMEI value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $iMEI
     * @return \Service\StructType\RegistraFCMToken
     */
    public function setIMEI($iMEI = null)
    {
        // validation for constraint: string
        if (!is_null($iMEI) && !is_string($iMEI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iMEI, true), gettype($iMEI)), __LINE__);
        }
        if (is_null($iMEI) || (is_array($iMEI) && empty($iMEI))) {
            unset($this->IMEI);
        } else {
            $this->IMEI = $iMEI;
        }
        return $this;
    }
    /**
     * Get FCMToken value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFCMToken()
    {
        return isset($this->FCMToken) ? $this->FCMToken : null;
    }
    /**
     * Set FCMToken value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fCMToken
     * @return \Service\StructType\RegistraFCMToken
     */
    public function setFCMToken($fCMToken = null)
    {
        // validation for constraint: string
        if (!is_null($fCMToken) && !is_string($fCMToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fCMToken, true), gettype($fCMToken)), __LINE__);
        }
        if (is_null($fCMToken) || (is_array($fCMToken) && empty($fCMToken))) {
            unset($this->FCMToken);
        } else {
            $this->FCMToken = $fCMToken;
        }
        return $this;
    }
}
