<?php

namespace Service\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Recapito_Model StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Recapito_Model
 * @subpackage Structs
 */
class Recapito_Model extends AbstractStructBase
{
    /**
     * The Descrizione
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Descrizione;
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ID;
    /**
     * The Prefisso
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Prefisso;
    /**
     * The Telefono
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Telefono;
    /**
     * The Tipo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Service\StructType\TipoRecapito
     */
    public $Tipo;
    /**
     * Constructor method for Recapito_Model
     * @uses Recapito_Model::setDescrizione()
     * @uses Recapito_Model::setID()
     * @uses Recapito_Model::setPrefisso()
     * @uses Recapito_Model::setTelefono()
     * @uses Recapito_Model::setTipo()
     * @param string $descrizione
     * @param int $iD
     * @param string $prefisso
     * @param string $telefono
     * @param \Service\StructType\TipoRecapito $tipo
     */
    public function __construct($descrizione = null, $iD = null, $prefisso = null, $telefono = null, \Service\StructType\TipoRecapito $tipo = null)
    {
        $this
            ->setDescrizione($descrizione)
            ->setID($iD)
            ->setPrefisso($prefisso)
            ->setTelefono($telefono)
            ->setTipo($tipo);
    }
    /**
     * Get Descrizione value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescrizione()
    {
        return isset($this->Descrizione) ? $this->Descrizione : null;
    }
    /**
     * Set Descrizione value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $descrizione
     * @return \Service\StructType\Recapito_Model
     */
    public function setDescrizione($descrizione = null)
    {
        // validation for constraint: string
        if (!is_null($descrizione) && !is_string($descrizione)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descrizione, true), gettype($descrizione)), __LINE__);
        }
        if (is_null($descrizione) || (is_array($descrizione) && empty($descrizione))) {
            unset($this->Descrizione);
        } else {
            $this->Descrizione = $descrizione;
        }
        return $this;
    }
    /**
     * Get ID value
     * @return int|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \Service\StructType\Recapito_Model
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !(is_int($iD) || ctype_digit($iD))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Prefisso value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrefisso()
    {
        return isset($this->Prefisso) ? $this->Prefisso : null;
    }
    /**
     * Set Prefisso value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prefisso
     * @return \Service\StructType\Recapito_Model
     */
    public function setPrefisso($prefisso = null)
    {
        // validation for constraint: string
        if (!is_null($prefisso) && !is_string($prefisso)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prefisso, true), gettype($prefisso)), __LINE__);
        }
        if (is_null($prefisso) || (is_array($prefisso) && empty($prefisso))) {
            unset($this->Prefisso);
        } else {
            $this->Prefisso = $prefisso;
        }
        return $this;
    }
    /**
     * Get Telefono value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTelefono()
    {
        return isset($this->Telefono) ? $this->Telefono : null;
    }
    /**
     * Set Telefono value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $telefono
     * @return \Service\StructType\Recapito_Model
     */
    public function setTelefono($telefono = null)
    {
        // validation for constraint: string
        if (!is_null($telefono) && !is_string($telefono)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($telefono, true), gettype($telefono)), __LINE__);
        }
        if (is_null($telefono) || (is_array($telefono) && empty($telefono))) {
            unset($this->Telefono);
        } else {
            $this->Telefono = $telefono;
        }
        return $this;
    }
    /**
     * Get Tipo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Service\StructType\TipoRecapito|null
     */
    public function getTipo()
    {
        return isset($this->Tipo) ? $this->Tipo : null;
    }
    /**
     * Set Tipo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Service\StructType\TipoRecapito $tipo
     * @return \Service\StructType\Recapito_Model
     */
    public function setTipo(\Service\StructType\TipoRecapito $tipo = null)
    {
        if (is_null($tipo) || (is_array($tipo) && empty($tipo))) {
            unset($this->Tipo);
        } else {
            $this->Tipo = $tipo;
        }
        return $this;
    }
}
