<?php

namespace Service\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Login_Result StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Login_Result
 * @subpackage Structs
 */
class Login_Result extends AbstractStructBase
{
    /**
     * The AuthToken
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AuthToken;
    /**
     * The Informazioni
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Service\StructType\AdditionaInformation
     */
    public $Informazioni;
    /**
     * The Utente
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Service\StructType\UtentePCGav
     */
    public $Utente;
    /**
     * Constructor method for Login_Result
     * @uses Login_Result::setAuthToken()
     * @uses Login_Result::setInformazioni()
     * @uses Login_Result::setUtente()
     * @param string $authToken
     * @param \Service\StructType\AdditionaInformation $informazioni
     * @param \Service\StructType\UtentePCGav $utente
     */
    public function __construct($authToken = null, \Service\StructType\AdditionaInformation $informazioni = null, \Service\StructType\UtentePCGav $utente = null)
    {
        $this
            ->setAuthToken($authToken)
            ->setInformazioni($informazioni)
            ->setUtente($utente);
    }
    /**
     * Get AuthToken value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAuthToken()
    {
        return isset($this->AuthToken) ? $this->AuthToken : null;
    }
    /**
     * Set AuthToken value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $authToken
     * @return \Service\StructType\Login_Result
     */
    public function setAuthToken($authToken = null)
    {
        // validation for constraint: string
        if (!is_null($authToken) && !is_string($authToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authToken, true), gettype($authToken)), __LINE__);
        }
        if (is_null($authToken) || (is_array($authToken) && empty($authToken))) {
            unset($this->AuthToken);
        } else {
            $this->AuthToken = $authToken;
        }
        return $this;
    }
    /**
     * Get Informazioni value
     * @return \Service\StructType\AdditionaInformation|null
     */
    public function getInformazioni()
    {
        return $this->Informazioni;
    }
    /**
     * Set Informazioni value
     * @param \Service\StructType\AdditionaInformation $informazioni
     * @return \Service\StructType\Login_Result
     */
    public function setInformazioni(\Service\StructType\AdditionaInformation $informazioni = null)
    {
        $this->Informazioni = $informazioni;
        return $this;
    }
    /**
     * Get Utente value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Service\StructType\UtentePCGav|null
     */
    public function getUtente()
    {
        return isset($this->Utente) ? $this->Utente : null;
    }
    /**
     * Set Utente value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Service\StructType\UtentePCGav $utente
     * @return \Service\StructType\Login_Result
     */
    public function setUtente(\Service\StructType\UtentePCGav $utente = null)
    {
        if (is_null($utente) || (is_array($utente) && empty($utente))) {
            unset($this->Utente);
        } else {
            $this->Utente = $utente;
        }
        return $this;
    }
}
