<?php

namespace Service\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IncassaQuotaAssociativa StructType
 * @subpackage Structs
 */
class IncassaQuotaAssociativa extends AbstractStructBase
{
    /**
     * The IDProdotto
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $IDProdotto;
    /**
     * The TipoVersamento
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TipoVersamento;
    /**
     * The IDAnagrafe
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IDAnagrafe;
    /**
     * The Importo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Importo;
    /**
     * Constructor method for IncassaQuotaAssociativa
     * @uses IncassaQuotaAssociativa::setIDProdotto()
     * @uses IncassaQuotaAssociativa::setTipoVersamento()
     * @uses IncassaQuotaAssociativa::setIDAnagrafe()
     * @uses IncassaQuotaAssociativa::setImporto()
     * @param string $iDProdotto
     * @param int $tipoVersamento
     * @param int $iDAnagrafe
     * @param float $importo
     */
    public function __construct($iDProdotto = null, $tipoVersamento = null, $iDAnagrafe = null, $importo = null)
    {
        $this
            ->setIDProdotto($iDProdotto)
            ->setTipoVersamento($tipoVersamento)
            ->setIDAnagrafe($iDAnagrafe)
            ->setImporto($importo);
    }
    /**
     * Get IDProdotto value
     * @return string|null
     */
    public function getIDProdotto()
    {
        return $this->IDProdotto;
    }
    /**
     * Set IDProdotto value
     * @uses \Service\EnumType\SoftwareClient::valueIsValid()
     * @uses \Service\EnumType\SoftwareClient::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $iDProdotto
     * @return \Service\StructType\IncassaQuotaAssociativa
     */
    public function setIDProdotto($iDProdotto = null)
    {
        // validation for constraint: enumeration
        if (!\Service\EnumType\SoftwareClient::valueIsValid($iDProdotto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Service\EnumType\SoftwareClient', is_array($iDProdotto) ? implode(', ', $iDProdotto) : var_export($iDProdotto, true), implode(', ', \Service\EnumType\SoftwareClient::getValidValues())), __LINE__);
        }
        $this->IDProdotto = $iDProdotto;
        return $this;
    }
    /**
     * Get TipoVersamento value
     * @return int|null
     */
    public function getTipoVersamento()
    {
        return $this->TipoVersamento;
    }
    /**
     * Set TipoVersamento value
     * @param int $tipoVersamento
     * @return \Service\StructType\IncassaQuotaAssociativa
     */
    public function setTipoVersamento($tipoVersamento = null)
    {
        // validation for constraint: int
        if (!is_null($tipoVersamento) && !(is_int($tipoVersamento) || ctype_digit($tipoVersamento))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tipoVersamento, true), gettype($tipoVersamento)), __LINE__);
        }
        $this->TipoVersamento = $tipoVersamento;
        return $this;
    }
    /**
     * Get IDAnagrafe value
     * @return int|null
     */
    public function getIDAnagrafe()
    {
        return $this->IDAnagrafe;
    }
    /**
     * Set IDAnagrafe value
     * @param int $iDAnagrafe
     * @return \Service\StructType\IncassaQuotaAssociativa
     */
    public function setIDAnagrafe($iDAnagrafe = null)
    {
        // validation for constraint: int
        if (!is_null($iDAnagrafe) && !(is_int($iDAnagrafe) || ctype_digit($iDAnagrafe))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iDAnagrafe, true), gettype($iDAnagrafe)), __LINE__);
        }
        $this->IDAnagrafe = $iDAnagrafe;
        return $this;
    }
    /**
     * Get Importo value
     * @return float|null
     */
    public function getImporto()
    {
        return $this->Importo;
    }
    /**
     * Set Importo value
     * @param float $importo
     * @return \Service\StructType\IncassaQuotaAssociativa
     */
    public function setImporto($importo = null)
    {
        // validation for constraint: float
        if (!is_null($importo) && !(is_float($importo) || is_numeric($importo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($importo, true), gettype($importo)), __LINE__);
        }
        $this->Importo = $importo;
        return $this;
    }
}
