<?php

namespace Service\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetRichiesteCartellino_Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetRichiesteCartellino_Request
 * @subpackage Structs
 */
class GetRichiesteCartellino_Request extends AbstractStructBase
{
    /**
     * The IDUtente
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Service\StructType\AnagraficaModel_Identificativo
     */
    public $IDUtente;
    /**
     * The LastID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $LastID;
    /**
     * The TopN
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TopN;
    /**
     * Constructor method for GetRichiesteCartellino_Request
     * @uses GetRichiesteCartellino_Request::setIDUtente()
     * @uses GetRichiesteCartellino_Request::setLastID()
     * @uses GetRichiesteCartellino_Request::setTopN()
     * @param \Service\StructType\AnagraficaModel_Identificativo $iDUtente
     * @param int $lastID
     * @param int $topN
     */
    public function __construct(\Service\StructType\AnagraficaModel_Identificativo $iDUtente = null, $lastID = null, $topN = null)
    {
        $this
            ->setIDUtente($iDUtente)
            ->setLastID($lastID)
            ->setTopN($topN);
    }
    /**
     * Get IDUtente value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Service\StructType\AnagraficaModel_Identificativo|null
     */
    public function getIDUtente()
    {
        return isset($this->IDUtente) ? $this->IDUtente : null;
    }
    /**
     * Set IDUtente value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Service\StructType\AnagraficaModel_Identificativo $iDUtente
     * @return \Service\StructType\GetRichiesteCartellino_Request
     */
    public function setIDUtente(\Service\StructType\AnagraficaModel_Identificativo $iDUtente = null)
    {
        if (is_null($iDUtente) || (is_array($iDUtente) && empty($iDUtente))) {
            unset($this->IDUtente);
        } else {
            $this->IDUtente = $iDUtente;
        }
        return $this;
    }
    /**
     * Get LastID value
     * @return int|null
     */
    public function getLastID()
    {
        return $this->LastID;
    }
    /**
     * Set LastID value
     * @param int $lastID
     * @return \Service\StructType\GetRichiesteCartellino_Request
     */
    public function setLastID($lastID = null)
    {
        // validation for constraint: int
        if (!is_null($lastID) && !(is_int($lastID) || ctype_digit($lastID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lastID, true), gettype($lastID)), __LINE__);
        }
        $this->LastID = $lastID;
        return $this;
    }
    /**
     * Get TopN value
     * @return int|null
     */
    public function getTopN()
    {
        return $this->TopN;
    }
    /**
     * Set TopN value
     * @param int $topN
     * @return \Service\StructType\GetRichiesteCartellino_Request
     */
    public function setTopN($topN = null)
    {
        // validation for constraint: int
        if (!is_null($topN) && !(is_int($topN) || ctype_digit($topN))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($topN, true), gettype($topN)), __LINE__);
        }
        $this->TopN = $topN;
        return $this;
    }
}
