<?php

namespace Service\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetMessaggi_Result StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetMessaggi_Result
 * @subpackage Structs
 */
class GetMessaggi_Result extends AbstractStructBase
{
    /**
     * The Informazioni
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Service\StructType\AdditionaInformation
     */
    public $Informazioni;
    /**
     * The Messaggi
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Service\ArrayType\ArrayOfMessaggio
     */
    public $Messaggi;
    /**
     * Constructor method for GetMessaggi_Result
     * @uses GetMessaggi_Result::setInformazioni()
     * @uses GetMessaggi_Result::setMessaggi()
     * @param \Service\StructType\AdditionaInformation $informazioni
     * @param \Service\ArrayType\ArrayOfMessaggio $messaggi
     */
    public function __construct(\Service\StructType\AdditionaInformation $informazioni = null, \Service\ArrayType\ArrayOfMessaggio $messaggi = null)
    {
        $this
            ->setInformazioni($informazioni)
            ->setMessaggi($messaggi);
    }
    /**
     * Get Informazioni value
     * @return \Service\StructType\AdditionaInformation|null
     */
    public function getInformazioni()
    {
        return $this->Informazioni;
    }
    /**
     * Set Informazioni value
     * @param \Service\StructType\AdditionaInformation $informazioni
     * @return \Service\StructType\GetMessaggi_Result
     */
    public function setInformazioni(\Service\StructType\AdditionaInformation $informazioni = null)
    {
        $this->Informazioni = $informazioni;
        return $this;
    }
    /**
     * Get Messaggi value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Service\ArrayType\ArrayOfMessaggio|null
     */
    public function getMessaggi()
    {
        return isset($this->Messaggi) ? $this->Messaggi : null;
    }
    /**
     * Set Messaggi value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Service\ArrayType\ArrayOfMessaggio $messaggi
     * @return \Service\StructType\GetMessaggi_Result
     */
    public function setMessaggi(\Service\ArrayType\ArrayOfMessaggio $messaggi = null)
    {
        if (is_null($messaggi) || (is_array($messaggi) && empty($messaggi))) {
            unset($this->Messaggi);
        } else {
            $this->Messaggi = $messaggi;
        }
        return $this;
    }
}
