<?php

namespace Service\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeleteRecapito StructType
 * @subpackage Structs
 */
class DeleteRecapito extends AbstractStructBase
{
    /**
     * The IDAnagrafe
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IDAnagrafe;
    /**
     * The IDRecapito
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IDRecapito;
    /**
     * Constructor method for DeleteRecapito
     * @uses DeleteRecapito::setIDAnagrafe()
     * @uses DeleteRecapito::setIDRecapito()
     * @param int $iDAnagrafe
     * @param int $iDRecapito
     */
    public function __construct($iDAnagrafe = null, $iDRecapito = null)
    {
        $this
            ->setIDAnagrafe($iDAnagrafe)
            ->setIDRecapito($iDRecapito);
    }
    /**
     * Get IDAnagrafe value
     * @return int|null
     */
    public function getIDAnagrafe()
    {
        return $this->IDAnagrafe;
    }
    /**
     * Set IDAnagrafe value
     * @param int $iDAnagrafe
     * @return \Service\StructType\DeleteRecapito
     */
    public function setIDAnagrafe($iDAnagrafe = null)
    {
        // validation for constraint: int
        if (!is_null($iDAnagrafe) && !(is_int($iDAnagrafe) || ctype_digit($iDAnagrafe))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iDAnagrafe, true), gettype($iDAnagrafe)), __LINE__);
        }
        $this->IDAnagrafe = $iDAnagrafe;
        return $this;
    }
    /**
     * Get IDRecapito value
     * @return int|null
     */
    public function getIDRecapito()
    {
        return $this->IDRecapito;
    }
    /**
     * Set IDRecapito value
     * @param int $iDRecapito
     * @return \Service\StructType\DeleteRecapito
     */
    public function setIDRecapito($iDRecapito = null)
    {
        // validation for constraint: int
        if (!is_null($iDRecapito) && !(is_int($iDRecapito) || ctype_digit($iDRecapito))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iDRecapito, true), gettype($iDRecapito)), __LINE__);
        }
        $this->IDRecapito = $iDRecapito;
        return $this;
    }
}
