<?php

namespace Service\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConfigurazioneBase StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ConfigurazioneBase
 * @subpackage Structs
 */
class ConfigurazioneBase extends AbstractStructBase
{
    /**
     * The AbilitaRichiestaTS
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $AbilitaRichiestaTS;
    /**
     * The CARTELLINO_AbilitaRichieste
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $CARTELLINO_AbilitaRichieste;
    /**
     * The CORSI_AbilitaIscrizione
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $CORSI_AbilitaIscrizione;
    /**
     * The CORSI_VisualizzaCorsiNONVolontari
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $CORSI_VisualizzaCorsiNONVolontari;
    /**
     * The CORSI_VisualizzaCorsiVolontari
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $CORSI_VisualizzaCorsiVolontari;
    /**
     * The CORSI_VisualizzaEventi
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $CORSI_VisualizzaEventi;
    /**
     * The LOGIN_AbilitaIscrizione
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $LOGIN_AbilitaIscrizione;
    /**
     * The LOGIN_AbilitaIscrizioneComeSocio
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $LOGIN_AbilitaIscrizioneComeSocio;
    /**
     * The LOGIN_Etichetta
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LOGIN_Etichetta;
    /**
     * The LOGIN_RichiediConfermaDatiAccesso
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $LOGIN_RichiediConfermaDatiAccesso;
    /**
     * The MessaggioCheckListFallita
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MessaggioCheckListFallita;
    /**
     * The MessaggioDiBenvenuto
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MessaggioDiBenvenuto;
    /**
     * The PRESENZE_EtichettaCodice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PRESENZE_EtichettaCodice;
    /**
     * The PRESENZE_LunghezzaCodice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PRESENZE_LunghezzaCodice;
    /**
     * The PRESENZE_PrefissoCodice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PRESENZE_PrefissoCodice;
    /**
     * The PRESENZE_RichiestaCheckList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $PRESENZE_RichiestaCheckList;
    /**
     * The PRESENZE_RichiestaGreenPass
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $PRESENZE_RichiestaGreenPass;
    /**
     * The PRESENZE_RichiestaMansione
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $PRESENZE_RichiestaMansione;
    /**
     * The PRESENZE_TipoCodice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PRESENZE_TipoCodice;
    /**
     * The TURNI_MostraPresenzaOperatori
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $TURNI_MostraPresenzaOperatori;
    /**
     * Constructor method for ConfigurazioneBase
     * @uses ConfigurazioneBase::setAbilitaRichiestaTS()
     * @uses ConfigurazioneBase::setCARTELLINO_AbilitaRichieste()
     * @uses ConfigurazioneBase::setCORSI_AbilitaIscrizione()
     * @uses ConfigurazioneBase::setCORSI_VisualizzaCorsiNONVolontari()
     * @uses ConfigurazioneBase::setCORSI_VisualizzaCorsiVolontari()
     * @uses ConfigurazioneBase::setCORSI_VisualizzaEventi()
     * @uses ConfigurazioneBase::setLOGIN_AbilitaIscrizione()
     * @uses ConfigurazioneBase::setLOGIN_AbilitaIscrizioneComeSocio()
     * @uses ConfigurazioneBase::setLOGIN_Etichetta()
     * @uses ConfigurazioneBase::setLOGIN_RichiediConfermaDatiAccesso()
     * @uses ConfigurazioneBase::setMessaggioCheckListFallita()
     * @uses ConfigurazioneBase::setMessaggioDiBenvenuto()
     * @uses ConfigurazioneBase::setPRESENZE_EtichettaCodice()
     * @uses ConfigurazioneBase::setPRESENZE_LunghezzaCodice()
     * @uses ConfigurazioneBase::setPRESENZE_PrefissoCodice()
     * @uses ConfigurazioneBase::setPRESENZE_RichiestaCheckList()
     * @uses ConfigurazioneBase::setPRESENZE_RichiestaGreenPass()
     * @uses ConfigurazioneBase::setPRESENZE_RichiestaMansione()
     * @uses ConfigurazioneBase::setPRESENZE_TipoCodice()
     * @uses ConfigurazioneBase::setTURNI_MostraPresenzaOperatori()
     * @param bool $abilitaRichiestaTS
     * @param bool $cARTELLINO_AbilitaRichieste
     * @param bool $cORSI_AbilitaIscrizione
     * @param bool $cORSI_VisualizzaCorsiNONVolontari
     * @param bool $cORSI_VisualizzaCorsiVolontari
     * @param bool $cORSI_VisualizzaEventi
     * @param bool $lOGIN_AbilitaIscrizione
     * @param bool $lOGIN_AbilitaIscrizioneComeSocio
     * @param string $lOGIN_Etichetta
     * @param bool $lOGIN_RichiediConfermaDatiAccesso
     * @param string $messaggioCheckListFallita
     * @param string $messaggioDiBenvenuto
     * @param string $pRESENZE_EtichettaCodice
     * @param int $pRESENZE_LunghezzaCodice
     * @param int $pRESENZE_PrefissoCodice
     * @param bool $pRESENZE_RichiestaCheckList
     * @param bool $pRESENZE_RichiestaGreenPass
     * @param bool $pRESENZE_RichiestaMansione
     * @param string $pRESENZE_TipoCodice
     * @param bool $tURNI_MostraPresenzaOperatori
     */
    public function __construct($abilitaRichiestaTS = null, $cARTELLINO_AbilitaRichieste = null, $cORSI_AbilitaIscrizione = null, $cORSI_VisualizzaCorsiNONVolontari = null, $cORSI_VisualizzaCorsiVolontari = null, $cORSI_VisualizzaEventi = null, $lOGIN_AbilitaIscrizione = null, $lOGIN_AbilitaIscrizioneComeSocio = null, $lOGIN_Etichetta = null, $lOGIN_RichiediConfermaDatiAccesso = null, $messaggioCheckListFallita = null, $messaggioDiBenvenuto = null, $pRESENZE_EtichettaCodice = null, $pRESENZE_LunghezzaCodice = null, $pRESENZE_PrefissoCodice = null, $pRESENZE_RichiestaCheckList = null, $pRESENZE_RichiestaGreenPass = null, $pRESENZE_RichiestaMansione = null, $pRESENZE_TipoCodice = null, $tURNI_MostraPresenzaOperatori = null)
    {
        $this
            ->setAbilitaRichiestaTS($abilitaRichiestaTS)
            ->setCARTELLINO_AbilitaRichieste($cARTELLINO_AbilitaRichieste)
            ->setCORSI_AbilitaIscrizione($cORSI_AbilitaIscrizione)
            ->setCORSI_VisualizzaCorsiNONVolontari($cORSI_VisualizzaCorsiNONVolontari)
            ->setCORSI_VisualizzaCorsiVolontari($cORSI_VisualizzaCorsiVolontari)
            ->setCORSI_VisualizzaEventi($cORSI_VisualizzaEventi)
            ->setLOGIN_AbilitaIscrizione($lOGIN_AbilitaIscrizione)
            ->setLOGIN_AbilitaIscrizioneComeSocio($lOGIN_AbilitaIscrizioneComeSocio)
            ->setLOGIN_Etichetta($lOGIN_Etichetta)
            ->setLOGIN_RichiediConfermaDatiAccesso($lOGIN_RichiediConfermaDatiAccesso)
            ->setMessaggioCheckListFallita($messaggioCheckListFallita)
            ->setMessaggioDiBenvenuto($messaggioDiBenvenuto)
            ->setPRESENZE_EtichettaCodice($pRESENZE_EtichettaCodice)
            ->setPRESENZE_LunghezzaCodice($pRESENZE_LunghezzaCodice)
            ->setPRESENZE_PrefissoCodice($pRESENZE_PrefissoCodice)
            ->setPRESENZE_RichiestaCheckList($pRESENZE_RichiestaCheckList)
            ->setPRESENZE_RichiestaGreenPass($pRESENZE_RichiestaGreenPass)
            ->setPRESENZE_RichiestaMansione($pRESENZE_RichiestaMansione)
            ->setPRESENZE_TipoCodice($pRESENZE_TipoCodice)
            ->setTURNI_MostraPresenzaOperatori($tURNI_MostraPresenzaOperatori);
    }
    /**
     * Get AbilitaRichiestaTS value
     * @return bool|null
     */
    public function getAbilitaRichiestaTS()
    {
        return $this->AbilitaRichiestaTS;
    }
    /**
     * Set AbilitaRichiestaTS value
     * @param bool $abilitaRichiestaTS
     * @return \Service\StructType\ConfigurazioneBase
     */
    public function setAbilitaRichiestaTS($abilitaRichiestaTS = null)
    {
        // validation for constraint: boolean
        if (!is_null($abilitaRichiestaTS) && !is_bool($abilitaRichiestaTS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($abilitaRichiestaTS, true), gettype($abilitaRichiestaTS)), __LINE__);
        }
        $this->AbilitaRichiestaTS = $abilitaRichiestaTS;
        return $this;
    }
    /**
     * Get CARTELLINO_AbilitaRichieste value
     * @return bool|null
     */
    public function getCARTELLINO_AbilitaRichieste()
    {
        return $this->CARTELLINO_AbilitaRichieste;
    }
    /**
     * Set CARTELLINO_AbilitaRichieste value
     * @param bool $cARTELLINO_AbilitaRichieste
     * @return \Service\StructType\ConfigurazioneBase
     */
    public function setCARTELLINO_AbilitaRichieste($cARTELLINO_AbilitaRichieste = null)
    {
        // validation for constraint: boolean
        if (!is_null($cARTELLINO_AbilitaRichieste) && !is_bool($cARTELLINO_AbilitaRichieste)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($cARTELLINO_AbilitaRichieste, true), gettype($cARTELLINO_AbilitaRichieste)), __LINE__);
        }
        $this->CARTELLINO_AbilitaRichieste = $cARTELLINO_AbilitaRichieste;
        return $this;
    }
    /**
     * Get CORSI_AbilitaIscrizione value
     * @return bool|null
     */
    public function getCORSI_AbilitaIscrizione()
    {
        return $this->CORSI_AbilitaIscrizione;
    }
    /**
     * Set CORSI_AbilitaIscrizione value
     * @param bool $cORSI_AbilitaIscrizione
     * @return \Service\StructType\ConfigurazioneBase
     */
    public function setCORSI_AbilitaIscrizione($cORSI_AbilitaIscrizione = null)
    {
        // validation for constraint: boolean
        if (!is_null($cORSI_AbilitaIscrizione) && !is_bool($cORSI_AbilitaIscrizione)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($cORSI_AbilitaIscrizione, true), gettype($cORSI_AbilitaIscrizione)), __LINE__);
        }
        $this->CORSI_AbilitaIscrizione = $cORSI_AbilitaIscrizione;
        return $this;
    }
    /**
     * Get CORSI_VisualizzaCorsiNONVolontari value
     * @return bool|null
     */
    public function getCORSI_VisualizzaCorsiNONVolontari()
    {
        return $this->CORSI_VisualizzaCorsiNONVolontari;
    }
    /**
     * Set CORSI_VisualizzaCorsiNONVolontari value
     * @param bool $cORSI_VisualizzaCorsiNONVolontari
     * @return \Service\StructType\ConfigurazioneBase
     */
    public function setCORSI_VisualizzaCorsiNONVolontari($cORSI_VisualizzaCorsiNONVolontari = null)
    {
        // validation for constraint: boolean
        if (!is_null($cORSI_VisualizzaCorsiNONVolontari) && !is_bool($cORSI_VisualizzaCorsiNONVolontari)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($cORSI_VisualizzaCorsiNONVolontari, true), gettype($cORSI_VisualizzaCorsiNONVolontari)), __LINE__);
        }
        $this->CORSI_VisualizzaCorsiNONVolontari = $cORSI_VisualizzaCorsiNONVolontari;
        return $this;
    }
    /**
     * Get CORSI_VisualizzaCorsiVolontari value
     * @return bool|null
     */
    public function getCORSI_VisualizzaCorsiVolontari()
    {
        return $this->CORSI_VisualizzaCorsiVolontari;
    }
    /**
     * Set CORSI_VisualizzaCorsiVolontari value
     * @param bool $cORSI_VisualizzaCorsiVolontari
     * @return \Service\StructType\ConfigurazioneBase
     */
    public function setCORSI_VisualizzaCorsiVolontari($cORSI_VisualizzaCorsiVolontari = null)
    {
        // validation for constraint: boolean
        if (!is_null($cORSI_VisualizzaCorsiVolontari) && !is_bool($cORSI_VisualizzaCorsiVolontari)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($cORSI_VisualizzaCorsiVolontari, true), gettype($cORSI_VisualizzaCorsiVolontari)), __LINE__);
        }
        $this->CORSI_VisualizzaCorsiVolontari = $cORSI_VisualizzaCorsiVolontari;
        return $this;
    }
    /**
     * Get CORSI_VisualizzaEventi value
     * @return bool|null
     */
    public function getCORSI_VisualizzaEventi()
    {
        return $this->CORSI_VisualizzaEventi;
    }
    /**
     * Set CORSI_VisualizzaEventi value
     * @param bool $cORSI_VisualizzaEventi
     * @return \Service\StructType\ConfigurazioneBase
     */
    public function setCORSI_VisualizzaEventi($cORSI_VisualizzaEventi = null)
    {
        // validation for constraint: boolean
        if (!is_null($cORSI_VisualizzaEventi) && !is_bool($cORSI_VisualizzaEventi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($cORSI_VisualizzaEventi, true), gettype($cORSI_VisualizzaEventi)), __LINE__);
        }
        $this->CORSI_VisualizzaEventi = $cORSI_VisualizzaEventi;
        return $this;
    }
    /**
     * Get LOGIN_AbilitaIscrizione value
     * @return bool|null
     */
    public function getLOGIN_AbilitaIscrizione()
    {
        return $this->LOGIN_AbilitaIscrizione;
    }
    /**
     * Set LOGIN_AbilitaIscrizione value
     * @param bool $lOGIN_AbilitaIscrizione
     * @return \Service\StructType\ConfigurazioneBase
     */
    public function setLOGIN_AbilitaIscrizione($lOGIN_AbilitaIscrizione = null)
    {
        // validation for constraint: boolean
        if (!is_null($lOGIN_AbilitaIscrizione) && !is_bool($lOGIN_AbilitaIscrizione)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($lOGIN_AbilitaIscrizione, true), gettype($lOGIN_AbilitaIscrizione)), __LINE__);
        }
        $this->LOGIN_AbilitaIscrizione = $lOGIN_AbilitaIscrizione;
        return $this;
    }
    /**
     * Get LOGIN_AbilitaIscrizioneComeSocio value
     * @return bool|null
     */
    public function getLOGIN_AbilitaIscrizioneComeSocio()
    {
        return $this->LOGIN_AbilitaIscrizioneComeSocio;
    }
    /**
     * Set LOGIN_AbilitaIscrizioneComeSocio value
     * @param bool $lOGIN_AbilitaIscrizioneComeSocio
     * @return \Service\StructType\ConfigurazioneBase
     */
    public function setLOGIN_AbilitaIscrizioneComeSocio($lOGIN_AbilitaIscrizioneComeSocio = null)
    {
        // validation for constraint: boolean
        if (!is_null($lOGIN_AbilitaIscrizioneComeSocio) && !is_bool($lOGIN_AbilitaIscrizioneComeSocio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($lOGIN_AbilitaIscrizioneComeSocio, true), gettype($lOGIN_AbilitaIscrizioneComeSocio)), __LINE__);
        }
        $this->LOGIN_AbilitaIscrizioneComeSocio = $lOGIN_AbilitaIscrizioneComeSocio;
        return $this;
    }
    /**
     * Get LOGIN_Etichetta value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLOGIN_Etichetta()
    {
        return isset($this->LOGIN_Etichetta) ? $this->LOGIN_Etichetta : null;
    }
    /**
     * Set LOGIN_Etichetta value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lOGIN_Etichetta
     * @return \Service\StructType\ConfigurazioneBase
     */
    public function setLOGIN_Etichetta($lOGIN_Etichetta = null)
    {
        // validation for constraint: string
        if (!is_null($lOGIN_Etichetta) && !is_string($lOGIN_Etichetta)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lOGIN_Etichetta, true), gettype($lOGIN_Etichetta)), __LINE__);
        }
        if (is_null($lOGIN_Etichetta) || (is_array($lOGIN_Etichetta) && empty($lOGIN_Etichetta))) {
            unset($this->LOGIN_Etichetta);
        } else {
            $this->LOGIN_Etichetta = $lOGIN_Etichetta;
        }
        return $this;
    }
    /**
     * Get LOGIN_RichiediConfermaDatiAccesso value
     * @return bool|null
     */
    public function getLOGIN_RichiediConfermaDatiAccesso()
    {
        return $this->LOGIN_RichiediConfermaDatiAccesso;
    }
    /**
     * Set LOGIN_RichiediConfermaDatiAccesso value
     * @param bool $lOGIN_RichiediConfermaDatiAccesso
     * @return \Service\StructType\ConfigurazioneBase
     */
    public function setLOGIN_RichiediConfermaDatiAccesso($lOGIN_RichiediConfermaDatiAccesso = null)
    {
        // validation for constraint: boolean
        if (!is_null($lOGIN_RichiediConfermaDatiAccesso) && !is_bool($lOGIN_RichiediConfermaDatiAccesso)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($lOGIN_RichiediConfermaDatiAccesso, true), gettype($lOGIN_RichiediConfermaDatiAccesso)), __LINE__);
        }
        $this->LOGIN_RichiediConfermaDatiAccesso = $lOGIN_RichiediConfermaDatiAccesso;
        return $this;
    }
    /**
     * Get MessaggioCheckListFallita value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMessaggioCheckListFallita()
    {
        return isset($this->MessaggioCheckListFallita) ? $this->MessaggioCheckListFallita : null;
    }
    /**
     * Set MessaggioCheckListFallita value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $messaggioCheckListFallita
     * @return \Service\StructType\ConfigurazioneBase
     */
    public function setMessaggioCheckListFallita($messaggioCheckListFallita = null)
    {
        // validation for constraint: string
        if (!is_null($messaggioCheckListFallita) && !is_string($messaggioCheckListFallita)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($messaggioCheckListFallita, true), gettype($messaggioCheckListFallita)), __LINE__);
        }
        if (is_null($messaggioCheckListFallita) || (is_array($messaggioCheckListFallita) && empty($messaggioCheckListFallita))) {
            unset($this->MessaggioCheckListFallita);
        } else {
            $this->MessaggioCheckListFallita = $messaggioCheckListFallita;
        }
        return $this;
    }
    /**
     * Get MessaggioDiBenvenuto value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMessaggioDiBenvenuto()
    {
        return isset($this->MessaggioDiBenvenuto) ? $this->MessaggioDiBenvenuto : null;
    }
    /**
     * Set MessaggioDiBenvenuto value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $messaggioDiBenvenuto
     * @return \Service\StructType\ConfigurazioneBase
     */
    public function setMessaggioDiBenvenuto($messaggioDiBenvenuto = null)
    {
        // validation for constraint: string
        if (!is_null($messaggioDiBenvenuto) && !is_string($messaggioDiBenvenuto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($messaggioDiBenvenuto, true), gettype($messaggioDiBenvenuto)), __LINE__);
        }
        if (is_null($messaggioDiBenvenuto) || (is_array($messaggioDiBenvenuto) && empty($messaggioDiBenvenuto))) {
            unset($this->MessaggioDiBenvenuto);
        } else {
            $this->MessaggioDiBenvenuto = $messaggioDiBenvenuto;
        }
        return $this;
    }
    /**
     * Get PRESENZE_EtichettaCodice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPRESENZE_EtichettaCodice()
    {
        return isset($this->PRESENZE_EtichettaCodice) ? $this->PRESENZE_EtichettaCodice : null;
    }
    /**
     * Set PRESENZE_EtichettaCodice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pRESENZE_EtichettaCodice
     * @return \Service\StructType\ConfigurazioneBase
     */
    public function setPRESENZE_EtichettaCodice($pRESENZE_EtichettaCodice = null)
    {
        // validation for constraint: string
        if (!is_null($pRESENZE_EtichettaCodice) && !is_string($pRESENZE_EtichettaCodice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pRESENZE_EtichettaCodice, true), gettype($pRESENZE_EtichettaCodice)), __LINE__);
        }
        if (is_null($pRESENZE_EtichettaCodice) || (is_array($pRESENZE_EtichettaCodice) && empty($pRESENZE_EtichettaCodice))) {
            unset($this->PRESENZE_EtichettaCodice);
        } else {
            $this->PRESENZE_EtichettaCodice = $pRESENZE_EtichettaCodice;
        }
        return $this;
    }
    /**
     * Get PRESENZE_LunghezzaCodice value
     * @return int|null
     */
    public function getPRESENZE_LunghezzaCodice()
    {
        return $this->PRESENZE_LunghezzaCodice;
    }
    /**
     * Set PRESENZE_LunghezzaCodice value
     * @param int $pRESENZE_LunghezzaCodice
     * @return \Service\StructType\ConfigurazioneBase
     */
    public function setPRESENZE_LunghezzaCodice($pRESENZE_LunghezzaCodice = null)
    {
        // validation for constraint: int
        if (!is_null($pRESENZE_LunghezzaCodice) && !(is_int($pRESENZE_LunghezzaCodice) || ctype_digit($pRESENZE_LunghezzaCodice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pRESENZE_LunghezzaCodice, true), gettype($pRESENZE_LunghezzaCodice)), __LINE__);
        }
        $this->PRESENZE_LunghezzaCodice = $pRESENZE_LunghezzaCodice;
        return $this;
    }
    /**
     * Get PRESENZE_PrefissoCodice value
     * @return int|null
     */
    public function getPRESENZE_PrefissoCodice()
    {
        return $this->PRESENZE_PrefissoCodice;
    }
    /**
     * Set PRESENZE_PrefissoCodice value
     * @param int $pRESENZE_PrefissoCodice
     * @return \Service\StructType\ConfigurazioneBase
     */
    public function setPRESENZE_PrefissoCodice($pRESENZE_PrefissoCodice = null)
    {
        // validation for constraint: int
        if (!is_null($pRESENZE_PrefissoCodice) && !(is_int($pRESENZE_PrefissoCodice) || ctype_digit($pRESENZE_PrefissoCodice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pRESENZE_PrefissoCodice, true), gettype($pRESENZE_PrefissoCodice)), __LINE__);
        }
        $this->PRESENZE_PrefissoCodice = $pRESENZE_PrefissoCodice;
        return $this;
    }
    /**
     * Get PRESENZE_RichiestaCheckList value
     * @return bool|null
     */
    public function getPRESENZE_RichiestaCheckList()
    {
        return $this->PRESENZE_RichiestaCheckList;
    }
    /**
     * Set PRESENZE_RichiestaCheckList value
     * @param bool $pRESENZE_RichiestaCheckList
     * @return \Service\StructType\ConfigurazioneBase
     */
    public function setPRESENZE_RichiestaCheckList($pRESENZE_RichiestaCheckList = null)
    {
        // validation for constraint: boolean
        if (!is_null($pRESENZE_RichiestaCheckList) && !is_bool($pRESENZE_RichiestaCheckList)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($pRESENZE_RichiestaCheckList, true), gettype($pRESENZE_RichiestaCheckList)), __LINE__);
        }
        $this->PRESENZE_RichiestaCheckList = $pRESENZE_RichiestaCheckList;
        return $this;
    }
    /**
     * Get PRESENZE_RichiestaGreenPass value
     * @return bool|null
     */
    public function getPRESENZE_RichiestaGreenPass()
    {
        return $this->PRESENZE_RichiestaGreenPass;
    }
    /**
     * Set PRESENZE_RichiestaGreenPass value
     * @param bool $pRESENZE_RichiestaGreenPass
     * @return \Service\StructType\ConfigurazioneBase
     */
    public function setPRESENZE_RichiestaGreenPass($pRESENZE_RichiestaGreenPass = null)
    {
        // validation for constraint: boolean
        if (!is_null($pRESENZE_RichiestaGreenPass) && !is_bool($pRESENZE_RichiestaGreenPass)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($pRESENZE_RichiestaGreenPass, true), gettype($pRESENZE_RichiestaGreenPass)), __LINE__);
        }
        $this->PRESENZE_RichiestaGreenPass = $pRESENZE_RichiestaGreenPass;
        return $this;
    }
    /**
     * Get PRESENZE_RichiestaMansione value
     * @return bool|null
     */
    public function getPRESENZE_RichiestaMansione()
    {
        return $this->PRESENZE_RichiestaMansione;
    }
    /**
     * Set PRESENZE_RichiestaMansione value
     * @param bool $pRESENZE_RichiestaMansione
     * @return \Service\StructType\ConfigurazioneBase
     */
    public function setPRESENZE_RichiestaMansione($pRESENZE_RichiestaMansione = null)
    {
        // validation for constraint: boolean
        if (!is_null($pRESENZE_RichiestaMansione) && !is_bool($pRESENZE_RichiestaMansione)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($pRESENZE_RichiestaMansione, true), gettype($pRESENZE_RichiestaMansione)), __LINE__);
        }
        $this->PRESENZE_RichiestaMansione = $pRESENZE_RichiestaMansione;
        return $this;
    }
    /**
     * Get PRESENZE_TipoCodice value
     * @return string|null
     */
    public function getPRESENZE_TipoCodice()
    {
        return $this->PRESENZE_TipoCodice;
    }
    /**
     * Set PRESENZE_TipoCodice value
     * @uses \Service\EnumType\PRESENZE_TipiCodice::valueIsValid()
     * @uses \Service\EnumType\PRESENZE_TipiCodice::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $pRESENZE_TipoCodice
     * @return \Service\StructType\ConfigurazioneBase
     */
    public function setPRESENZE_TipoCodice($pRESENZE_TipoCodice = null)
    {
        // validation for constraint: enumeration
        if (!\Service\EnumType\PRESENZE_TipiCodice::valueIsValid($pRESENZE_TipoCodice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Service\EnumType\PRESENZE_TipiCodice', is_array($pRESENZE_TipoCodice) ? implode(', ', $pRESENZE_TipoCodice) : var_export($pRESENZE_TipoCodice, true), implode(', ', \Service\EnumType\PRESENZE_TipiCodice::getValidValues())), __LINE__);
        }
        $this->PRESENZE_TipoCodice = $pRESENZE_TipoCodice;
        return $this;
    }
    /**
     * Get TURNI_MostraPresenzaOperatori value
     * @return bool|null
     */
    public function getTURNI_MostraPresenzaOperatori()
    {
        return $this->TURNI_MostraPresenzaOperatori;
    }
    /**
     * Set TURNI_MostraPresenzaOperatori value
     * @param bool $tURNI_MostraPresenzaOperatori
     * @return \Service\StructType\ConfigurazioneBase
     */
    public function setTURNI_MostraPresenzaOperatori($tURNI_MostraPresenzaOperatori = null)
    {
        // validation for constraint: boolean
        if (!is_null($tURNI_MostraPresenzaOperatori) && !is_bool($tURNI_MostraPresenzaOperatori)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($tURNI_MostraPresenzaOperatori, true), gettype($tURNI_MostraPresenzaOperatori)), __LINE__);
        }
        $this->TURNI_MostraPresenzaOperatori = $tURNI_MostraPresenzaOperatori;
        return $this;
    }
}
