<?php

namespace Service\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AnagraficaModel StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AnagraficaModel
 * @subpackage Structs
 */
class AnagraficaModel extends AbstractStructBase
{
    /**
     * The Cognome
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Cognome;
    /**
     * The DataDiNascita
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DataDiNascita;
    /**
     * The Identificativo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Service\StructType\AnagraficaModel_Identificativo
     */
    public $Identificativo;
    /**
     * The Nome
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Nome;
    /**
     * The Sesso
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Sesso;
    /**
     * Constructor method for AnagraficaModel
     * @uses AnagraficaModel::setCognome()
     * @uses AnagraficaModel::setDataDiNascita()
     * @uses AnagraficaModel::setIdentificativo()
     * @uses AnagraficaModel::setNome()
     * @uses AnagraficaModel::setSesso()
     * @param string $cognome
     * @param string $dataDiNascita
     * @param \Service\StructType\AnagraficaModel_Identificativo $identificativo
     * @param string $nome
     * @param string $sesso
     */
    public function __construct($cognome = null, $dataDiNascita = null, \Service\StructType\AnagraficaModel_Identificativo $identificativo = null, $nome = null, $sesso = null)
    {
        $this
            ->setCognome($cognome)
            ->setDataDiNascita($dataDiNascita)
            ->setIdentificativo($identificativo)
            ->setNome($nome)
            ->setSesso($sesso);
    }
    /**
     * Get Cognome value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCognome()
    {
        return isset($this->Cognome) ? $this->Cognome : null;
    }
    /**
     * Set Cognome value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cognome
     * @return \Service\StructType\AnagraficaModel
     */
    public function setCognome($cognome = null)
    {
        // validation for constraint: string
        if (!is_null($cognome) && !is_string($cognome)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cognome, true), gettype($cognome)), __LINE__);
        }
        if (is_null($cognome) || (is_array($cognome) && empty($cognome))) {
            unset($this->Cognome);
        } else {
            $this->Cognome = $cognome;
        }
        return $this;
    }
    /**
     * Get DataDiNascita value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDataDiNascita()
    {
        return isset($this->DataDiNascita) ? $this->DataDiNascita : null;
    }
    /**
     * Set DataDiNascita value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dataDiNascita
     * @return \Service\StructType\AnagraficaModel
     */
    public function setDataDiNascita($dataDiNascita = null)
    {
        // validation for constraint: string
        if (!is_null($dataDiNascita) && !is_string($dataDiNascita)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataDiNascita, true), gettype($dataDiNascita)), __LINE__);
        }
        if (is_null($dataDiNascita) || (is_array($dataDiNascita) && empty($dataDiNascita))) {
            unset($this->DataDiNascita);
        } else {
            $this->DataDiNascita = $dataDiNascita;
        }
        return $this;
    }
    /**
     * Get Identificativo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Service\StructType\AnagraficaModel_Identificativo|null
     */
    public function getIdentificativo()
    {
        return isset($this->Identificativo) ? $this->Identificativo : null;
    }
    /**
     * Set Identificativo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Service\StructType\AnagraficaModel_Identificativo $identificativo
     * @return \Service\StructType\AnagraficaModel
     */
    public function setIdentificativo(\Service\StructType\AnagraficaModel_Identificativo $identificativo = null)
    {
        if (is_null($identificativo) || (is_array($identificativo) && empty($identificativo))) {
            unset($this->Identificativo);
        } else {
            $this->Identificativo = $identificativo;
        }
        return $this;
    }
    /**
     * Get Nome value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNome()
    {
        return isset($this->Nome) ? $this->Nome : null;
    }
    /**
     * Set Nome value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nome
     * @return \Service\StructType\AnagraficaModel
     */
    public function setNome($nome = null)
    {
        // validation for constraint: string
        if (!is_null($nome) && !is_string($nome)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nome, true), gettype($nome)), __LINE__);
        }
        if (is_null($nome) || (is_array($nome) && empty($nome))) {
            unset($this->Nome);
        } else {
            $this->Nome = $nome;
        }
        return $this;
    }
    /**
     * Get Sesso value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSesso()
    {
        return isset($this->Sesso) ? $this->Sesso : null;
    }
    /**
     * Set Sesso value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sesso
     * @return \Service\StructType\AnagraficaModel
     */
    public function setSesso($sesso = null)
    {
        // validation for constraint: string
        if (!is_null($sesso) && !is_string($sesso)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sesso, true), gettype($sesso)), __LINE__);
        }
        if (is_null($sesso) || (is_array($sesso) && empty($sesso))) {
            unset($this->Sesso);
        } else {
            $this->Sesso = $sesso;
        }
        return $this;
    }
}
