<?php

namespace Service\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SalvaRecapito StructType
 * @subpackage Structs
 */
class SalvaRecapito extends AbstractStructBase
{
    /**
     * The IDAnagrafe
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IDAnagrafe;
    /**
     * The Recapito
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Service\StructType\Recapito_Model
     */
    public $Recapito;
    /**
     * Constructor method for SalvaRecapito
     * @uses SalvaRecapito::setIDAnagrafe()
     * @uses SalvaRecapito::setRecapito()
     * @param int $iDAnagrafe
     * @param \Service\StructType\Recapito_Model $recapito
     */
    public function __construct($iDAnagrafe = null, \Service\StructType\Recapito_Model $recapito = null)
    {
        $this
            ->setIDAnagrafe($iDAnagrafe)
            ->setRecapito($recapito);
    }
    /**
     * Get IDAnagrafe value
     * @return int|null
     */
    public function getIDAnagrafe()
    {
        return $this->IDAnagrafe;
    }
    /**
     * Set IDAnagrafe value
     * @param int $iDAnagrafe
     * @return \Service\StructType\SalvaRecapito
     */
    public function setIDAnagrafe($iDAnagrafe = null)
    {
        // validation for constraint: int
        if (!is_null($iDAnagrafe) && !(is_int($iDAnagrafe) || ctype_digit($iDAnagrafe))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iDAnagrafe, true), gettype($iDAnagrafe)), __LINE__);
        }
        $this->IDAnagrafe = $iDAnagrafe;
        return $this;
    }
    /**
     * Get Recapito value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Service\StructType\Recapito_Model|null
     */
    public function getRecapito()
    {
        return isset($this->Recapito) ? $this->Recapito : null;
    }
    /**
     * Set Recapito value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Service\StructType\Recapito_Model $recapito
     * @return \Service\StructType\SalvaRecapito
     */
    public function setRecapito(\Service\StructType\Recapito_Model $recapito = null)
    {
        if (is_null($recapito) || (is_array($recapito) && empty($recapito))) {
            unset($this->Recapito);
        } else {
            $this->Recapito = $recapito;
        }
        return $this;
    }
}
