<?php

namespace Service\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Corso StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Corso
 * @subpackage Structs
 */
class Corso extends AbstractStructBase
{
    /**
     * The Annotazioni
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Annotazioni;
    /**
     * The AnnotazioniTestata
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AnnotazioniTestata;
    /**
     * The Annotazioni_Iscrizione
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Annotazioni_Iscrizione;
    /**
     * The Categoria_Descrizione
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Categoria_Descrizione;
    /**
     * The Codice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Codice;
    /**
     * The Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Data;
    /**
     * The Data_Iscrizione
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Data_Iscrizione;
    /**
     * The Esercizio
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Esercizio;
    /**
     * The Numeratore
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Numeratore;
    /**
     * The Numero
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Numero;
    /**
     * The NumeroIscritti
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NumeroIscritti;
    /**
     * The NumeroMassimoIscritti
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NumeroMassimoIscritti;
    /**
     * The OraFine
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OraFine;
    /**
     * The OraInizio
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OraInizio;
    /**
     * The Riga
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Riga;
    /**
     * The Titolo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Titolo;
    /**
     * The TitoloTestata
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TitoloTestata;
    /**
     * The Visibilita
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Visibilita;
    /**
     * Constructor method for Corso
     * @uses Corso::setAnnotazioni()
     * @uses Corso::setAnnotazioniTestata()
     * @uses Corso::setAnnotazioni_Iscrizione()
     * @uses Corso::setCategoria_Descrizione()
     * @uses Corso::setCodice()
     * @uses Corso::setData()
     * @uses Corso::setData_Iscrizione()
     * @uses Corso::setEsercizio()
     * @uses Corso::setNumeratore()
     * @uses Corso::setNumero()
     * @uses Corso::setNumeroIscritti()
     * @uses Corso::setNumeroMassimoIscritti()
     * @uses Corso::setOraFine()
     * @uses Corso::setOraInizio()
     * @uses Corso::setRiga()
     * @uses Corso::setTitolo()
     * @uses Corso::setTitoloTestata()
     * @uses Corso::setVisibilita()
     * @param string $annotazioni
     * @param string $annotazioniTestata
     * @param string $annotazioni_Iscrizione
     * @param string $categoria_Descrizione
     * @param int $codice
     * @param string $data
     * @param string $data_Iscrizione
     * @param string $esercizio
     * @param string $numeratore
     * @param int $numero
     * @param int $numeroIscritti
     * @param int $numeroMassimoIscritti
     * @param string $oraFine
     * @param string $oraInizio
     * @param int $riga
     * @param string $titolo
     * @param string $titoloTestata
     * @param int $visibilita
     */
    public function __construct($annotazioni = null, $annotazioniTestata = null, $annotazioni_Iscrizione = null, $categoria_Descrizione = null, $codice = null, $data = null, $data_Iscrizione = null, $esercizio = null, $numeratore = null, $numero = null, $numeroIscritti = null, $numeroMassimoIscritti = null, $oraFine = null, $oraInizio = null, $riga = null, $titolo = null, $titoloTestata = null, $visibilita = null)
    {
        $this
            ->setAnnotazioni($annotazioni)
            ->setAnnotazioniTestata($annotazioniTestata)
            ->setAnnotazioni_Iscrizione($annotazioni_Iscrizione)
            ->setCategoria_Descrizione($categoria_Descrizione)
            ->setCodice($codice)
            ->setData($data)
            ->setData_Iscrizione($data_Iscrizione)
            ->setEsercizio($esercizio)
            ->setNumeratore($numeratore)
            ->setNumero($numero)
            ->setNumeroIscritti($numeroIscritti)
            ->setNumeroMassimoIscritti($numeroMassimoIscritti)
            ->setOraFine($oraFine)
            ->setOraInizio($oraInizio)
            ->setRiga($riga)
            ->setTitolo($titolo)
            ->setTitoloTestata($titoloTestata)
            ->setVisibilita($visibilita);
    }
    /**
     * Get Annotazioni value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAnnotazioni()
    {
        return isset($this->Annotazioni) ? $this->Annotazioni : null;
    }
    /**
     * Set Annotazioni value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $annotazioni
     * @return \Service\StructType\Corso
     */
    public function setAnnotazioni($annotazioni = null)
    {
        // validation for constraint: string
        if (!is_null($annotazioni) && !is_string($annotazioni)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($annotazioni, true), gettype($annotazioni)), __LINE__);
        }
        if (is_null($annotazioni) || (is_array($annotazioni) && empty($annotazioni))) {
            unset($this->Annotazioni);
        } else {
            $this->Annotazioni = $annotazioni;
        }
        return $this;
    }
    /**
     * Get AnnotazioniTestata value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAnnotazioniTestata()
    {
        return isset($this->AnnotazioniTestata) ? $this->AnnotazioniTestata : null;
    }
    /**
     * Set AnnotazioniTestata value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $annotazioniTestata
     * @return \Service\StructType\Corso
     */
    public function setAnnotazioniTestata($annotazioniTestata = null)
    {
        // validation for constraint: string
        if (!is_null($annotazioniTestata) && !is_string($annotazioniTestata)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($annotazioniTestata, true), gettype($annotazioniTestata)), __LINE__);
        }
        if (is_null($annotazioniTestata) || (is_array($annotazioniTestata) && empty($annotazioniTestata))) {
            unset($this->AnnotazioniTestata);
        } else {
            $this->AnnotazioniTestata = $annotazioniTestata;
        }
        return $this;
    }
    /**
     * Get Annotazioni_Iscrizione value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAnnotazioni_Iscrizione()
    {
        return isset($this->Annotazioni_Iscrizione) ? $this->Annotazioni_Iscrizione : null;
    }
    /**
     * Set Annotazioni_Iscrizione value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $annotazioni_Iscrizione
     * @return \Service\StructType\Corso
     */
    public function setAnnotazioni_Iscrizione($annotazioni_Iscrizione = null)
    {
        // validation for constraint: string
        if (!is_null($annotazioni_Iscrizione) && !is_string($annotazioni_Iscrizione)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($annotazioni_Iscrizione, true), gettype($annotazioni_Iscrizione)), __LINE__);
        }
        if (is_null($annotazioni_Iscrizione) || (is_array($annotazioni_Iscrizione) && empty($annotazioni_Iscrizione))) {
            unset($this->Annotazioni_Iscrizione);
        } else {
            $this->Annotazioni_Iscrizione = $annotazioni_Iscrizione;
        }
        return $this;
    }
    /**
     * Get Categoria_Descrizione value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCategoria_Descrizione()
    {
        return isset($this->Categoria_Descrizione) ? $this->Categoria_Descrizione : null;
    }
    /**
     * Set Categoria_Descrizione value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $categoria_Descrizione
     * @return \Service\StructType\Corso
     */
    public function setCategoria_Descrizione($categoria_Descrizione = null)
    {
        // validation for constraint: string
        if (!is_null($categoria_Descrizione) && !is_string($categoria_Descrizione)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($categoria_Descrizione, true), gettype($categoria_Descrizione)), __LINE__);
        }
        if (is_null($categoria_Descrizione) || (is_array($categoria_Descrizione) && empty($categoria_Descrizione))) {
            unset($this->Categoria_Descrizione);
        } else {
            $this->Categoria_Descrizione = $categoria_Descrizione;
        }
        return $this;
    }
    /**
     * Get Codice value
     * @return int|null
     */
    public function getCodice()
    {
        return $this->Codice;
    }
    /**
     * Set Codice value
     * @param int $codice
     * @return \Service\StructType\Corso
     */
    public function setCodice($codice = null)
    {
        // validation for constraint: int
        if (!is_null($codice) && !(is_int($codice) || ctype_digit($codice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codice, true), gettype($codice)), __LINE__);
        }
        $this->Codice = $codice;
        return $this;
    }
    /**
     * Get Data value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getData()
    {
        return isset($this->Data) ? $this->Data : null;
    }
    /**
     * Set Data value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $data
     * @return \Service\StructType\Corso
     */
    public function setData($data = null)
    {
        // validation for constraint: string
        if (!is_null($data) && !is_string($data)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($data, true), gettype($data)), __LINE__);
        }
        if (is_null($data) || (is_array($data) && empty($data))) {
            unset($this->Data);
        } else {
            $this->Data = $data;
        }
        return $this;
    }
    /**
     * Get Data_Iscrizione value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getData_Iscrizione()
    {
        return isset($this->Data_Iscrizione) ? $this->Data_Iscrizione : null;
    }
    /**
     * Set Data_Iscrizione value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $data_Iscrizione
     * @return \Service\StructType\Corso
     */
    public function setData_Iscrizione($data_Iscrizione = null)
    {
        // validation for constraint: string
        if (!is_null($data_Iscrizione) && !is_string($data_Iscrizione)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($data_Iscrizione, true), gettype($data_Iscrizione)), __LINE__);
        }
        if (is_null($data_Iscrizione) || (is_array($data_Iscrizione) && empty($data_Iscrizione))) {
            unset($this->Data_Iscrizione);
        } else {
            $this->Data_Iscrizione = $data_Iscrizione;
        }
        return $this;
    }
    /**
     * Get Esercizio value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEsercizio()
    {
        return isset($this->Esercizio) ? $this->Esercizio : null;
    }
    /**
     * Set Esercizio value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $esercizio
     * @return \Service\StructType\Corso
     */
    public function setEsercizio($esercizio = null)
    {
        // validation for constraint: string
        if (!is_null($esercizio) && !is_string($esercizio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($esercizio, true), gettype($esercizio)), __LINE__);
        }
        if (is_null($esercizio) || (is_array($esercizio) && empty($esercizio))) {
            unset($this->Esercizio);
        } else {
            $this->Esercizio = $esercizio;
        }
        return $this;
    }
    /**
     * Get Numeratore value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNumeratore()
    {
        return isset($this->Numeratore) ? $this->Numeratore : null;
    }
    /**
     * Set Numeratore value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $numeratore
     * @return \Service\StructType\Corso
     */
    public function setNumeratore($numeratore = null)
    {
        // validation for constraint: string
        if (!is_null($numeratore) && !is_string($numeratore)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numeratore, true), gettype($numeratore)), __LINE__);
        }
        if (is_null($numeratore) || (is_array($numeratore) && empty($numeratore))) {
            unset($this->Numeratore);
        } else {
            $this->Numeratore = $numeratore;
        }
        return $this;
    }
    /**
     * Get Numero value
     * @return int|null
     */
    public function getNumero()
    {
        return $this->Numero;
    }
    /**
     * Set Numero value
     * @param int $numero
     * @return \Service\StructType\Corso
     */
    public function setNumero($numero = null)
    {
        // validation for constraint: int
        if (!is_null($numero) && !(is_int($numero) || ctype_digit($numero))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numero, true), gettype($numero)), __LINE__);
        }
        $this->Numero = $numero;
        return $this;
    }
    /**
     * Get NumeroIscritti value
     * @return int|null
     */
    public function getNumeroIscritti()
    {
        return $this->NumeroIscritti;
    }
    /**
     * Set NumeroIscritti value
     * @param int $numeroIscritti
     * @return \Service\StructType\Corso
     */
    public function setNumeroIscritti($numeroIscritti = null)
    {
        // validation for constraint: int
        if (!is_null($numeroIscritti) && !(is_int($numeroIscritti) || ctype_digit($numeroIscritti))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numeroIscritti, true), gettype($numeroIscritti)), __LINE__);
        }
        $this->NumeroIscritti = $numeroIscritti;
        return $this;
    }
    /**
     * Get NumeroMassimoIscritti value
     * @return int|null
     */
    public function getNumeroMassimoIscritti()
    {
        return $this->NumeroMassimoIscritti;
    }
    /**
     * Set NumeroMassimoIscritti value
     * @param int $numeroMassimoIscritti
     * @return \Service\StructType\Corso
     */
    public function setNumeroMassimoIscritti($numeroMassimoIscritti = null)
    {
        // validation for constraint: int
        if (!is_null($numeroMassimoIscritti) && !(is_int($numeroMassimoIscritti) || ctype_digit($numeroMassimoIscritti))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numeroMassimoIscritti, true), gettype($numeroMassimoIscritti)), __LINE__);
        }
        $this->NumeroMassimoIscritti = $numeroMassimoIscritti;
        return $this;
    }
    /**
     * Get OraFine value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOraFine()
    {
        return isset($this->OraFine) ? $this->OraFine : null;
    }
    /**
     * Set OraFine value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $oraFine
     * @return \Service\StructType\Corso
     */
    public function setOraFine($oraFine = null)
    {
        // validation for constraint: string
        if (!is_null($oraFine) && !is_string($oraFine)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oraFine, true), gettype($oraFine)), __LINE__);
        }
        if (is_null($oraFine) || (is_array($oraFine) && empty($oraFine))) {
            unset($this->OraFine);
        } else {
            $this->OraFine = $oraFine;
        }
        return $this;
    }
    /**
     * Get OraInizio value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOraInizio()
    {
        return isset($this->OraInizio) ? $this->OraInizio : null;
    }
    /**
     * Set OraInizio value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $oraInizio
     * @return \Service\StructType\Corso
     */
    public function setOraInizio($oraInizio = null)
    {
        // validation for constraint: string
        if (!is_null($oraInizio) && !is_string($oraInizio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oraInizio, true), gettype($oraInizio)), __LINE__);
        }
        if (is_null($oraInizio) || (is_array($oraInizio) && empty($oraInizio))) {
            unset($this->OraInizio);
        } else {
            $this->OraInizio = $oraInizio;
        }
        return $this;
    }
    /**
     * Get Riga value
     * @return int|null
     */
    public function getRiga()
    {
        return $this->Riga;
    }
    /**
     * Set Riga value
     * @param int $riga
     * @return \Service\StructType\Corso
     */
    public function setRiga($riga = null)
    {
        // validation for constraint: int
        if (!is_null($riga) && !(is_int($riga) || ctype_digit($riga))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($riga, true), gettype($riga)), __LINE__);
        }
        $this->Riga = $riga;
        return $this;
    }
    /**
     * Get Titolo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTitolo()
    {
        return isset($this->Titolo) ? $this->Titolo : null;
    }
    /**
     * Set Titolo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $titolo
     * @return \Service\StructType\Corso
     */
    public function setTitolo($titolo = null)
    {
        // validation for constraint: string
        if (!is_null($titolo) && !is_string($titolo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($titolo, true), gettype($titolo)), __LINE__);
        }
        if (is_null($titolo) || (is_array($titolo) && empty($titolo))) {
            unset($this->Titolo);
        } else {
            $this->Titolo = $titolo;
        }
        return $this;
    }
    /**
     * Get TitoloTestata value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTitoloTestata()
    {
        return isset($this->TitoloTestata) ? $this->TitoloTestata : null;
    }
    /**
     * Set TitoloTestata value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $titoloTestata
     * @return \Service\StructType\Corso
     */
    public function setTitoloTestata($titoloTestata = null)
    {
        // validation for constraint: string
        if (!is_null($titoloTestata) && !is_string($titoloTestata)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($titoloTestata, true), gettype($titoloTestata)), __LINE__);
        }
        if (is_null($titoloTestata) || (is_array($titoloTestata) && empty($titoloTestata))) {
            unset($this->TitoloTestata);
        } else {
            $this->TitoloTestata = $titoloTestata;
        }
        return $this;
    }
    /**
     * Get Visibilita value
     * @return int|null
     */
    public function getVisibilita()
    {
        return $this->Visibilita;
    }
    /**
     * Set Visibilita value
     * @param int $visibilita
     * @return \Service\StructType\Corso
     */
    public function setVisibilita($visibilita = null)
    {
        // validation for constraint: int
        if (!is_null($visibilita) && !(is_int($visibilita) || ctype_digit($visibilita))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($visibilita, true), gettype($visibilita)), __LINE__);
        }
        $this->Visibilita = $visibilita;
        return $this;
    }
}
