<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Privacy_Model StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Privacy_Model
 * @subpackage Structs
 */
class Privacy_Model extends AbstractStructBase
{
    /**
     * The AnniScadenza
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $AnniScadenza;
    /**
     * The DataScadenza
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DataScadenza;
    /**
     * The Descrizione
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Descrizione;
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ID;
    /**
     * The Obbligatoria
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Obbligatoria;
    /**
     * The TipoScadenza
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TipoScadenza;
    /**
     * Constructor method for Privacy_Model
     * @uses Privacy_Model::setAnniScadenza()
     * @uses Privacy_Model::setDataScadenza()
     * @uses Privacy_Model::setDescrizione()
     * @uses Privacy_Model::setID()
     * @uses Privacy_Model::setObbligatoria()
     * @uses Privacy_Model::setTipoScadenza()
     * @param int $anniScadenza
     * @param string $dataScadenza
     * @param string $descrizione
     * @param int $iD
     * @param bool $obbligatoria
     * @param string $tipoScadenza
     */
    public function __construct($anniScadenza = null, $dataScadenza = null, $descrizione = null, $iD = null, $obbligatoria = null, $tipoScadenza = null)
    {
        $this
            ->setAnniScadenza($anniScadenza)
            ->setDataScadenza($dataScadenza)
            ->setDescrizione($descrizione)
            ->setID($iD)
            ->setObbligatoria($obbligatoria)
            ->setTipoScadenza($tipoScadenza);
    }
    /**
     * Get AnniScadenza value
     * @return int|null
     */
    public function getAnniScadenza()
    {
        return $this->AnniScadenza;
    }
    /**
     * Set AnniScadenza value
     * @param int $anniScadenza
     * @return \StructType\Privacy_Model
     */
    public function setAnniScadenza($anniScadenza = null)
    {
        // validation for constraint: int
        if (!is_null($anniScadenza) && !(is_int($anniScadenza) || ctype_digit($anniScadenza))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($anniScadenza, true), gettype($anniScadenza)), __LINE__);
        }
        $this->AnniScadenza = $anniScadenza;
        return $this;
    }
    /**
     * Get DataScadenza value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDataScadenza()
    {
        return isset($this->DataScadenza) ? $this->DataScadenza : null;
    }
    /**
     * Set DataScadenza value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dataScadenza
     * @return \StructType\Privacy_Model
     */
    public function setDataScadenza($dataScadenza = null)
    {
        // validation for constraint: string
        if (!is_null($dataScadenza) && !is_string($dataScadenza)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataScadenza, true), gettype($dataScadenza)), __LINE__);
        }
        if (is_null($dataScadenza) || (is_array($dataScadenza) && empty($dataScadenza))) {
            unset($this->DataScadenza);
        } else {
            $this->DataScadenza = $dataScadenza;
        }
        return $this;
    }
    /**
     * Get Descrizione value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescrizione()
    {
        return isset($this->Descrizione) ? $this->Descrizione : null;
    }
    /**
     * Set Descrizione value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $descrizione
     * @return \StructType\Privacy_Model
     */
    public function setDescrizione($descrizione = null)
    {
        // validation for constraint: string
        if (!is_null($descrizione) && !is_string($descrizione)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descrizione, true), gettype($descrizione)), __LINE__);
        }
        if (is_null($descrizione) || (is_array($descrizione) && empty($descrizione))) {
            unset($this->Descrizione);
        } else {
            $this->Descrizione = $descrizione;
        }
        return $this;
    }
    /**
     * Get ID value
     * @return int|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\Privacy_Model
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !(is_int($iD) || ctype_digit($iD))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Obbligatoria value
     * @return bool|null
     */
    public function getObbligatoria()
    {
        return $this->Obbligatoria;
    }
    /**
     * Set Obbligatoria value
     * @param bool $obbligatoria
     * @return \StructType\Privacy_Model
     */
    public function setObbligatoria($obbligatoria = null)
    {
        // validation for constraint: boolean
        if (!is_null($obbligatoria) && !is_bool($obbligatoria)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($obbligatoria, true), gettype($obbligatoria)), __LINE__);
        }
        $this->Obbligatoria = $obbligatoria;
        return $this;
    }
    /**
     * Get TipoScadenza value
     * @return string|null
     */
    public function getTipoScadenza()
    {
        return $this->TipoScadenza;
    }
    /**
     * Set TipoScadenza value
     * @uses \EnumType\TipoScadenzaPrivacy::valueIsValid()
     * @uses \EnumType\TipoScadenzaPrivacy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tipoScadenza
     * @return \StructType\Privacy_Model
     */
    public function setTipoScadenza($tipoScadenza = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TipoScadenzaPrivacy::valueIsValid($tipoScadenza)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TipoScadenzaPrivacy', is_array($tipoScadenza) ? implode(', ', $tipoScadenza) : var_export($tipoScadenza, true), implode(', ', \EnumType\TipoScadenzaPrivacy::getValidValues())), __LINE__);
        }
        $this->TipoScadenza = $tipoScadenza;
        return $this;
    }
}
