<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NotificaClient StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:NotificaClient
 * @subpackage Structs
 */
class NotificaClient extends Notifica
{
    /**
     * The DataInserimento
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DataInserimento;
    /**
     * The Letta
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Letta;
    /**
     * The Notificata
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Notificata;
    /**
     * Constructor method for NotificaClient
     * @uses NotificaClient::setDataInserimento()
     * @uses NotificaClient::setLetta()
     * @uses NotificaClient::setNotificata()
     * @param string $dataInserimento
     * @param bool $letta
     * @param bool $notificata
     */
    public function __construct($dataInserimento = null, $letta = null, $notificata = null)
    {
        $this
            ->setDataInserimento($dataInserimento)
            ->setLetta($letta)
            ->setNotificata($notificata);
    }
    /**
     * Get DataInserimento value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDataInserimento()
    {
        return isset($this->DataInserimento) ? $this->DataInserimento : null;
    }
    /**
     * Set DataInserimento value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dataInserimento
     * @return \StructType\NotificaClient
     */
    public function setDataInserimento($dataInserimento = null)
    {
        // validation for constraint: string
        if (!is_null($dataInserimento) && !is_string($dataInserimento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataInserimento, true), gettype($dataInserimento)), __LINE__);
        }
        if (is_null($dataInserimento) || (is_array($dataInserimento) && empty($dataInserimento))) {
            unset($this->DataInserimento);
        } else {
            $this->DataInserimento = $dataInserimento;
        }
        return $this;
    }
    /**
     * Get Letta value
     * @return bool|null
     */
    public function getLetta()
    {
        return $this->Letta;
    }
    /**
     * Set Letta value
     * @param bool $letta
     * @return \StructType\NotificaClient
     */
    public function setLetta($letta = null)
    {
        // validation for constraint: boolean
        if (!is_null($letta) && !is_bool($letta)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($letta, true), gettype($letta)), __LINE__);
        }
        $this->Letta = $letta;
        return $this;
    }
    /**
     * Get Notificata value
     * @return bool|null
     */
    public function getNotificata()
    {
        return $this->Notificata;
    }
    /**
     * Set Notificata value
     * @param bool $notificata
     * @return \StructType\NotificaClient
     */
    public function setNotificata($notificata = null)
    {
        // validation for constraint: boolean
        if (!is_null($notificata) && !is_bool($notificata)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($notificata, true), gettype($notificata)), __LINE__);
        }
        $this->Notificata = $notificata;
        return $this;
    }
}
