<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetTurniOperatore StructType
 * @subpackage Structs
 */
class GetTurniOperatore extends AbstractStructBase
{
    /**
     * The IDAnagrafe
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IDAnagrafe;
    /**
     * The DaData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DaData;
    /**
     * The IDTestata
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IDTestata;
    /**
     * Constructor method for GetTurniOperatore
     * @uses GetTurniOperatore::setIDAnagrafe()
     * @uses GetTurniOperatore::setDaData()
     * @uses GetTurniOperatore::setIDTestata()
     * @param int $iDAnagrafe
     * @param string $daData
     * @param int $iDTestata
     */
    public function __construct($iDAnagrafe = null, $daData = null, $iDTestata = null)
    {
        $this
            ->setIDAnagrafe($iDAnagrafe)
            ->setDaData($daData)
            ->setIDTestata($iDTestata);
    }
    /**
     * Get IDAnagrafe value
     * @return int|null
     */
    public function getIDAnagrafe()
    {
        return $this->IDAnagrafe;
    }
    /**
     * Set IDAnagrafe value
     * @param int $iDAnagrafe
     * @return \StructType\GetTurniOperatore
     */
    public function setIDAnagrafe($iDAnagrafe = null)
    {
        // validation for constraint: int
        if (!is_null($iDAnagrafe) && !(is_int($iDAnagrafe) || ctype_digit($iDAnagrafe))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iDAnagrafe, true), gettype($iDAnagrafe)), __LINE__);
        }
        $this->IDAnagrafe = $iDAnagrafe;
        return $this;
    }
    /**
     * Get DaData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDaData()
    {
        return isset($this->DaData) ? $this->DaData : null;
    }
    /**
     * Set DaData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $daData
     * @return \StructType\GetTurniOperatore
     */
    public function setDaData($daData = null)
    {
        // validation for constraint: string
        if (!is_null($daData) && !is_string($daData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($daData, true), gettype($daData)), __LINE__);
        }
        if (is_null($daData) || (is_array($daData) && empty($daData))) {
            unset($this->DaData);
        } else {
            $this->DaData = $daData;
        }
        return $this;
    }
    /**
     * Get IDTestata value
     * @return int|null
     */
    public function getIDTestata()
    {
        return $this->IDTestata;
    }
    /**
     * Set IDTestata value
     * @param int $iDTestata
     * @return \StructType\GetTurniOperatore
     */
    public function setIDTestata($iDTestata = null)
    {
        // validation for constraint: int
        if (!is_null($iDTestata) && !(is_int($iDTestata) || ctype_digit($iDTestata))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iDTestata, true), gettype($iDTestata)), __LINE__);
        }
        $this->IDTestata = $iDTestata;
        return $this;
    }
}
