<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetConfigurazione StructType
 * @subpackage Structs
 */
class GetConfigurazione extends AbstractStructBase
{
    /**
     * The iIDAnagrafica
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $iIDAnagrafica;
    /**
     * Constructor method for GetConfigurazione
     * @uses GetConfigurazione::setIIDAnagrafica()
     * @param int $iIDAnagrafica
     */
    public function __construct($iIDAnagrafica = null)
    {
        $this
            ->setIIDAnagrafica($iIDAnagrafica);
    }
    /**
     * Get iIDAnagrafica value
     * @return int|null
     */
    public function getIIDAnagrafica()
    {
        return $this->iIDAnagrafica;
    }
    /**
     * Set iIDAnagrafica value
     * @param int $iIDAnagrafica
     * @return \StructType\GetConfigurazione
     */
    public function setIIDAnagrafica($iIDAnagrafica = null)
    {
        // validation for constraint: int
        if (!is_null($iIDAnagrafica) && !(is_int($iIDAnagrafica) || ctype_digit($iIDAnagrafica))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iIDAnagrafica, true), gettype($iIDAnagrafica)), __LINE__);
        }
        $this->iIDAnagrafica = $iIDAnagrafica;
        return $this;
    }
}
