<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Update ServiceType
 * @subpackage Services
 */
class Update extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named UpdateUser
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateUser $parameters
     * @return \StructType\UpdateUserResponse|bool
     */
    public function UpdateUser(\StructType\UpdateUser $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateUser($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateUserProfilePhoto
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateUserProfilePhoto $parameters
     * @return \StructType\UpdateUserProfilePhotoResponse|bool
     */
    public function UpdateUserProfilePhoto(\StructType\UpdateUserProfilePhoto $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateUserProfilePhoto($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateRichiestaCartellino
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateRichiestaCartellino $parameters
     * @return \StructType\UpdateRichiestaCartellinoResponse|bool
     */
    public function UpdateRichiestaCartellino(\StructType\UpdateRichiestaCartellino $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateRichiestaCartellino($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\UpdateRichiestaCartellinoResponse|\StructType\UpdateUserProfilePhotoResponse|\StructType\UpdateUserResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
